/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.mina;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.core.PackHandlerManagement;
import com.zhoyq.server.jt808.starter.core.SessionManagement;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MinaSessionHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MinaSessionHandler.class);
    private PackHandlerManagement packHandlerManagement;
    private Jt808Config jt808Config;
    private Jt808Helper jt808Helper;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private SessionManagement sessionManagement;
    private CacheService cacheService;

    public void sessionIdle(IoSession session, IdleStatus idleStatus) {
        log.debug("session idle width {} ", (Object)session.getId());
        if (session.getIdleCount(idleStatus) > this.jt808Config.getIdleCount()) {
            session.closeNow();
        }
    }

    public void exceptionCaught(IoSession session, Throwable throwable) {
        log.debug("session exception with {}", (Object)session.getId());
        log.warn(throwable.getMessage());
        session.closeNow();
    }

    public void messageReceived(IoSession session, Object msg) {
        int msgLen;
        IoSession preSession;
        String phone;
        byte[] phoneNum;
        byte[] originData = (byte[])msg;
        log.debug("session received msg with id {} and msg {}", (Object)session.getId(), (Object)Arrays.toString(originData));
        byte[] pkgCount = null;
        byte[] pkgNum = null;
        byte[] res = null;
        int offset = 0;
        byte[] msgId = new byte[]{originData[offset++], originData[offset++]};
        byte[] msgBodyProp = new byte[]{originData[offset++], originData[offset++]};
        boolean isVersion2019 = this.jt808Helper.isVersion2019(msgBodyProp);
        if (isVersion2019) {
            byte[] protocolVersion = new byte[]{originData[offset++]};
            phoneNum = new byte[]{originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++]};
        } else {
            phoneNum = new byte[]{originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++]};
        }
        byte[] streamNum = new byte[]{originData[offset++], originData[offset++]};
        boolean hasPackage = this.jt808Helper.hasPackage(msgBodyProp);
        if (hasPackage) {
            pkgCount = new byte[]{originData[offset++], originData[offset++]};
            pkgNum = new byte[]{originData[offset++], originData[offset]};
        }
        if (this.sessionManagement.contains(phone = this.byteArrHelper.toHexString(phoneNum)) && (preSession = (IoSession)this.sessionManagement.get(phone)).getId() != session.getId()) {
            preSession.closeNow();
        }
        this.sessionManagement.set(phone, session);
        if (hasPackage) {
            int currentPkgNum;
            int totalPkgNum = this.byteArrHelper.twobyte2int(pkgCount);
            if (totalPkgNum >= (currentPkgNum = this.byteArrHelper.twobyte2int(pkgNum))) {
                if (!this.cacheService.containsPackages(phone)) {
                    ConcurrentHashMap<Integer, byte[]> buf = new ConcurrentHashMap<Integer, byte[]>(totalPkgNum);
                    this.cacheService.setPackages(phone, buf);
                }
                Map<Integer, byte[]> pkgBuf = this.cacheService.getPackages(phone);
                pkgBuf.put(currentPkgNum, originData);
            }
            if (totalPkgNum == currentPkgNum) {
                if (this.jt808Helper.pkgAllReceived(phone, totalPkgNum)) {
                    res = this.data(this.jt808Helper.allPkg(phone, totalPkgNum));
                } else {
                    byte[] originStreamNum = null;
                    byte[] idList = new byte[]{};
                    byte num = 0;
                    Map<Integer, byte[]> map = this.cacheService.getPackages(phone);
                    for (int i = 1; i <= totalPkgNum; ++i) {
                        if (originStreamNum == null) {
                            originStreamNum = isVersion2019 ? this.byteArrHelper.subByte(map.get(1), 15, 17) : this.byteArrHelper.subByte(map.get(1), 10, 12);
                        }
                        if (map.containsKey(i)) continue;
                        num = (byte)(num + 1);
                        idList = isVersion2019 ? this.byteArrHelper.union(idList, this.byteArrHelper.subByte(map.get(i), 19, 21)) : this.byteArrHelper.union(idList, this.byteArrHelper.subByte(map.get(i), 14, 16));
                    }
                    if (originStreamNum != null) {
                        res = this.resHelper.getPkgReq(phoneNum, originStreamNum, num, idList);
                    }
                }
            }
        } else {
            res = this.data(originData);
        }
        if (res == null) {
            res = this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
        }
        if (res.length > (msgLen = this.jt808Config.getPackageLength().intValue())) {
            this.jt808Helper.sentByPkg(res, session);
        } else {
            session.write((Object)res);
        }
    }

    private byte[] data(byte[] originData) {
        byte[] msgBody;
        int offset = 0;
        byte[] msgId = new byte[]{originData[offset++], originData[offset++]};
        byte[] msgBodyProp = new byte[]{originData[offset++], originData[offset++]};
        byte[] phoneNum = null;
        if (this.jt808Helper.isVersion2019(msgBodyProp)) {
            byte[] byArray = new byte[10];
            int n = ++offset;
            byArray[0] = originData[n];
            int n2 = ++offset;
            byArray[1] = originData[n2];
            int n3 = ++offset;
            byArray[2] = originData[n3];
            int n4 = ++offset;
            byArray[3] = originData[n4];
            int n5 = ++offset;
            byArray[4] = originData[n5];
            int n6 = ++offset;
            byArray[5] = originData[n6];
            int n7 = ++offset;
            byArray[6] = originData[n7];
            int n8 = ++offset;
            byArray[7] = originData[n8];
            int n9 = ++offset;
            byArray[8] = originData[n9];
            int n10 = ++offset;
            byArray[9] = originData[n10];
            phoneNum = byArray;
        } else {
            phoneNum = new byte[]{originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++], originData[offset++]};
        }
        byte[] byArray = new byte[2];
        int n = ++offset;
        byArray[0] = originData[n];
        int n11 = ++offset;
        ++offset;
        byArray[1] = originData[n11];
        byte[] streamNum = byArray;
        int msgLen = this.jt808Config.getPackageLength();
        if (originData.length > msgLen) {
            msgBody = this.byteArrHelper.subByte(originData, offset);
        } else {
            int bodyLength = originData.length - 1 - offset;
            msgBody = new byte[bodyLength];
            for (int i = 0; i < msgBody.length; ++i) {
                msgBody[i] = originData[offset++];
            }
        }
        String phone = this.byteArrHelper.toHexString(phoneNum);
        int msgIdInt = this.byteArrHelper.twobyte2int(msgId);
        boolean isAuth = this.cacheService.containsAuth(phone);
        if (this.jt808Config.getAuth().booleanValue()) {
            if (!isAuth) {
                String[] authMsgIds;
                for (String authMsgId : authMsgIds = this.jt808Config.getAuthMsgId().split(",")) {
                    if (authMsgId.length() != 4 || msgIdInt != this.byteArrHelper.twobyte2int(this.byteArrHelper.hexStr2bytes(authMsgId))) continue;
                    isAuth = true;
                    break;
                }
            }
        } else {
            isAuth = true;
        }
        if (!isAuth) {
            return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)1);
        }
        PackHandler handler = this.packHandlerManagement.getPackHandler(msgIdInt);
        return handler.handle(phoneNum, streamNum, msgId, msgBody);
    }

    public MinaSessionHandler(PackHandlerManagement packHandlerManagement, Jt808Config jt808Config, Jt808Helper jt808Helper, ByteArrHelper byteArrHelper, ResHelper resHelper, SessionManagement sessionManagement, CacheService cacheService) {
        this.packHandlerManagement = packHandlerManagement;
        this.jt808Config = jt808Config;
        this.jt808Helper = jt808Helper;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.sessionManagement = sessionManagement;
        this.cacheService = cacheService;
    }
}

