/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.mina;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.core.Jt808Server;
import com.zhoyq.server.jt808.starter.helper.CustomThreadFactory;
import com.zhoyq.server.jt808.starter.mina.coder.Jt808CodecFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jt808_mina_udp")
public class Jt808MinaUdpServer
implements Jt808Server {
    private static final Logger log = LoggerFactory.getLogger(Jt808MinaUdpServer.class);
    private static NioDatagramAcceptor acceptor;
    private Jt808Config jt808Config;
    private IoHandler handler;
    private Jt808CodecFactory jt808CodecFactory;

    @Override
    public boolean start() {
        if (acceptor != null) {
            return acceptor.isActive();
        }
        acceptor = new NioDatagramAcceptor();
        acceptor.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter(this.jt808Config.getCorePoolSize().intValue(), this.jt808Config.getMaximumPoolSize().intValue(), (long)this.jt808Config.getKeepAliveTime().intValue(), TimeUnit.MILLISECONDS, (ThreadFactory)new CustomThreadFactory("jt808-mina-thread-pool")));
        acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)this.jt808CodecFactory));
        acceptor.setHandler(this.handler);
        acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, this.jt808Config.getIdleTime().intValue());
        acceptor.getSessionConfig().setReadBufferSize(this.jt808Config.getReadBufferSize().intValue());
        try {
            acceptor.bind((SocketAddress)new InetSocketAddress(this.jt808Config.getPort()));
            return true;
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean stop() {
        acceptor.dispose(false);
        return false;
    }

    public Jt808MinaUdpServer(Jt808Config jt808Config, IoHandler handler, Jt808CodecFactory jt808CodecFactory) {
        this.jt808Config = jt808Config;
        this.handler = handler;
        this.jt808CodecFactory = jt808CodecFactory;
    }
}

