/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.helper;

import com.zhoyq.server.jt808.starter.dto.CameraInfo;
import com.zhoyq.server.jt808.starter.dto.CandidateAnswer;
import com.zhoyq.server.jt808.starter.dto.CircleArea;
import com.zhoyq.server.jt808.starter.dto.Contact;
import com.zhoyq.server.jt808.starter.dto.Event;
import com.zhoyq.server.jt808.starter.dto.InfoForOrder;
import com.zhoyq.server.jt808.starter.dto.Parameter;
import com.zhoyq.server.jt808.starter.dto.Point;
import com.zhoyq.server.jt808.starter.dto.PolygonArea;
import com.zhoyq.server.jt808.starter.dto.RectangleArea;
import com.zhoyq.server.jt808.starter.dto.Route;
import com.zhoyq.server.jt808.starter.dto.SearchStoredMediaData;
import com.zhoyq.server.jt808.starter.dto.StoredMediaDataUpload;
import com.zhoyq.server.jt808.starter.dto.TerminalUpdatePkg;
import com.zhoyq.server.jt808.starter.dto.TurnPoint;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResHelper {
    private static final Logger log = LoggerFactory.getLogger(ResHelper.class);
    private ByteArrHelper byteArrHelper;
    private Jt808Helper jt808Helper;

    public byte[] warp(byte[] msgId, byte[] phoneNum) {
        int platStreamNum = this.jt808Helper.getPlatStreamNum();
        if (phoneNum.length == 10) {
            return this.byteArrHelper.union(msgId, {64, 0, 1}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)});
        }
        if (phoneNum.length == 6) {
            return this.byteArrHelper.union(msgId, {0, 0}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)});
        }
        return null;
    }

    public byte[] warp(byte[] msgId, byte[] phoneNum, byte[] msgBody) {
        int bodyLen = msgBody.length;
        int platStreamNum = this.jt808Helper.getPlatStreamNum();
        if (phoneNum.length == 10) {
            return this.byteArrHelper.union(msgId, {(byte)(bodyLen >>> 8 & 3 | 0x40), (byte)(bodyLen & 0xFF), 1}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)}, msgBody);
        }
        if (phoneNum.length == 6) {
            return this.byteArrHelper.union(msgId, {(byte)(bodyLen >>> 8 & 3), (byte)(bodyLen & 0xFF)}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)}, msgBody);
        }
        return null;
    }

    public byte[] getPlatAnswer(byte[] phoneNum, byte[] terminalStreamNum, byte[] terminalMsgId, byte by) {
        return this.warp(new byte[]{-128, 1}, phoneNum, this.byteArrHelper.union(terminalStreamNum, terminalMsgId, {by}));
    }

    public byte[] getPkgReq(byte[] phoneNum, byte[] originStreamNum, byte num, byte[] idList) {
        return this.warp(new byte[]{-128, 3}, phoneNum, this.byteArrHelper.union(originStreamNum, {num}, idList));
    }

    public byte[] getTerminalRegisterAnswer(byte[] phoneNum, byte[] terminalStreamNum, byte result, String auth) {
        byte[] e;
        if (result == 0) {
            try {
                e = this.byteArrHelper.union(new byte[]{result}, auth.getBytes("GBK"));
            }
            catch (UnsupportedEncodingException e1) {
                log.warn(e1.getMessage());
                e = new byte[]{5};
            }
        } else {
            e = new byte[]{result};
        }
        return this.warp(new byte[]{-127, 0}, phoneNum, this.byteArrHelper.union(terminalStreamNum, e));
    }

    public byte[] setTerminalParameters(byte[] phoneNum, byte num, List<Parameter> list) {
        byte[] buf = new byte[]{num};
        for (Parameter p : list) {
            buf = this.byteArrHelper.union(buf, p.getParameterId());
            buf = this.byteArrHelper.union(buf, new byte[]{p.getLength()});
            buf = this.byteArrHelper.union(buf, p.getValue());
        }
        return this.warp(new byte[]{-127, 0}, phoneNum, buf);
    }

    public byte[] searchTerminalParameters(byte[] phoneNum) {
        return this.warp(new byte[]{-127, 4}, phoneNum);
    }

    public byte[] terminalControll(byte[] phoneNum, byte comm, byte[] value) {
        byte[] answer = comm == 1 || comm == 2 ? this.byteArrHelper.union(new byte[]{comm}, value) : new byte[]{comm};
        return this.warp(new byte[0], phoneNum, answer);
    }

    public byte[] searchSpecifyTerminalParameters(byte[] phoneNum, byte num, byte[] parameters) {
        return this.warp(new byte[]{-127, 6}, phoneNum, this.byteArrHelper.union(new byte[]{num}, parameters));
    }

    public byte[] searchTerminalProps(byte[] phoneNum) {
        return this.warp(new byte[]{-127, 7}, phoneNum);
    }

    public byte[] sentTerminalUpdatePkg(byte[] phoneNum, TerminalUpdatePkg tup) {
        return this.warp(new byte[]{-127, 8}, phoneNum, this.byteArrHelper.union({tup.getUpdateType()}, tup.getProducerId(), {tup.getVersionLength()}, tup.getVersion(), tup.getDataLength(), tup.getData()));
    }

    public byte[] searchLocationInfo(byte[] phoneNum) {
        return this.warp(new byte[]{-126, 1}, phoneNum);
    }

    public byte[] temporaryLocationTrace(byte[] phoneNum, byte[] space, byte[] date) {
        return this.warp(new byte[]{-126, 2}, phoneNum, this.byteArrHelper.union(space, date));
    }

    public byte[] makeSureAlarms(byte[] phoneNum, byte[] alarmStreamNum, byte[] alarmType) {
        return this.warp(new byte[]{-126, 3}, phoneNum, this.byteArrHelper.union(alarmStreamNum, alarmType));
    }

    public byte[] sentTextInfo(byte[] phoneNum, byte sign, String text) {
        byte[] str;
        try {
            str = text.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
            str = new byte[]{};
        }
        return this.warp(new byte[]{-125, 0}, phoneNum, this.byteArrHelper.union(new byte[]{sign}, str));
    }

    public byte[] setEvent(byte[] phoneNum, byte type, byte num, List<Event> list) {
        byte[] buf = new byte[]{};
        for (Event e : list) {
            byte[] buff = this.byteArrHelper.union(new byte[]{e.getId(), e.getLength()}, e.getContent());
            buf = this.byteArrHelper.union(buf, buff);
        }
        return this.warp(new byte[]{-125, 1}, phoneNum, this.byteArrHelper.union(new byte[]{type, num}, buf));
    }

    public byte[] sentQuestion(byte[] phoneNum, byte sign, byte length, String question, List<CandidateAnswer> list) {
        byte[] ques;
        try {
            ques = question.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
            ques = new byte[]{};
        }
        byte[] buf = new byte[]{};
        for (CandidateAnswer c : list) {
            byte[] buff = this.byteArrHelper.union({c.getId()}, c.getLength(), c.getContent());
            buf = this.byteArrHelper.union(buf, buff);
        }
        return this.warp(new byte[]{-125, 2}, phoneNum, this.byteArrHelper.union({sign, length}, ques, buf));
    }

    public byte[] setInfoOrderMenu(byte[] phoneNum, byte type, byte num, List<InfoForOrder> list) {
        byte[] buf = new byte[]{};
        for (InfoForOrder i : list) {
            byte[] buff = this.byteArrHelper.union({i.getType()}, i.getLength(), i.getName());
            buf = this.byteArrHelper.union(buf, buff);
        }
        return this.warp(new byte[]{-125, 3}, phoneNum, this.byteArrHelper.union(new byte[]{type, num}, buf));
    }

    public byte[] InfoService(byte[] phoneNum, byte type, byte[] length, String content) {
        byte[] str;
        try {
            str = content.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
            str = new byte[]{};
        }
        return this.warp(new byte[]{-125, 4}, phoneNum, this.byteArrHelper.union({type}, length, str));
    }

    public byte[] telephoneCallBack(byte[] phoneNum, byte sign, String tel) {
        byte[] str;
        try {
            str = tel.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
            str = new byte[]{};
        }
        return this.warp(new byte[]{-124, 0}, phoneNum, this.byteArrHelper.union(new byte[]{sign}, str));
    }

    public byte[] setTelBook(byte[] phoneNum, byte type, byte num, List<Contact> list) {
        byte[] buf = new byte[]{};
        for (Contact c : list) {
            byte[] buf1 = this.byteArrHelper.union(new byte[]{c.getSign(), c.getPhoneNumLength()}, c.getPhoneNum());
            byte[] buf2 = this.byteArrHelper.union(buf1, new byte[]{c.getNameLength()});
            byte[] buf3 = this.byteArrHelper.union(buf2, c.getName());
            buf = this.byteArrHelper.union(buf, buf3);
        }
        return this.warp(new byte[]{-124, 1}, phoneNum, this.byteArrHelper.union(new byte[]{type, num}, buf));
    }

    public byte[] vehicleControll(byte[] phoneNum, byte controllSign) {
        return this.warp(new byte[]{-123, 0}, phoneNum, new byte[]{controllSign});
    }

    public byte[] setCircleArea(byte[] phoneNum, byte prop, byte num, List<CircleArea> list) {
        byte[] buf = new byte[]{};
        for (CircleArea c : list) {
            buf = this.byteArrHelper.union(buf, c.getId(), c.getProp(), c.getLat(), c.getLon(), c.getRadius(), c.getBeginTime(), c.getEndTime(), c.getHighestSpeed(), {c.getOverSpeedTime()});
        }
        return this.warp(new byte[]{-122, 0}, phoneNum, this.byteArrHelper.union(new byte[]{prop, num}, buf));
    }

    public byte[] delCircleArea(byte[] phoneNum, byte areaNum, byte[] areaIds) {
        return this.warp(new byte[]{-122, 1}, phoneNum, this.byteArrHelper.union(new byte[]{areaNum}, areaIds));
    }

    public byte[] setRectangleArea(byte[] phoneNum, byte prop, byte num, List<RectangleArea> list) {
        byte[] buf = new byte[]{};
        for (RectangleArea r : list) {
            buf = this.byteArrHelper.union(buf, r.getId(), r.getProp(), r.getLeftUpLat(), r.getLeftUpLon(), r.getRightDownLat(), r.getRightDownLon(), r.getBeginTime(), r.getEndTime(), r.getHighestSpeed(), {r.getOverSpeedTime()});
        }
        return this.warp(new byte[]{-122, 2}, phoneNum, this.byteArrHelper.union(new byte[]{prop, num}, buf));
    }

    public byte[] delRectangleArea(byte[] phoneNum, byte num, byte[] areaIds) {
        return this.warp(new byte[]{-122, 3}, phoneNum, this.byteArrHelper.union(new byte[]{num}, areaIds));
    }

    public byte[] setPolygonArea(byte[] phoneNum, PolygonArea p) {
        byte[] buf = this.byteArrHelper.union(p.getId(), p.getProp(), p.getBeginTime(), p.getEndTime(), p.getHighestSpeed(), {p.getOverSpeedTime()}, p.getPointNum());
        for (Point po : p.getList()) {
            buf = this.byteArrHelper.union(buf, po.getLat(), po.getLon());
        }
        return this.warp(new byte[]{-122, 4}, phoneNum, buf);
    }

    public byte[] delPolygonArea(byte[] phoneNum, byte num, byte[] areaIds) {
        return this.warp(new byte[]{-122, 5}, phoneNum, this.byteArrHelper.union(new byte[]{num}, areaIds));
    }

    public byte[] setRoute(byte[] phoneNum, Route route) {
        byte[] buf = this.byteArrHelper.union(route.getId(), route.getProp(), route.getBeginTime(), route.getEndTime(), route.getPointNum());
        for (TurnPoint tp : route.getList()) {
            buf = this.byteArrHelper.union(buf, tp.getId(), tp.getRouteId(), tp.getLat(), tp.getLon(), {tp.getWidth(), tp.getProp()}, tp.getDriveOverValue(), tp.getDriveLowerValue(), tp.getHighestSpeed(), {tp.getOverSpeedTime()});
        }
        return this.warp(new byte[]{-122, 6}, phoneNum, buf);
    }

    public byte[] delRoute(byte[] phoneNum, byte num, byte[] areaIds) {
        return this.warp(new byte[]{-122, 7}, phoneNum, this.byteArrHelper.union(new byte[]{num}, areaIds));
    }

    public byte[] getDriveHistory(byte[] phoneNum, byte comm, byte[] data) {
        return this.warp(new byte[]{-121, 0}, phoneNum, this.byteArrHelper.union(new byte[]{comm}, data));
    }

    public byte[] sentDriveHistory(byte[] phoneNum, byte comm, byte[] data) {
        return this.warp(new byte[]{-121, 1}, phoneNum, this.byteArrHelper.union(new byte[]{comm}, data));
    }

    public byte[] driverInfoUpload(byte[] phoneNum) {
        return this.warp(new byte[]{-121, 2}, phoneNum);
    }

    public byte[] mediaUploadAnswer(byte[] phoneNum, byte[] mediaId, byte pkgNum, byte[] pkgIds) {
        return this.warp(new byte[]{-120, 0}, phoneNum, this.byteArrHelper.union(mediaId, {pkgNum}, pkgIds));
    }

    public byte[] cameraTakePhotoRightNow(byte[] phoneNum, CameraInfo info) {
        return this.warp(new byte[]{-120, 1}, phoneNum, this.byteArrHelper.union({info.getId()}, info.getComm(), info.getSpaceTime(), {info.getSaveSign(), info.getResolution(), info.getQuality(), info.getLuminance(), info.getContrast(), info.getSaturation(), info.getTone()}));
    }

    public byte[] searchStoredMedia(byte[] phoneNum, SearchStoredMediaData s) {
        return this.warp(new byte[]{-120, 2}, phoneNum, this.byteArrHelper.union({s.getType(), s.getRouteId(), s.getEventCode()}, s.getBeginTime(), s.getEndTime()));
    }

    public byte[] storedMediaDataUpload(byte[] phoneNum, StoredMediaDataUpload s) {
        return this.warp(new byte[]{-120, 3}, phoneNum, this.byteArrHelper.union({s.getType(), s.getRouteId(), s.getEventCode()}, s.getBeginTime(), s.getEndTime(), {s.getDelSign()}));
    }

    public byte[] recordStart(byte[] phoneNum, byte comm, byte[] recordTime, byte saveSign, byte audioSamplingRate) {
        return this.warp(new byte[]{-120, 4}, phoneNum, this.byteArrHelper.union({comm}, recordTime, {saveSign, audioSamplingRate}));
    }

    public byte[] oneStoredMediaSearchAndUpload(byte[] phoneNum, byte[] id, byte delSign) {
        return this.warp(new byte[]{-120, 5}, phoneNum, this.byteArrHelper.union(id, new byte[]{delSign}));
    }

    public byte[] sentData(byte[] phoneNum, byte type, byte[] data) {
        return this.warp(new byte[]{-119, 0}, phoneNum, this.byteArrHelper.union(new byte[]{type}, data));
    }

    public byte[] platRsa(byte[] phoneNum, byte[] p1, byte[] p2) {
        return this.warp(new byte[]{-118, 0}, phoneNum, this.byteArrHelper.union(p1, p2));
    }

    public byte[] queryServerDateTime(byte[] phoneNum) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String timeHex = sdf.format(new Date(System.currentTimeMillis()));
        byte[] timeBytes = this.byteArrHelper.hexStr2bytes(timeHex);
        return this.warp(new byte[]{-128, 4}, phoneNum, timeBytes);
    }

    public ResHelper(ByteArrHelper byteArrHelper, Jt808Helper jt808Helper) {
        this.byteArrHelper = byteArrHelper;
        this.jt808Helper = jt808Helper;
    }
}

