/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.helper;

import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import io.netty.channel.ChannelHandlerContext;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Jt808Helper {
    private static final Logger log = LoggerFactory.getLogger(Jt808Helper.class);
    private ByteArrHelper byteArrHelper;
    private CacheService cacheService;
    private static int PLAT_STREAM_NUM = 1;

    public synchronized int getPlatStreamNum() {
        return PLAT_STREAM_NUM++;
    }

    public synchronized int getPkgPlatStreamNum(int j) {
        int buf = PLAT_STREAM_NUM;
        PLAT_STREAM_NUM += j;
        return buf;
    }

    public int getMsgBodyLength(byte[] bodyProp) {
        int length = 0;
        if (bodyProp.length == 2) {
            int buf = 1023;
            int body = bodyProp[0] << 8 & 0xFF00 ^ bodyProp[1] & 0xFF;
            length = body & buf;
        }
        log.trace("body length is " + length);
        return length;
    }

    public int getStreamNumInMsgBody(byte[] b) {
        return b[0] << 8 & 0xFF00 ^ b[1] & 0xFF;
    }

    public byte[] addVerify(byte[] bytes) {
        byte verify = bytes[0];
        for (int i = 1; i < bytes.length; ++i) {
            verify = (byte)(verify ^ bytes[i]);
        }
        return this.byteArrHelper.union(bytes, new byte[]{verify});
    }

    public byte[] trans(byte[] b) {
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] == 125) {
                b = this.byteArrHelper.union(this.byteArrHelper.subByte(b, 0, i + 1), {1}, this.byteArrHelper.subByte(b, i + 1));
                continue;
            }
            if (b[i] != 126) continue;
            b = this.byteArrHelper.union(this.byteArrHelper.subByte(b, 0, i), {125, 2}, this.byteArrHelper.subByte(b, i + 1));
        }
        b = this.byteArrHelper.union(new byte[]{126}, b);
        b = this.byteArrHelper.union(b, new byte[]{126});
        return b;
    }

    public boolean verify(byte[] bytes) {
        boolean b = false;
        byte verify = bytes[0];
        for (int i = 1; i < bytes.length - 1; ++i) {
            verify = (byte)(verify ^ bytes[i]);
        }
        if (verify == bytes[bytes.length - 1]) {
            b = true;
        }
        log.trace("verify code is " + this.byteArrHelper.toHexString(verify) + " return " + b);
        return b;
    }

    public byte[] retrans(byte[] b) {
        byte[] buf = this.byteArrHelper.subByte(b, 1, b.length - 1);
        for (int i = 0; i < buf.length - 1; ++i) {
            if (buf[i] == 125 && buf[i + 1] == 1) {
                buf = this.byteArrHelper.union(this.byteArrHelper.subByte(buf, 0, i + 1), this.byteArrHelper.subByte(buf, i + 2));
                continue;
            }
            if (buf[i] != 125 || buf[i + 1] != 2) continue;
            buf = this.byteArrHelper.union(this.byteArrHelper.subByte(buf, 0, i), {126}, this.byteArrHelper.subByte(buf, i + 2));
        }
        return buf;
    }

    public boolean hasPackage(byte[] bodyProp) {
        if (bodyProp.length == 2) {
            byte buf = (byte)(bodyProp[0] & 0x20);
            return buf != 0;
        }
        return false;
    }

    public void sentByPkg(byte[] buf, IoSession session) {
        byte[] msgBodyProp = new byte[]{buf[2], buf[3]};
        boolean isVersion2019 = this.isVersion2019(msgBodyProp);
        byte[] body = this.byteArrHelper.subByte(buf, 12);
        int pkgCount = body.length % 1023 == 0 ? body.length / 1023 : body.length / 1023 + 1;
        byte[] msgId = this.byteArrHelper.subByte(buf, 0, 2);
        byte[] phoneNum = isVersion2019 ? this.byteArrHelper.subByte(buf, 5, 15) : this.byteArrHelper.subByte(buf, 4, 10);
        int streamNum = this.getPkgPlatStreamNum(pkgCount);
        String phone = this.byteArrHelper.toHexString(phoneNum);
        Map<Integer, byte[]> sentPackages = this.cacheService.getSentPackages(phone);
        if (sentPackages == null) {
            this.cacheService.setSentPackages(phone, new HashMap<Integer, byte[]>());
            sentPackages = this.cacheService.getSentPackages(phone);
        } else {
            sentPackages.clear();
        }
        for (int i = 1; i <= pkgCount; ++i) {
            byte[] bodyBuf = pkgCount == i ? this.byteArrHelper.subByte(body, (i - 1) * 1023) : this.byteArrHelper.subByte(body, (i - 1) * 1023, i * 1023);
            byte[] data = this.warpPkg(msgId, phoneNum, pkgCount, i, streamNum, bodyBuf);
            sentPackages.put(i, data);
            session.write((Object)data);
            ++streamNum;
        }
    }

    public byte[] warpPkg(byte[] msgId, byte[] phoneNum, int total, int count, int platStreamNum, byte[] msgBody) {
        int bodyLen = msgBody.length;
        if (phoneNum.length == 10) {
            return this.byteArrHelper.union(msgId, {(byte)(bodyLen >>> 8 & 3 | 0x40), (byte)(bodyLen & 0xFF), 1}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)}, {(byte)(total >>> 8 & 0xFF), (byte)(total & 0xFF)}, {(byte)(count >>> 8 & 0xFF), (byte)(count & 0xFF)}, msgBody);
        }
        return this.byteArrHelper.union(msgId, {(byte)(bodyLen >>> 8 & 3), (byte)(bodyLen & 0xFF)}, phoneNum, {(byte)(platStreamNum >>> 8 & 0xFF), (byte)(platStreamNum & 0xFF)}, {(byte)(total >>> 8 & 0xFF), (byte)(total & 0xFF)}, {(byte)(count >>> 8 & 0xFF), (byte)(count & 0xFF)}, msgBody);
    }

    public void sentByPkg(byte[] buf, ChannelHandlerContext session) {
        byte[] msgBodyProp = new byte[]{buf[2], buf[3]};
        boolean isVersion2019 = this.isVersion2019(msgBodyProp);
        byte[] body = this.byteArrHelper.subByte(buf, 12);
        int pkgCount = body.length % 1023 == 0 ? body.length / 1023 : body.length / 1023 + 1;
        byte[] msgId = this.byteArrHelper.subByte(buf, 0, 2);
        byte[] phoneNum = isVersion2019 ? this.byteArrHelper.subByte(buf, 5, 15) : this.byteArrHelper.subByte(buf, 4, 10);
        int streamNum = this.getPkgPlatStreamNum(pkgCount);
        String phone = this.byteArrHelper.toHexString(phoneNum);
        Map<Integer, byte[]> sentPackages = this.cacheService.getSentPackages(phone);
        if (sentPackages == null) {
            this.cacheService.setSentPackages(phone, new HashMap<Integer, byte[]>());
            sentPackages = this.cacheService.getSentPackages(phone);
        } else {
            sentPackages.clear();
        }
        for (int i = 1; i <= pkgCount; ++i) {
            byte[] bodyBuf = pkgCount == i ? this.byteArrHelper.subByte(body, (i - 1) * 1023) : this.byteArrHelper.subByte(body, (i - 1) * 1023, i * 1023);
            byte[] data = this.warpPkg(msgId, phoneNum, pkgCount, i, streamNum, bodyBuf);
            sentPackages.put(i, data);
            session.writeAndFlush((Object)data);
            ++streamNum;
        }
    }

    public byte[] allPkg(String phone, int totalPkgNum) {
        Map<Integer, byte[]> map = this.cacheService.getPackages(phone);
        byte[] buf = this.byteArrHelper.subByte(map.get(1), 0, map.get(1).length - 1);
        for (int i = 2; i <= totalPkgNum; ++i) {
            byte[] pkg = map.get(i);
            buf = this.byteArrHelper.union(buf, this.byteArrHelper.subByte(pkg, phone.length() == 20 ? 21 : 16, map.get(1).length - 1));
        }
        map.clear();
        return buf;
    }

    public boolean pkgAllReceived(String phone, int totalPkgNum) {
        return this.cacheService.containsPackages(phone) && this.cacheService.getPackages(phone).size() == totalPkgNum;
    }

    public String getDataTime(byte[] dateTime) {
        return this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 0, 1)) + "-" + this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 1, 2)) + "-" + this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 2, 3)) + " " + this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 3, 4)) + ":" + this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 4, 5)) + ":" + this.byteArrHelper.getBCDStr(this.byteArrHelper.subByte(dateTime, 5, 6));
    }

    private String getStatusExtAttach(byte[] b) {
        Object attachDesc = "\u6269\u5c55\u8f66\u8f86\u4fe1\u53f7\u72b6\u6001\u4f4d\u9644\u52a0\u4fe1\u606f\uff1a";
        attachDesc = (String)attachDesc + ((b[5] & 1) == 0 ? "" : "\u8fd1\u5149\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 2) == 0 ? "" : "\u8fdc\u5149\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 4) == 0 ? "" : "\u53f3\u8f6c\u5411\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 8) == 0 ? "" : "\u5de6\u8f6c\u5411\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 0x10) == 0 ? "" : "\u5236\u52a8\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 0x20) == 0 ? "" : "\u5012\u6863\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 0x40) == 0 ? "" : "\u96fe\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[5] & 0x80) == 0 ? "" : "\u793a\u5ed3\u706f\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 1) == 0 ? "" : "\u5587\u53ed\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 2) == 0 ? "" : "\u7a7a\u8c03\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 4) == 0 ? "" : "\u7a7a\u6321\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 8) == 0 ? "" : "\u7f13\u901f\u5668\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 0x10) == 0 ? "" : "ABS\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 0x20) == 0 ? "" : "\u52a0\u70ed\u5668\uff0c");
        attachDesc = (String)attachDesc + ((b[4] & 0x40) == 0 ? "" : "\u79bb\u5408\u5668\uff0c");
        attachDesc = (String)attachDesc + "\uff1b";
        return attachDesc;
    }

    private String getDriveTimeAttach(byte[] b) {
        Object attachDesc = "\u8def\u6bb5\u884c\u9a76\u65f6\u95f4\u4e0d\u8db3/\u8fc7\u957f\u62a5\u8b66\u9644\u52a0\u4fe1\u606f\uff1a";
        attachDesc = (String)attachDesc + "\u8def\u6bb5ID\u4e3a" + this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 2, 6)) + "\uff0c\u8def\u6bb5\u884c\u9a76\u65f6\u95f4 " + this.byteArrHelper.twobyte2int(this.byteArrHelper.subByte(b, 6, 8)) + " \u79d2\uff0c\u7ed3\u679c " + (b[8] == 0 ? "\u4e0d\u8db3" : "\u8fc7\u957f") + "\uff1b";
        return attachDesc;
    }

    private String getInAndOutAttach(byte[] b) {
        StringBuilder attachDesc = new StringBuilder();
        attachDesc.append("\u8fdb\u51fa\u533a\u57df/\u8def\u7ebf\u62a5\u8b66\u9644\u52a0\u4fe1\u606f\uff1a");
        switch (b[7]) {
            case 0: {
                attachDesc.append("\u8fdb");
                break;
            }
            case 1: {
                attachDesc.append("\u51fa");
                break;
            }
        }
        switch (b[2]) {
            case 1: {
                attachDesc.append("\u5706\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a");
                break;
            }
            case 2: {
                attachDesc.append("\u77e9\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a");
                break;
            }
            case 3: {
                attachDesc.append("\u591a\u8fb9\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a");
                break;
            }
            case 4: {
                attachDesc.append("\u8def\u7ebf\uff0c\u7f16\u53f7\u4e3a");
                break;
            }
        }
        attachDesc.append(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 3, 7)));
        attachDesc.append("\uff1b");
        return attachDesc.toString();
    }

    private String getOverSpeedAttach(byte[] b) {
        StringBuilder attachDesc = new StringBuilder();
        attachDesc.append("\u8d85\u901f\u62a5\u8b66\u9644\u52a0\u4fe1\u606f\uff1a");
        switch (b[2]) {
            case 0: {
                attachDesc.append("\u65e0\u7279\u5b9a\u4f4d\u7f6e\uff0c\u7f16\u53f7\u4e3a0");
                break;
            }
            case 1: {
                attachDesc.append("\u5706\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a").append(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 3, 7)));
                break;
            }
            case 2: {
                attachDesc.append("\u77e9\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a").append(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 3, 7)));
                break;
            }
            case 3: {
                attachDesc.append("\u591a\u8fb9\u5f62\u533a\u57df\uff0c\u7f16\u53f7\u4e3a").append(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 3, 7)));
                break;
            }
            case 4: {
                attachDesc.append("\u8def\u6bb5\uff0c\u7f16\u53f7\u4e3a").append(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(b, 3, 7)));
                break;
            }
        }
        attachDesc.append("\uff1b");
        return attachDesc.toString();
    }

    private String getStatusDesc(byte[] status) {
        Object remarkSb = "";
        remarkSb = (String)remarkSb + ((status[3] & 1) == 0 ? "ACC\u5173\uff1b" : "ACC\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[3] & 2) == 0 ? "\u672a\u5b9a\u4f4d\uff1b" : "\u5b9a\u4f4d\uff1b");
        remarkSb = (String)remarkSb + ((status[3] & 4) == 0 ? "\u5317\u7eac\uff1b" : "\u5357\u7eac\uff1b");
        remarkSb = (String)remarkSb + ((status[3] & 8) == 0 ? "\u4e1c\u7ecf\uff1b" : "\u897f\u7ecf\uff1b");
        remarkSb = (String)remarkSb + ((status[3] & 0x10) == 0 ? "\u8fd0\u8425\uff1b" : "\u505c\u8fd0\uff1b");
        remarkSb = (String)remarkSb + ((status[3] & 0x20) == 0 ? "\u7ecf\u7eac\u5ea6\u672a\u7ecf\u4fdd\u5bc6\u63d2\u4ef6\u52a0\u5bc6\uff1b" : "\u7ecf\u7eac\u5ea6\u5df2\u7ecf\u4fdd\u5bc6\u63d2\u4ef6\u52a0\u5bc6\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 3) == 0 ? "\u7a7a\u8f66\uff1b" : "");
        remarkSb = (String)remarkSb + ((status[2] & 3) == 3 ? "\u6ee1\u8f7d\uff1b" : "");
        remarkSb = (String)remarkSb + ((status[2] & 3) == 1 ? "\u534a\u8f7d\uff1b" : "");
        remarkSb = (String)remarkSb + ((status[2] & 4) == 0 ? "\u8f66\u8f86\u6cb9\u8def\u6b63\u5e38\uff1b" : "\u8f66\u8f86\u6cb9\u8def\u65ad\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 8) == 0 ? "\u8f66\u8f86\u7535\u8def\u6b63\u5e38\uff1b" : "\u8f66\u8f86\u7535\u8def\u65ad\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 0x10) == 0 ? "\u8f66\u95e8\u89e3\u9501\uff1b" : "\u8f66\u95e8\u52a0\u9501\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 0x20) == 0 ? "\u95e81\uff08\u524d\u95e8\uff09\u5173\uff1b" : "\u95e81\uff08\u524d\u95e8\uff09\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 0x40) == 0 ? "\u95e82\uff08\u4e2d\u95e8\uff09\u5173\uff1b" : "\u95e82\uff08\u4e2d\u95e8\uff09\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[2] & 0x80) == 0 ? "\u95e83\uff08\u540e\u95e8\uff09\u5173\uff1b" : "\u95e83\uff08\u540e\u95e8\uff09\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 1) == 0 ? "\u95e84\uff08\u9a7e\u9a76\u5e2d\u95e8\uff09\u5173\uff1b" : "\u95e84\uff08\u9a7e\u9a76\u5e2d\u95e8\uff09\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 2) == 0 ? "\u95e85\uff08\u81ea\u5b9a\u4e49\u95e8\uff09\u5173\uff1b" : "\u95e85\uff08\u81ea\u5b9a\u4e49\u95e8\uff09\u5f00\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 4) == 0 ? "\u672a\u4f7f\u7528 GPS \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b" : "\u4f7f\u7528 GPS \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 8) == 0 ? "\u672a\u4f7f\u7528\u5317\u6597\u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b" : "\u4f7f\u7528\u5317\u6597\u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 0x10) == 0 ? "\u672a\u4f7f\u7528 GLONASS \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b" : "\u4f7f\u7528 GLONASS \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b");
        remarkSb = (String)remarkSb + ((status[1] & 0x20) == 0 ? "\u672a\u4f7f\u7528 Galileo \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b" : "\u4f7f\u7528 Galileo \u536b\u661f\u8fdb\u884c\u5b9a\u4f4d\uff1b");
        return remarkSb;
    }

    public String getMediaEventDesc(byte b) {
        return switch (b) {
            case 0 -> "\u5e73\u53f0\u4e0b\u53d1\u6307\u4ee4";
            case 1 -> "\u5b9a\u65f6\u52a8\u4f5c";
            case 2 -> "\u62a2\u52ab\u62a5\u8b66\u89e6\u53d1";
            case 3 -> "\u78b0\u649e\u4fa7\u7ffb\u62a5\u8b66\u89e6\u53d1";
            case 4 -> "\u95e8\u5f00\u62cd\u7167";
            case 5 -> "\u95e8\u5173\u62cd\u7167";
            case 6 -> "\u8f66\u95e8\u7531\u5f00\u53d8\u5173\uff0c\u65f6\u901f\u4ece\u5c0f\u4e8e 20 \u516c\u91cc\u5230\u8d85\u8fc7 20 \u516c\u91cc";
            case 7 -> "\u5b9a\u8ddd\u62cd\u7167";
            default -> "\u4fdd\u7559";
        };
    }

    public String toGBKString(byte[] data) throws UnsupportedEncodingException {
        return new String(data, "GBK").trim();
    }

    public String toAsciiString(byte[] data) {
        return new String(data, StandardCharsets.US_ASCII).trim();
    }

    public boolean isVersion2019(byte[] msgBodyProp) {
        return (msgBodyProp[0] & 0x40) == 64;
    }

    public boolean checkLocationData(byte[] locationData) {
        byte[] latitude = this.byteArrHelper.subByte(locationData, 8, 12);
        byte[] longitude = this.byteArrHelper.subByte(locationData, 12, 16);
        byte[] height = this.byteArrHelper.subByte(locationData, 16, 18);
        byte[] speed = this.byteArrHelper.subByte(locationData, 18, 20);
        byte[] direction = this.byteArrHelper.subByte(locationData, 20, 22);
        byte[] datetime = this.byteArrHelper.subByte(locationData, 22, 28);
        double longitudeDouble = (double)this.byteArrHelper.fourbyte2int(longitude) / 1000000.0;
        if (longitudeDouble > 180.0 || longitudeDouble < -180.0) {
            return false;
        }
        double latitudeDouble = (double)this.byteArrHelper.fourbyte2int(latitude) / 1000000.0;
        if (latitudeDouble > 90.0 || latitudeDouble < -90.0) {
            return false;
        }
        int heightInt = this.byteArrHelper.twobyte2int(height);
        if (heightInt > 10000 || heightInt < 0) {
            return false;
        }
        double speedDouble = (double)this.byteArrHelper.twobyte2int(speed) / 10.0;
        if (speedDouble < 0.0 || speedDouble > 600.0) {
            return false;
        }
        int directionInt = this.byteArrHelper.twobyte2int(direction);
        if (directionInt < 0 || directionInt > 359) {
            return false;
        }
        String month = this.byteArrHelper.getBCDStr(new byte[]{datetime[1]});
        int monthInt = Integer.parseInt(month);
        if (monthInt < 1 || monthInt > 12) {
            return false;
        }
        String day = this.byteArrHelper.getBCDStr(new byte[]{datetime[2]});
        int dayInt = Integer.parseInt(day);
        if (dayInt < 1 || dayInt > 31) {
            return false;
        }
        String hour = this.byteArrHelper.getBCDStr(new byte[]{datetime[3]});
        int hourInt = Integer.parseInt(hour);
        if (hourInt < 1 || hourInt > 24) {
            return false;
        }
        String minute = this.byteArrHelper.getBCDStr(new byte[]{datetime[4]});
        int minuteInt = Integer.parseInt(minute);
        if (minuteInt < 1 || minuteInt > 60) {
            return false;
        }
        String second = this.byteArrHelper.getBCDStr(new byte[]{datetime[5]});
        int secondInt = Integer.parseInt(second);
        return secondInt >= 1 && secondInt <= 60;
    }

    public boolean checkRsa(byte[] msgBodyProp) {
        return (msgBodyProp[0] & 4) == 4;
    }

    public Jt808Helper(ByteArrHelper byteArrHelper, CacheService cacheService) {
        this.byteArrHelper = byteArrHelper;
        this.cacheService = cacheService;
    }
}

