/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GzipHelper {
    private static final Logger log = LoggerFactory.getLogger(GzipHelper.class);

    public byte[] gzip(byte[] data) {
        try {
            int count;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            byte[] buf = new byte[1024];
            while ((count = bais.read(buf)) != -1) {
                gos.write(buf, 0, count);
            }
            gos.finish();
            gos.flush();
            gos.close();
            baos.flush();
            baos.close();
            bais.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public byte[] ungzip(byte[] data) {
        try {
            int count;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPInputStream gis = new GZIPInputStream(bais);
            byte[] buf = new byte[1024];
            while ((count = gis.read(buf)) != -1) {
                baos.write(buf, 0, count);
            }
            gis.close();
            baos.flush();
            baos.close();
            bais.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }
}

