/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.helper;

import com.zhoyq.server.jt808.starter.entity.AlarmInfo;
import com.zhoyq.server.jt808.starter.entity.CanDataInfo;
import com.zhoyq.server.jt808.starter.entity.CanDataItem;
import com.zhoyq.server.jt808.starter.entity.DataTransportInfo;
import com.zhoyq.server.jt808.starter.entity.DriverAlarmInfo;
import com.zhoyq.server.jt808.starter.entity.DriverInfo;
import com.zhoyq.server.jt808.starter.entity.LocationAttachInfo;
import com.zhoyq.server.jt808.starter.entity.LocationInfo;
import com.zhoyq.server.jt808.starter.entity.MediaInfo;
import com.zhoyq.server.jt808.starter.entity.StatusInfo;
import com.zhoyq.server.jt808.starter.entity.TerminalProperty;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.CanDataItemProcessor;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import com.zhoyq.server.jt808.starter.helper.LocationAttacheProcessor;
import com.zhoyq.server.jt808.starter.helper.TerminalParameterProcessor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Analyzer {
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);
    private ByteArrHelper byteArrHelper;
    private Jt808Helper jt808Helper;

    public void analyzeParameter(TerminalParameterProcessor processor, byte[] data) {
        byte length;
        if (data == null) {
            return;
        }
        for (int pos = 0; pos < data.length; pos += length + 5) {
            length = data[pos + 4];
            byte[] id = this.byteArrHelper.subByte(data, pos, pos + 4);
            byte[] dataBuf = this.byteArrHelper.subByte(data, pos + 5, pos + length + 5);
            processor.process(this.byteArrHelper.toHexString(id), dataBuf);
        }
    }

    public TerminalProperty analyzeTerminalProperty(byte[] data) {
        TerminalProperty terminalProperty = TerminalProperty.builder().build();
        byte[] terminalType = this.byteArrHelper.subByte(data, 0, 2);
        terminalProperty.setSupportBus((terminalType[1] & 1) == 1);
        terminalProperty.setSupportDangerVehicle((terminalType[1] & 2) == 2);
        terminalProperty.setSupportFreightVehicle((terminalType[1] & 4) == 4);
        terminalProperty.setSupportTaxi((terminalType[1] & 8) == 8);
        terminalProperty.setSupportRecording((terminalType[1] & 0x40) == 64);
        terminalProperty.setSupportExtension((terminalType[1] & 0xFFFFFF80) == -128);
        byte[] manufacturer = this.byteArrHelper.subByte(data, 2, 7);
        terminalProperty.setManufacturer(this.byteArrHelper.toHexString(manufacturer));
        byte[] terminalModel = this.byteArrHelper.subByte(data, 7, 27);
        terminalProperty.setTerminalModel(this.byteArrHelper.toHexString(terminalModel));
        byte[] terminalId = this.byteArrHelper.subByte(data, 27, 34);
        try {
            terminalProperty.setTerminalId(this.jt808Helper.toGBKString(terminalId));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
        }
        byte[] terminalIccid = this.byteArrHelper.subByte(data, 34, 44);
        terminalProperty.setIccid(this.byteArrHelper.getBCDStrByArr(terminalIccid));
        byte terminalHardwareVersionLength = data[44];
        byte[] terminalHardwareVersion = this.byteArrHelper.subByte(data, 45, 45 + terminalHardwareVersionLength);
        try {
            terminalProperty.setTerminalHardVersion(this.jt808Helper.toGBKString(terminalHardwareVersion));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
        }
        byte terminalSoftwareVersionLength = data[45 + terminalHardwareVersionLength];
        byte[] terminalSoftwareVersion = this.byteArrHelper.subByte(data, 46 + terminalHardwareVersionLength, 46 + terminalHardwareVersionLength + terminalSoftwareVersionLength);
        try {
            terminalProperty.setTerminalSoftVersion(this.jt808Helper.toGBKString(terminalSoftwareVersion));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
        }
        byte gnssModuleProp = data[46 + terminalHardwareVersionLength + terminalSoftwareVersionLength];
        terminalProperty.setSupportGps((gnssModuleProp & 1) == 1);
        terminalProperty.setSupportBeidou((gnssModuleProp & 2) == 2);
        terminalProperty.setSupportGlonass((gnssModuleProp & 4) == 4);
        terminalProperty.setSupportGalileo((gnssModuleProp & 8) == 8);
        byte connectModuleProp = data[47 + terminalHardwareVersionLength + terminalSoftwareVersionLength];
        terminalProperty.setSupportGprs((connectModuleProp & 1) == 1);
        terminalProperty.setSupportCdma((connectModuleProp & 2) == 2);
        terminalProperty.setSupportTdscdma((connectModuleProp & 4) == 4);
        terminalProperty.setSupportWcdma((connectModuleProp & 8) == 8);
        terminalProperty.setSupportCdma2000((connectModuleProp & 0x10) == 16);
        terminalProperty.setSupportTdlte((connectModuleProp & 0x20) == 32);
        terminalProperty.setSupportOther((connectModuleProp & 0xFFFFFF80) == -128);
        return terminalProperty;
    }

    public AlarmInfo analyzeAlarm(byte[] alarms) {
        AlarmInfo alarmInfo = AlarmInfo.builder().build();
        alarmInfo.setEmergencyAlarm((alarms[3] & 1) == 1);
        alarmInfo.setOverSpeedAlarm((alarms[3] & 2) == 2);
        alarmInfo.setFatigueDrivingAlarm((alarms[3] & 4) == 4);
        alarmInfo.setDangerWarning((alarms[3] & 8) == 8);
        alarmInfo.setGnssModuleFault((alarms[3] & 0x10) == 16);
        alarmInfo.setGnssConnectFault((alarms[3] & 0x20) == 32);
        alarmInfo.setGnssShortCircuit((alarms[3] & 0x40) == 64);
        alarmInfo.setPowerUnderpressure((alarms[3] & 0xFFFFFF80) == -128);
        alarmInfo.setPowerFault((alarms[2] & 1) == 1);
        alarmInfo.setLcdFault((alarms[2] & 2) == 2);
        alarmInfo.setTtsFault((alarms[2] & 4) == 4);
        alarmInfo.setCameraFault((alarms[2] & 8) == 8);
        alarmInfo.setIcModuleFault((alarms[2] & 0x10) == 16);
        alarmInfo.setOverSpeedWarn((alarms[2] & 0x20) == 32);
        alarmInfo.setFatigueDrivingWarn((alarms[2] & 0x40) == 64);
        alarmInfo.setDriverAgainstRules((alarms[2] & 0xFFFFFF80) == -128);
        alarmInfo.setTirePressureWarning((alarms[1] & 1) == 1);
        alarmInfo.setRightTurnBlindArea((alarms[1] & 2) == 2);
        alarmInfo.setCumulativeDrivingTimeout((alarms[1] & 4) == 4);
        alarmInfo.setStopTimeout((alarms[1] & 8) == 8);
        alarmInfo.setInArea((alarms[1] & 0x10) == 16);
        alarmInfo.setOutLine((alarms[1] & 0x20) == 32);
        alarmInfo.setDrivingTimeIncorrect((alarms[1] & 0x40) == 64);
        alarmInfo.setRouteDeviation((alarms[1] & 0xFFFFFF80) == -128);
        alarmInfo.setVssFault((alarms[0] & 1) == 1);
        alarmInfo.setOilFault((alarms[0] & 2) == 2);
        alarmInfo.setStolenVehicle((alarms[0] & 4) == 4);
        alarmInfo.setIllegalIgnition((alarms[0] & 8) == 8);
        alarmInfo.setIllegalDisplacement((alarms[0] & 0x10) == 16);
        alarmInfo.setCollisionWarn((alarms[0] & 0x20) == 32);
        alarmInfo.setRollOverWarn((alarms[0] & 0x40) == 64);
        alarmInfo.setIllegalOpeningTheDoor((alarms[0] & 0xFFFFFF80) == -128);
        return alarmInfo;
    }

    public StatusInfo analyzeStatus(byte[] status) {
        StatusInfo statusInfo = StatusInfo.builder().build();
        statusInfo.setAcc((status[3] & 1) == 1);
        statusInfo.setPositioning((status[3] & 2) == 2);
        statusInfo.setSouth((status[3] & 4) == 4);
        statusInfo.setWest((status[3] & 8) == 8);
        statusInfo.setSuspended((status[3] & 0x10) == 16);
        statusInfo.setEncryption((status[3] & 0x20) == 32);
        statusInfo.setBrakeSystemWarning((status[3] & 0x40) == 64);
        statusInfo.setLaneDepartureWarning((status[3] & 0xFFFFFF80) == -128);
        statusInfo.setCargo(status[2] & 3);
        statusInfo.setOilBreak((status[2] & 4) == 4);
        statusInfo.setCircuitBreak((status[2] & 8) == 8);
        statusInfo.setLocking((status[2] & 0x10) == 16);
        statusInfo.setOpening1((status[2] & 0x20) == 32);
        statusInfo.setOpening2((status[2] & 0x40) == 64);
        statusInfo.setOpening3((status[2] & 0xFFFFFF80) == -128);
        statusInfo.setOpening4((status[1] & 1) == 1);
        statusInfo.setOpening5((status[1] & 2) == 2);
        statusInfo.setGps((status[1] & 4) == 4);
        statusInfo.setBeidou((status[1] & 8) == 8);
        statusInfo.setGlonass((status[1] & 0x10) == 16);
        statusInfo.setGalileo((status[1] & 0x20) == 32);
        statusInfo.setVehicleStatus((status[1] & 0x40) == 64);
        return statusInfo;
    }

    public void analyzeAttache(LocationAttacheProcessor processor, byte[] attache) {
        byte length;
        if (attache == null) {
            return;
        }
        for (int pos = 0; pos < attache.length; pos += length + 2) {
            length = attache[pos + 1];
            byte id = attache[pos];
            byte[] dataBuf = this.byteArrHelper.subByte(attache, pos + 2, pos + length + 2);
            processor.process(id, dataBuf);
        }
    }

    public LocationInfo analyzeLocation(byte[] msgBody) {
        byte[] alarms = this.byteArrHelper.subByte(msgBody, 0, 4);
        byte[] status = this.byteArrHelper.subByte(msgBody, 4, 8);
        byte[] latitude = this.byteArrHelper.subByte(msgBody, 8, 12);
        byte[] longitude = this.byteArrHelper.subByte(msgBody, 12, 16);
        byte[] height = this.byteArrHelper.subByte(msgBody, 16, 18);
        byte[] speed = this.byteArrHelper.subByte(msgBody, 18, 20);
        byte[] direction = this.byteArrHelper.subByte(msgBody, 20, 22);
        byte[] datetime = this.byteArrHelper.subByte(msgBody, 22, 28);
        byte[] attache = this.byteArrHelper.subByte(msgBody, 28);
        AlarmInfo alarmInfo = this.analyzeAlarm(alarms);
        StatusInfo statusInfo = this.analyzeStatus(status);
        double longitudeDouble = (double)this.byteArrHelper.fourbyte2int(longitude) / 1000000.0;
        double latitudeDouble = (double)this.byteArrHelper.fourbyte2int(latitude) / 1000000.0;
        int heightInt = this.byteArrHelper.twobyte2int(height);
        double speedDouble = (double)this.byteArrHelper.twobyte2int(speed) / 10.0;
        int directionInt = this.byteArrHelper.twobyte2int(direction);
        String datetimeString = this.jt808Helper.getDataTime(datetime);
        ArrayList<LocationAttachInfo> attachInfoList = new ArrayList<LocationAttachInfo>();
        this.analyzeAttache((id, data) -> {
            LocationAttachInfo attachInfo = LocationAttachInfo.builder().build();
            attachInfo.setId(id);
            attachInfo.setData(data);
            attachInfoList.add(attachInfo);
        }, attache);
        LocationInfo locationInfo = LocationInfo.builder().build();
        locationInfo.setAlarmInfo(alarmInfo);
        locationInfo.setStatusInfo(statusInfo);
        locationInfo.setLongitude(longitudeDouble);
        locationInfo.setLatitude(latitudeDouble);
        locationInfo.setHeight(heightInt);
        locationInfo.setSpeed(speedDouble);
        locationInfo.setDirection(directionInt);
        locationInfo.setDatetime(datetimeString);
        locationInfo.setAttachInfo(attachInfoList);
        return locationInfo;
    }

    public DriverInfo analyzeDriver(byte[] phoneNum, byte[] data) {
        int ver = 0;
        if (phoneNum.length == 10) {
            ver = 2019;
        } else if (data[0] == 1 || data[0] == 2) {
            if (data[7] == 0) {
                int len2011 = 0;
                int len2013 = 0;
                try {
                    len2011 = 62 + data[0] + data[data[0] + 61];
                }
                catch (IndexOutOfBoundsException e) {
                    log.warn(e.getMessage());
                }
                try {
                    len2013 = 34 + data[8] + data[data[8] + 29];
                }
                catch (IndexOutOfBoundsException e) {
                    log.warn(e.getMessage());
                }
                if (data.length == len2011) {
                    ver = 2011;
                }
                if (data.length == len2013) {
                    ver = 2013;
                }
            } else {
                ver = data[7] == 1 || data[7] == 2 || data[7] == 3 || data[7] == 4 ? (data.length == 8 ? 2013 : 2011) : 2011;
            }
        } else {
            ver = 2011;
        }
        if (ver == 2011) {
            return this.analyzeDriver2011(data);
        }
        if (ver == 2013) {
            return this.analyzeDriver2013(data);
        }
        if (ver == 2019) {
            return this.analyzeDriver2019(data);
        }
        return null;
    }

    private DriverInfo analyzeDriver2011(byte[] data) {
        byte nameLength = data[0];
        byte[] name = this.byteArrHelper.subByte(data, 1, nameLength + 1);
        byte[] idCard = this.byteArrHelper.subByte(data, nameLength + 1, nameLength + 21);
        byte[] certificate = this.byteArrHelper.subByte(data, nameLength + 21, nameLength + 61);
        byte[] certificatePublishAgentName = this.byteArrHelper.subByte(data, nameLength + 62);
        DriverInfo driverInfo = DriverInfo.builder().build();
        try {
            driverInfo.setDriverName(this.jt808Helper.toGBKString(name));
            driverInfo.setIdCardNumber(this.jt808Helper.toGBKString(idCard));
            driverInfo.setCertificateNumber(this.jt808Helper.toGBKString(certificate));
            driverInfo.setCertificatePublishAgentName(this.jt808Helper.toGBKString(certificatePublishAgentName));
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
        }
        driverInfo.setSuccess(true);
        return driverInfo;
    }

    private DriverInfo analyzeDriver2013(byte[] data) {
        DriverInfo driverInfo = DriverInfo.builder().build();
        driverInfo.setDriverAlarmInfo(DriverAlarmInfo.builder().build());
        if (data[0] == 1) {
            driverInfo.getDriverAlarmInfo().setPullOutCard(false);
        } else if (data[0] == 2) {
            driverInfo.getDriverAlarmInfo().setPullOutCard(true);
        } else {
            return null;
        }
        String gTime = this.jt808Helper.getDataTime(this.byteArrHelper.subByte(data, 1, 7));
        driverInfo.setDatetime(gTime);
        switch (data[7]) {
            case 0: {
                try {
                    byte nameLength = data[8];
                    String driverName = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, 9, nameLength + 9));
                    String certificate = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, nameLength + 9, nameLength + 29));
                    byte certificatePublishAgentNameLength = data[nameLength + 29];
                    String certificatePublishAgentName = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, nameLength + 30, nameLength + 30 + certificatePublishAgentNameLength));
                    String expiryTime = this.byteArrHelper.getBCDStrByArr(this.byteArrHelper.subByte(data, nameLength + 30 + certificatePublishAgentNameLength));
                    driverInfo.setDriverName(driverName);
                    driverInfo.setCertificateNumber(certificate);
                    driverInfo.setCertificatePublishAgentName(certificatePublishAgentName);
                    driverInfo.setCertificateLimitDate(expiryTime);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    log.warn(e.getMessage());
                    return null;
                }
            }
            case 1: {
                driverInfo.getDriverAlarmInfo().setUnAuthentication(true);
                break;
            }
            case 2: {
                driverInfo.getDriverAlarmInfo().setLocked(true);
                break;
            }
            case 3: {
                driverInfo.getDriverAlarmInfo().setPullOut(true);
                break;
            }
            case 4: {
                driverInfo.getDriverAlarmInfo().setCheckFailed(true);
                break;
            }
            default: {
                return null;
            }
        }
        driverInfo.setSuccess(true);
        return driverInfo;
    }

    private DriverInfo analyzeDriver2019(byte[] data) {
        DriverInfo driverInfo = DriverInfo.builder().build();
        driverInfo.setDriverAlarmInfo(DriverAlarmInfo.builder().build());
        if (data[0] == 1) {
            driverInfo.getDriverAlarmInfo().setPullOutCard(false);
        } else if (data[0] == 2) {
            driverInfo.getDriverAlarmInfo().setPullOutCard(true);
        } else {
            return null;
        }
        String gTime = this.jt808Helper.getDataTime(this.byteArrHelper.subByte(data, 1, 7));
        driverInfo.setDatetime(gTime);
        switch (data[7]) {
            case 0: {
                try {
                    byte nameLength = data[8];
                    String driverName = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, 9, nameLength + 9));
                    String certificate = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, nameLength + 9, nameLength + 29));
                    byte certificatePublishAgentNameLength = data[nameLength + 29];
                    String certificatePublishAgentName = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, nameLength + 30, nameLength + 30 + certificatePublishAgentNameLength));
                    String expiryTime = this.byteArrHelper.getBCDStrByArr(this.byteArrHelper.subByte(data, nameLength + certificatePublishAgentNameLength + 30, nameLength + certificatePublishAgentNameLength + 34));
                    String idCardNum = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(data, nameLength + certificatePublishAgentNameLength + 34, nameLength + certificatePublishAgentNameLength + 54));
                    driverInfo.setDriverName(driverName);
                    driverInfo.setCertificateNumber(certificate);
                    driverInfo.setCertificatePublishAgentName(certificatePublishAgentName);
                    driverInfo.setCertificateLimitDate(expiryTime);
                    driverInfo.setIdCardNumber(idCardNum);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    log.warn(e.getMessage());
                    return null;
                }
            }
            case 1: {
                driverInfo.getDriverAlarmInfo().setUnAuthentication(true);
                break;
            }
            case 2: {
                driverInfo.getDriverAlarmInfo().setLocked(true);
                break;
            }
            case 3: {
                driverInfo.getDriverAlarmInfo().setPullOut(true);
                break;
            }
            case 4: {
                driverInfo.getDriverAlarmInfo().setCheckFailed(true);
                break;
            }
            default: {
                return null;
            }
        }
        driverInfo.setSuccess(true);
        return driverInfo;
    }

    public CanDataInfo analyzeCan(byte[] data) {
        CanDataInfo canDataInfo = CanDataInfo.builder().build();
        canDataInfo.setTimestamp(System.currentTimeMillis());
        String time = this.byteArrHelper.getBCDStr(new byte[]{data[2]}) + "-" + this.byteArrHelper.getBCDStr(new byte[]{data[3]}) + "-" + this.byteArrHelper.getBCDStr(new byte[]{data[4]}) + "-" + this.byteArrHelper.getBCDStr(new byte[]{data[5]}) + this.byteArrHelper.getBCDStr(new byte[]{data[6]});
        canDataInfo.setReceiveTime(time);
        canDataInfo.setData(this.byteArrHelper.subByte(data, 7));
        return canDataInfo;
    }

    public void analyzeCanItem(CanDataItemProcessor processor, byte[] data) {
        int len = 12;
        for (int pos = 0; pos < data.length; pos += len) {
            byte[] head = this.byteArrHelper.subByte(data, pos, pos + 4);
            byte[] tail = this.byteArrHelper.subByte(data, pos + 4, pos + len);
            CanDataItem item = CanDataItem.builder().build();
            int headInt = this.byteArrHelper.fourbyte2int(head);
            item.setCanTunnel(headInt & 0xFFFFFFFF);
            item.setFrameType(headInt & 1);
            item.setDataCollectModel(headInt & 1);
            item.setCanID(headInt & 0x1FFFFFFF);
            item.setData(tail);
            processor.process(item);
        }
    }

    public MediaInfo analyzeMediaInfo(byte[] data) {
        MediaInfo mediaInfo = MediaInfo.builder().build();
        mediaInfo.setMediaId(this.byteArrHelper.fourbyte2int(this.byteArrHelper.subByte(data, 0, 4)));
        mediaInfo.setMediaType(data[4]);
        mediaInfo.setMediaFormat(data[5]);
        mediaInfo.setEventNumber(data[6]);
        mediaInfo.setTunnelId(data[7]);
        return mediaInfo;
    }

    public DataTransportInfo analyzeDataTransport(byte[] data) {
        DataTransportInfo dataTransportInfo = DataTransportInfo.builder().build();
        dataTransportInfo.setType(data[0]);
        dataTransportInfo.setData(this.byteArrHelper.subByte(data, 1));
        return dataTransportInfo;
    }

    public Analyzer(ByteArrHelper byteArrHelper, Jt808Helper jt808Helper) {
        this.byteArrHelper = byteArrHelper;
        this.jt808Helper = jt808Helper;
    }
}

