/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.core;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.pack.NoSupportHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PackHandlerManagement
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PackHandlerManagement.class);
    private static Map<Integer, PackHandler> packHandlerMap;
    private NoSupportHandler noSupportHandler;
    private ByteArrHelper byteArrHelper;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (packHandlerMap == null) {
            packHandlerMap = new ConcurrentHashMap<Integer, PackHandler>();
            Map handlers = applicationContext.getBeansWithAnnotation(Jt808Pack.class);
            for (Map.Entry entry : handlers.entrySet()) {
                Jt808Pack packConfig;
                Object handler = entry.getValue();
                if (!(handler instanceof PackHandler) || (packConfig = handler.getClass().getAnnotation(Jt808Pack.class)) == null || packHandlerMap.containsKey(packConfig.msgId())) continue;
                log.trace("add pack handler {} for {}", (Object)handler.getClass().getName(), (Object)this.byteArrHelper.toHexString(this.byteArrHelper.int2twobytes(packConfig.msgId())));
                packHandlerMap.put(packConfig.msgId(), (PackHandler)handler);
            }
        }
    }

    public PackHandler getPackHandler(int msgId) {
        return packHandlerMap == null ? this.noSupportHandler : packHandlerMap.get(msgId);
    }

    public PackHandlerManagement(NoSupportHandler noSupportHandler, ByteArrHelper byteArrHelper) {
        this.noSupportHandler = noSupportHandler;
        this.byteArrHelper = byteArrHelper;
    }
}

