/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.config;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import com.zhoyq.server.jt808.starter.service.DataService;
import com.zhoyq.server.jt808.starter.service.impl.HashMapCacheService;
import com.zhoyq.server.jt808.starter.service.impl.SimpleDataServiceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SimpleBeanConfig {
    private static final Logger log = LoggerFactory.getLogger(SimpleBeanConfig.class);
    private ByteArrHelper byteArrHelper;
    private Jt808Config jt808Config;

    @Bean
    @ConditionalOnMissingBean(value={DataService.class})
    public DataService dataService() {
        log.info("use default data service Bean.");
        return new SimpleDataServiceAdapter(this.byteArrHelper);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheService.class})
    public CacheService sessionService() {
        log.info("use default session service Bean.");
        return new HashMapCacheService();
    }

    public SimpleBeanConfig(ByteArrHelper byteArrHelper, Jt808Config jt808Config) {
        this.byteArrHelper = byteArrHelper;
        this.jt808Config = jt808Config;
    }
}

