/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.config;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.core.Jt808Server;
import com.zhoyq.server.jt808.starter.dto.SimAuthDto;
import com.zhoyq.server.jt808.starter.helper.CustomThreadFactory;
import com.zhoyq.server.jt808.starter.service.CacheService;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.zhoyq.server.jt808.starter"})
public class Jt808Starter
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(Jt808Starter.class);
    private Jt808Config jt808Config;
    private DataService dataService;
    private CacheService cacheService;

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        return new ThreadPoolExecutor((int)this.jt808Config.getThreadCorePoolSize(), (int)this.jt808Config.getThreadMaximumPoolSize(), (long)this.jt808Config.getThreadKeepAliveTime().intValue(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory("jt808-mina-thread-pool-db"));
    }

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        if (!this.jt808Config.getEnabled().booleanValue()) {
            log.info("jt808 server is disabled !");
            return;
        }
        List<SimAuthDto> list = this.dataService.simAuth();
        if (list != null) {
            for (SimAuthDto sa : list) {
                this.cacheService.setAuth(sa.getSim(), sa.getAuth());
            }
        }
        String serverKey = "jt808_" + this.jt808Config.getUse() + "_" + this.jt808Config.getProtocol();
        if (!applicationStartedEvent.getApplicationContext().containsBean(serverKey)) {
            log.error("no jt808 server instance for key {} has been found !", (Object)serverKey);
            return;
        }
        Jt808Server server = (Jt808Server)applicationStartedEvent.getApplicationContext().getBean(serverKey);
        if (server.start()) {
            log.info("jt808 server started on port {}", (Object)this.jt808Config.getPort());
        } else {
            log.error("jt808 server start failed!");
        }
    }

    public Jt808Starter(Jt808Config jt808Config, DataService dataService, CacheService cacheService) {
        this.jt808Config = jt808Config;
        this.dataService = dataService;
        this.cacheService = cacheService;
    }
}

