// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceStorm;

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 *
 * @see TopicManager
 *
 **/
public interface _TopicOperationsNC
{
    /**
     * Get the name of this topic.
     *
     * @return The name of the topic.
     *
     * @see TopicManager#create
     *
     **/
    String getName();

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link #getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @return A proxy to publish data on this topic.
     *
     **/
    Ice.ObjectPrx getPublisher();

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link #getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @return A proxy to publish data on this topic.
     *
     **/
    Ice.ObjectPrx getNonReplicatedPublisher();

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @return The per-subscriber publisher object.
     *
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     *
     * @throws NullSubscriber Raised if the subscriber object is null.
     *
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     *
     * @see #unsubscribe
     *
     **/
    Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @see #subscribeAndGetPublisher
     *
     **/
    void unsubscribe(Ice.ObjectPrx subscriber);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     *
     **/
    void link(TopicPrx linkTo, int cost)
        throws LinkExists;

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     *
     **/
    void unlink(TopicPrx linkTo)
        throws NoSuchLink;

    /**
     * Retrieve information on the current links.
     *
     * @return A sequence of LinkInfo objects.
     *
     **/
    LinkInfo[] getLinkInfoSeq();

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @return The sequence of Ice identities for the subscriber objects.
     *
     **/
    Ice.Identity[] getSubscribers();

    /**
     * Destroy the topic.
     *
     **/
    void destroy();
}
