// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceStorm;

/**
 * A topic manager manages topics, and subscribers to topics.
 *
 * @see Topic
 *
 **/
public interface _TopicManagerOperationsNC
{
    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @return A proxy to the topic instance.
     *
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     *
     **/
    TopicPrx create(String name)
        throws TopicExists;

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @return A proxy to the topic instance.
     *
     * @throws NoSuchTopic Raised if the topic does not exist.
     *
     **/
    TopicPrx retrieve(String name)
        throws NoSuchTopic;

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @return A dictionary of string, topic proxy pairs.
     *
     **/
    java.util.Map<java.lang.String, TopicPrx> retrieveAll();

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();
}
