/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.ApplicationInfo;
import com.zeroc.IceGrid.ApplicationInfoSeqHelper;
import com.zeroc.IceGrid.ApplicationUpdateInfo;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;

public interface ApplicationObserver
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void applicationInit(int var1, List<ApplicationInfo> var2, Current var3);

    public void applicationAdded(int var1, ApplicationInfo var2, Current var3);

    public void applicationRemoved(int var1, String var2, Current var3);

    public void applicationUpdated(int var1, ApplicationUpdateInfo var2, Current var3);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return ApplicationObserver.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::ApplicationObserver";
    }

    public static CompletionStage<OutputStream> _iceD_applicationInit(ApplicationObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_serial = istr.readInt();
        List<ApplicationInfo> iceP_applications = ApplicationInfoSeqHelper.read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationInit(iceP_serial, iceP_applications, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_applicationAdded(ApplicationObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_serial = istr.readInt();
        ApplicationInfo iceP_desc = ApplicationInfo.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationAdded(iceP_serial, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_applicationRemoved(ApplicationObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_serial = istr.readInt();
        String iceP_name = istr.readString();
        inS.endReadParams();
        obj.applicationRemoved(iceP_serial, iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_applicationUpdated(ApplicationObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_serial = istr.readInt();
        ApplicationUpdateInfo iceP_desc = ApplicationUpdateInfo.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationUpdated(iceP_serial, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return ApplicationObserver._iceD_applicationAdded(this, in, current);
            }
            case 1: {
                return ApplicationObserver._iceD_applicationInit(this, in, current);
            }
            case 2: {
                return ApplicationObserver._iceD_applicationRemoved(this, in, current);
            }
            case 3: {
                return ApplicationObserver._iceD_applicationUpdated(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 5: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 6: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::ApplicationObserver"};
        _iceOps = new String[]{"applicationAdded", "applicationInit", "applicationRemoved", "applicationUpdated", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

