/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Glacier2.Session;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AccessDeniedException;
import com.zeroc.IceGrid.AdapterObserverPrx;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.ApplicationObserverPrx;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.NodeNotExistException;
import com.zeroc.IceGrid.NodeObserverPrx;
import com.zeroc.IceGrid.NodeUnreachableException;
import com.zeroc.IceGrid.ObjectObserverPrx;
import com.zeroc.IceGrid.ObserverAlreadyRegisteredException;
import com.zeroc.IceGrid.RegistryNotExistException;
import com.zeroc.IceGrid.RegistryObserverPrx;
import com.zeroc.IceGrid.RegistryUnreachableException;
import com.zeroc.IceGrid.ServerNotExistException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface AdminSession
extends Session {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void keepAlive(Current var1);

    public AdminPrx getAdmin(Current var1);

    public ObjectPrx getAdminCallbackTemplate(Current var1);

    public void setObservers(RegistryObserverPrx var1, NodeObserverPrx var2, ApplicationObserverPrx var3, AdapterObserverPrx var4, ObjectObserverPrx var5, Current var6) throws ObserverAlreadyRegisteredException;

    public void setObserversByIdentity(Identity var1, Identity var2, Identity var3, Identity var4, Identity var5, Current var6) throws ObserverAlreadyRegisteredException;

    public int startUpdate(Current var1) throws AccessDeniedException;

    public void finishUpdate(Current var1) throws AccessDeniedException;

    public String getReplicaName(Current var1);

    public FileIteratorPrx openServerLog(String var1, String var2, int var3, Current var4) throws DeploymentException, FileNotAvailableException, NodeUnreachableException, ServerNotExistException;

    public FileIteratorPrx openServerStdErr(String var1, int var2, Current var3) throws DeploymentException, FileNotAvailableException, NodeUnreachableException, ServerNotExistException;

    public FileIteratorPrx openServerStdOut(String var1, int var2, Current var3) throws DeploymentException, FileNotAvailableException, NodeUnreachableException, ServerNotExistException;

    public FileIteratorPrx openNodeStdErr(String var1, int var2, Current var3) throws FileNotAvailableException, NodeNotExistException, NodeUnreachableException;

    public FileIteratorPrx openNodeStdOut(String var1, int var2, Current var3) throws FileNotAvailableException, NodeNotExistException, NodeUnreachableException;

    public FileIteratorPrx openRegistryStdErr(String var1, int var2, Current var3) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException;

    public FileIteratorPrx openRegistryStdOut(String var1, int var2, Current var3) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException;

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return AdminSession.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::AdminSession";
    }

    public static CompletionStage<OutputStream> _iceD_keepAlive(AdminSession obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        obj.keepAlive(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getAdmin(AdminSession obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        AdminPrx ret = obj.getAdmin(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getAdminCallbackTemplate(AdminSession obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getAdminCallbackTemplate(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_setObservers(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        RegistryObserverPrx iceP_registryObs = RegistryObserverPrx.uncheckedCast(istr.readProxy());
        NodeObserverPrx iceP_nodeObs = NodeObserverPrx.uncheckedCast(istr.readProxy());
        ApplicationObserverPrx iceP_appObs = ApplicationObserverPrx.uncheckedCast(istr.readProxy());
        AdapterObserverPrx iceP_adptObs = AdapterObserverPrx.uncheckedCast(istr.readProxy());
        ObjectObserverPrx iceP_objObs = ObjectObserverPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_setObserversByIdentity(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_registryObs = Identity.ice_read((InputStream)istr);
        Identity iceP_nodeObs = Identity.ice_read((InputStream)istr);
        Identity iceP_appObs = Identity.ice_read((InputStream)istr);
        Identity iceP_adptObs = Identity.ice_read((InputStream)istr);
        Identity iceP_objObs = Identity.ice_read((InputStream)istr);
        inS.endReadParams();
        obj.setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_startUpdate(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        int ret = obj.startUpdate(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_finishUpdate(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        obj.finishUpdate(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getReplicaName(AdminSession obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        String ret = obj.getReplicaName(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openServerLog(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        String iceP_path = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerLog(iceP_id, iceP_path, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openServerStdErr(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerStdErr(iceP_id, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openServerStdOut(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openServerStdOut(iceP_id, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openNodeStdErr(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openNodeStdErr(iceP_name, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openNodeStdOut(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openNodeStdOut(iceP_name, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openRegistryStdErr(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openRegistryStdErr(iceP_name, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_openRegistryStdOut(AdminSession obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        int iceP_count = istr.readInt();
        inS.endReadParams();
        FileIteratorPrx ret = obj.openRegistryStdOut(iceP_name, iceP_count, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Session._iceD_destroy((Session)this, (Incoming)in, (Current)current);
            }
            case 1: {
                return AdminSession._iceD_finishUpdate(this, in, current);
            }
            case 2: {
                return AdminSession._iceD_getAdmin(this, in, current);
            }
            case 3: {
                return AdminSession._iceD_getAdminCallbackTemplate(this, in, current);
            }
            case 4: {
                return AdminSession._iceD_getReplicaName(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 6: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 8: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
            case 9: {
                return AdminSession._iceD_keepAlive(this, in, current);
            }
            case 10: {
                return AdminSession._iceD_openNodeStdErr(this, in, current);
            }
            case 11: {
                return AdminSession._iceD_openNodeStdOut(this, in, current);
            }
            case 12: {
                return AdminSession._iceD_openRegistryStdErr(this, in, current);
            }
            case 13: {
                return AdminSession._iceD_openRegistryStdOut(this, in, current);
            }
            case 14: {
                return AdminSession._iceD_openServerLog(this, in, current);
            }
            case 15: {
                return AdminSession._iceD_openServerStdErr(this, in, current);
            }
            case 16: {
                return AdminSession._iceD_openServerStdOut(this, in, current);
            }
            case 17: {
                return AdminSession._iceD_setObservers(this, in, current);
            }
            case 18: {
                return AdminSession._iceD_setObserversByIdentity(this, in, current);
            }
            case 19: {
                return AdminSession._iceD_startUpdate(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::Session", "::Ice::Object", "::IceGrid::AdminSession"};
        _iceOps = new String[]{"destroy", "finishUpdate", "getAdmin", "getAdminCallbackTemplate", "getReplicaName", "ice_id", "ice_ids", "ice_isA", "ice_ping", "keepAlive", "openNodeStdErr", "openNodeStdOut", "openRegistryStdErr", "openRegistryStdOut", "openServerLog", "openServerStdErr", "openServerStdOut", "setObservers", "setObserversByIdentity", "startUpdate"};
    }
}

