/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.AdapterInfoSeqHelper;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface AdapterObserver
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void adapterInit(AdapterInfo[] var1, Current var2);

    public void adapterAdded(AdapterInfo var1, Current var2);

    public void adapterUpdated(AdapterInfo var1, Current var2);

    public void adapterRemoved(String var1, Current var2);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return AdapterObserver.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::AdapterObserver";
    }

    public static CompletionStage<OutputStream> _iceD_adapterInit(AdapterObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        AdapterInfo[] iceP_adpts = AdapterInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.adapterInit(iceP_adpts, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_adapterAdded(AdapterObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        AdapterInfo iceP_info = AdapterInfo.ice_read(istr);
        inS.endReadParams();
        obj.adapterAdded(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_adapterUpdated(AdapterObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        AdapterInfo iceP_info = AdapterInfo.ice_read(istr);
        inS.endReadParams();
        obj.adapterUpdated(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_adapterRemoved(AdapterObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        inS.endReadParams();
        obj.adapterRemoved(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return AdapterObserver._iceD_adapterAdded(this, in, current);
            }
            case 1: {
                return AdapterObserver._iceD_adapterInit(this, in, current);
            }
            case 2: {
                return AdapterObserver._iceD_adapterRemoved(this, in, current);
            }
            case 3: {
                return AdapterObserver._iceD_adapterUpdated(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 5: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 6: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::AdapterObserver"};
        _iceOps = new String[]{"adapterAdded", "adapterInit", "adapterRemoved", "adapterUpdated", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

