// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 *
 * @see Session
 * @see AdminSession
 *
 **/
public interface RegistryPrx extends Ice.ObjectPrx
{
    /**
     * Create a client session.
     *
     * @see Session
     * @see Glacier2.PermissionsVerifier
     *
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSession(String userId, String password)
        throws PermissionDeniedException;

    /**
     * Create a client session.
     *
     * @see Session
     * @see Glacier2.PermissionsVerifier
     *
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSession(String userId, String password, java.util.Map<String, String> __ctx)
        throws PermissionDeniedException;

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Ice.Callback __cb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Callback_Registry_createSession __cb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Callback_Registry_createSession __cb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, 
                                               String password, 
                                               IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, 
                                               String password, 
                                               IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                               IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, 
                                               String password, 
                                               java.util.Map<String, String> __ctx, 
                                               IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create a client session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSession(String userId, 
                                               String password, 
                                               java.util.Map<String, String> __ctx, 
                                               IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                               IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create a client session.
     * 
     * @param __result The asynchronous result object.
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx end_createSession(Ice.AsyncResult __result)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     *
     * @see Session
     * @see Glacier2.PermissionsVerifier
     *
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSession(String userId, String password)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     *
     * @see Session
     * @see Glacier2.PermissionsVerifier
     *
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @param userId The user id.
     *
     * @param password The password for the given user id.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSession(String userId, String password, java.util.Map<String, String> __ctx)
        throws PermissionDeniedException;

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Ice.Callback __cb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Callback_Registry_createAdminSession __cb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, Callback_Registry_createAdminSession __cb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, 
                                                    String password, 
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, 
                                                    String password, 
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                    IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, 
                                                    String password, 
                                                    java.util.Map<String, String> __ctx, 
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create an administrative session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, 
                                                    String password, 
                                                    java.util.Map<String, String> __ctx, 
                                                    IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                    IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create an administrative session.
     * 
     * @param __result The asynchronous result object.
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx end_createAdminSession(Ice.AsyncResult __result)
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     *
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     *
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSessionFromSecureConnection()
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     *
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     *
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public SessionPrx createSessionFromSecureConnection(java.util.Map<String, String> __ctx)
        throws PermissionDeniedException;

    /**
     * Create a client session from a secure connection.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection();

    /**
     * Create a client session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Ice.Callback __cb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Callback_Registry_createSessionFromSecureConnection __cb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Callback_Registry_createSessionFromSecureConnection __cb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                                   IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, 
                                                                   IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, 
                                                                   IceInternal.Functional_GenericCallback1<SessionPrx> __responseCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                                   IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create a client session from a secure connection.
     * 
     * @param __result The asynchronous result object.
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx end_createSessionFromSecureConnection(Ice.AsyncResult __result)
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     *
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     *
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSessionFromSecureConnection()
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     *
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     *
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     *
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     **/
    public AdminSessionPrx createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx)
        throws PermissionDeniedException;

    /**
     * Create an administrative session from a secure connection.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection();

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Ice.Callback __cb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Callback_Registry_createAdminSessionFromSecureConnection __cb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, Callback_Registry_createAdminSessionFromSecureConnection __cb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                                        IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, 
                                                                        IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, 
                                                                        IceInternal.Functional_GenericCallback1<AdminSessionPrx> __responseCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                                        IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __result The asynchronous result object.
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx end_createAdminSessionFromSecureConnection(Ice.AsyncResult __result)
        throws PermissionDeniedException;

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     *
     * @return The timeout (in seconds).
     *
     **/
    public int getSessionTimeout();

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     *
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     *
     * @param __ctx The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     **/
    public int getSessionTimeout(java.util.Map<String, String> __ctx);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout();

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Ice.Callback __cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Callback_Registry_getSessionTimeout __cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Callback_Registry_getSessionTimeout __cb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(IceInternal.Functional_IntCallback __responseCb, 
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(IceInternal.Functional_IntCallback __responseCb, 
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                   IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, 
                                                   IceInternal.Functional_IntCallback __responseCb, 
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, 
                                                   IceInternal.Functional_IntCallback __responseCb, 
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                   IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __result The asynchronous result object.
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     * 
     * @return The timeout (in seconds).
     * 
     **/
    public int end_getSessionTimeout(Ice.AsyncResult __result);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @return The timeout (in seconds).
     *
     **/
    public int getACMTimeout();

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param __ctx The Context map to send with the invocation.
     * @return The timeout (in seconds).
     *
     **/
    public int getACMTimeout(java.util.Map<String, String> __ctx);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout();

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> __ctx);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(Ice.Callback __cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(Callback_Registry_getACMTimeout __cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> __ctx, Callback_Registry_getACMTimeout __cb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(IceInternal.Functional_IntCallback __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(IceInternal.Functional_IntCallback __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                               IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> __ctx, 
                                               IceInternal.Functional_IntCallback __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getACMTimeout(java.util.Map<String, String> __ctx, 
                                               IceInternal.Functional_IntCallback __responseCb, 
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                               IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the value of the ACM timeout. Clients supporting ACM
     * connection heartbeats can enable them instead of explicitly
     * sending keep alives requests.
     * 
     * NOTE: This method is only available since Ice 3.6.
     * 
     * @param __result The asynchronous result object.
     * @return The timeout (in seconds).
     * 
     **/
    public int end_getACMTimeout(Ice.AsyncResult __result);
}
