// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are either created with the
 * {@link Registry} object or the registry client {@link Glacier2.SessionManager}
 * object.
 *
 * @see Registry
 * @see Glacier2.SessionManager
 *
 **/
public abstract class _SessionDisp extends Ice.ObjectImpl implements Session
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Glacier2::Session",
        "::Ice::Object",
        "::IceGrid::Session"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[2];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[2];
    }

    public static String ice_staticId()
    {
        return __ids[2];
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     *
     **/
    public final void destroy()
    {
        destroy(null);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    public final void allocateObjectById_async(AMD_Session_allocateObjectById __cb, Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        allocateObjectById_async(__cb, id, null);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public final void allocateObjectByType_async(AMD_Session_allocateObjectByType __cb, String type)
        throws AllocationException
    {
        allocateObjectByType_async(__cb, type, null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     **/
    public final void keepAlive()
    {
        keepAlive(null);
    }

    /**
     * Release an object.
     *
     * @param id The identity of the object to release.
     *
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     *
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     *
     * @see #allocateObjectById
     * @see #allocateObjectByType
     *
     **/
    public final void releaseObject(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException
    {
        releaseObject(id, null);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of
     * this timeout.
     *
     * @param timeout The timeout in milliseconds.
     *
     * @see #allocateObjectById
     * @see #allocateObjectByType
     *
     **/
    public final void setAllocationTimeout(int timeout)
    {
        setAllocationTimeout(timeout, null);
    }

    public static Ice.DispatchStatus ___keepAlive(Session __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        __obj.keepAlive(__current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___allocateObjectById(Session __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.Identity id = null;
        id = Ice.Identity.__read(__is, id);
        __inS.endReadParams();
        AMD_Session_allocateObjectById __cb = new _AMD_Session_allocateObjectById(__inS);
        try
        {
            __obj.allocateObjectById_async(__cb, id, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___allocateObjectByType(Session __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String type;
        type = __is.readString();
        __inS.endReadParams();
        AMD_Session_allocateObjectByType __cb = new _AMD_Session_allocateObjectByType(__inS);
        try
        {
            __obj.allocateObjectByType_async(__cb, type, __current);
        }
        catch(java.lang.Exception ex)
        {
            __cb.ice_exception(ex);
        }
        return Ice.DispatchStatus.DispatchAsync;
    }

    public static Ice.DispatchStatus ___releaseObject(Session __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.Identity id = null;
        id = Ice.Identity.__read(__is, id);
        __inS.endReadParams();
        try
        {
            __obj.releaseObject(id, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AllocationException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ObjectNotRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___setAllocationTimeout(Session __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        int timeout;
        timeout = __is.readInt();
        __inS.endReadParams();
        __obj.setAllocationTimeout(timeout, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "allocateObjectById",
        "allocateObjectByType",
        "destroy",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "keepAlive",
        "releaseObject",
        "setAllocationTimeout"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___allocateObjectById(this, in, __current);
            }
            case 1:
            {
                return ___allocateObjectByType(this, in, __current);
            }
            case 2:
            {
                return Glacier2._SessionDisp.___destroy(this, in, __current);
            }
            case 3:
            {
                return ___ice_id(this, in, __current);
            }
            case 4:
            {
                return ___ice_ids(this, in, __current);
            }
            case 5:
            {
                return ___ice_isA(this, in, __current);
            }
            case 6:
            {
                return ___ice_ping(this, in, __current);
            }
            case 7:
            {
                return ___keepAlive(this, in, __current);
            }
            case 8:
            {
                return ___releaseObject(this, in, __current);
            }
            case 9:
            {
                return ___setAllocationTimeout(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
