// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 *
 **/
public abstract class _NodeObserverDisp extends Ice.ObjectImpl implements NodeObserver
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceGrid::NodeObserver"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[1];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String ice_staticId()
    {
        return __ids[1];
    }

    /**
     * The <tt>nodeDown</tt> operation is called to notify an observer that a node
     * went down.
     *
     * @param name The node name.
     *
     **/
    public final void nodeDown(String name)
    {
        nodeDown(name, null);
    }

    /**
     * The <tt>nodeInit</tt> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     *
     * @param nodes The current state of the nodes.
     *
     **/
    public final void nodeInit(NodeDynamicInfo[] nodes)
    {
        nodeInit(nodes, null);
    }

    /**
     * The <tt>nodeUp</tt> operation is called to notify an observer that a node
     * came up.
     *
     * @param node The node state.
     *
     **/
    public final void nodeUp(NodeDynamicInfo node)
    {
        nodeUp(node, null);
    }

    /**
     * The <tt>updateAdapter</tt> operation is called to notify an observer that
     * the state of an adapter changed.
     *
     * @param node The node hosting the adapter.
     *
     * @param updatedInfo The new adapter state.
     *
     **/
    public final void updateAdapter(String node, AdapterDynamicInfo updatedInfo)
    {
        updateAdapter(node, updatedInfo, null);
    }

    /**
     * The <tt>updateServer</tt> operation is called to notify an observer that
     * the state of a server changed.
     *
     * @param node The node hosting the server.
     *
     * @param updatedInfo The new server state.
     *
     **/
    public final void updateServer(String node, ServerDynamicInfo updatedInfo)
    {
        updateServer(node, updatedInfo, null);
    }

    public static Ice.DispatchStatus ___nodeInit(NodeObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        NodeDynamicInfo[] nodes;
        nodes = NodeDynamicInfoSeqHelper.read(__is);
        __inS.endReadParams();
        __obj.nodeInit(nodes, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___nodeUp(NodeObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        NodeDynamicInfo node = null;
        node = NodeDynamicInfo.__read(__is, node);
        __inS.endReadParams();
        __obj.nodeUp(node, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___nodeDown(NodeObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        __obj.nodeDown(name, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___updateServer(NodeObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String node;
        ServerDynamicInfo updatedInfo = null;
        node = __is.readString();
        updatedInfo = ServerDynamicInfo.__read(__is, updatedInfo);
        __inS.endReadParams();
        __obj.updateServer(node, updatedInfo, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___updateAdapter(NodeObserver __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String node;
        AdapterDynamicInfo updatedInfo = null;
        node = __is.readString();
        updatedInfo = AdapterDynamicInfo.__read(__is, updatedInfo);
        __inS.endReadParams();
        __obj.updateAdapter(node, updatedInfo, __current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "nodeDown",
        "nodeInit",
        "nodeUp",
        "updateAdapter",
        "updateServer"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___ice_id(this, in, __current);
            }
            case 1:
            {
                return ___ice_ids(this, in, __current);
            }
            case 2:
            {
                return ___ice_isA(this, in, __current);
            }
            case 3:
            {
                return ___ice_ping(this, in, __current);
            }
            case 4:
            {
                return ___nodeDown(this, in, __current);
            }
            case 5:
            {
                return ___nodeInit(this, in, __current);
            }
            case 6:
            {
                return ___nodeUp(this, in, __current);
            }
            case 7:
            {
                return ___updateAdapter(this, in, __current);
            }
            case 8:
            {
                return ___updateServer(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
