// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either with the {@link Registry}
 * object or the registry admin {@link Glacier2.SessionManager} object.
 *
 * @see Registry
 * @see Glacier2.SessionManager
 *
 **/
public abstract class _AdminSessionDisp extends Ice.ObjectImpl implements AdminSession
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Glacier2::Session",
        "::Ice::Object",
        "::IceGrid::AdminSession"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[2];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[2];
    }

    public static String ice_staticId()
    {
        return __ids[2];
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     *
     **/
    public final void destroy()
    {
        destroy(null);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     *
     **/
    public final void finishUpdate()
        throws AccessDeniedException
    {
        finishUpdate(null);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @return The admin interface proxy.
     *
     **/
    public final AdminPrx getAdmin()
    {
        return getAdmin(null);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     *
     **/
    public final Ice.ObjectPrx getAdminCallbackTemplate()
    {
        return getAdminCallbackTemplate(null);
    }

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @return The replica name of the registry.
     *
     **/
    public final String getReplicaName()
    {
        return getReplicaName(null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     **/
    public final void keepAlive()
    {
        keepAlive(null);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public final FileIteratorPrx openNodeStdErr(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdErr(name, count, null);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public final FileIteratorPrx openNodeStdOut(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdOut(name, count, null);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public final FileIteratorPrx openRegistryStdErr(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdErr(name, count, null);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public final FileIteratorPrx openRegistryStdOut(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdOut(name, count, null);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final FileIteratorPrx openServerLog(String id, String path, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerLog(id, path, count, null);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final FileIteratorPrx openServerStdErr(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdErr(id, count, null);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public final FileIteratorPrx openServerStdOut(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdOut(id, count, null);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public final void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObservers(registryObs, nodeObs, appObs, adptObs, objObs, null);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public final void setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, null);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @return The current serial.
     *
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     *
     **/
    public final int startUpdate()
        throws AccessDeniedException
    {
        return startUpdate(null);
    }

    public static Ice.DispatchStatus ___keepAlive(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        __obj.keepAlive(__current);
        __inS.__writeEmptyParams();
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getAdmin(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        AdminPrx __ret = __obj.getAdmin(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        AdminPrxHelper.__write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getAdminCallbackTemplate(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        Ice.ObjectPrx __ret = __obj.getAdminCallbackTemplate(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        __os.writeProxy(__ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___setObservers(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        RegistryObserverPrx registryObs;
        NodeObserverPrx nodeObs;
        ApplicationObserverPrx appObs;
        AdapterObserverPrx adptObs;
        ObjectObserverPrx objObs;
        registryObs = RegistryObserverPrxHelper.__read(__is);
        nodeObs = NodeObserverPrxHelper.__read(__is);
        appObs = ApplicationObserverPrxHelper.__read(__is);
        adptObs = AdapterObserverPrxHelper.__read(__is);
        objObs = ObjectObserverPrxHelper.__read(__is);
        __inS.endReadParams();
        try
        {
            __obj.setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(ObserverAlreadyRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___setObserversByIdentity(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        Ice.Identity registryObs = null;
        Ice.Identity nodeObs = null;
        Ice.Identity appObs = null;
        Ice.Identity adptObs = null;
        Ice.Identity objObs = null;
        registryObs = Ice.Identity.__read(__is, registryObs);
        nodeObs = Ice.Identity.__read(__is, nodeObs);
        appObs = Ice.Identity.__read(__is, appObs);
        adptObs = Ice.Identity.__read(__is, adptObs);
        objObs = Ice.Identity.__read(__is, objObs);
        __inS.endReadParams();
        try
        {
            __obj.setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(ObserverAlreadyRegisteredException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___startUpdate(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        try
        {
            int __ret = __obj.startUpdate(__current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeInt(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___finishUpdate(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        try
        {
            __obj.finishUpdate(__current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(AccessDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getReplicaName(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        __inS.readEmptyParams();
        String __ret = __obj.getReplicaName(__current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        __os.writeString(__ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___openServerLog(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        String path;
        int count;
        id = __is.readString();
        path = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openServerLog(id, path, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openServerStdErr(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        int count;
        id = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openServerStdErr(id, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openServerStdOut(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String id;
        int count;
        id = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openServerStdOut(id, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(DeploymentException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(ServerNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openNodeStdErr(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        int count;
        name = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openNodeStdErr(name, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openNodeStdOut(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        int count;
        name = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openNodeStdOut(name, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(NodeUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openRegistryStdErr(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        int count;
        name = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openRegistryStdErr(name, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___openRegistryStdOut(AdminSession __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        int count;
        name = __is.readString();
        count = __is.readInt();
        __inS.endReadParams();
        try
        {
            FileIteratorPrx __ret = __obj.openRegistryStdOut(name, count, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
            FileIteratorPrxHelper.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(FileNotAvailableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryNotExistException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
        catch(RegistryUnreachableException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    private final static String[] __all =
    {
        "destroy",
        "finishUpdate",
        "getAdmin",
        "getAdminCallbackTemplate",
        "getReplicaName",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "keepAlive",
        "openNodeStdErr",
        "openNodeStdOut",
        "openRegistryStdErr",
        "openRegistryStdOut",
        "openServerLog",
        "openServerStdErr",
        "openServerStdOut",
        "setObservers",
        "setObserversByIdentity",
        "startUpdate"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return Glacier2._SessionDisp.___destroy(this, in, __current);
            }
            case 1:
            {
                return ___finishUpdate(this, in, __current);
            }
            case 2:
            {
                return ___getAdmin(this, in, __current);
            }
            case 3:
            {
                return ___getAdminCallbackTemplate(this, in, __current);
            }
            case 4:
            {
                return ___getReplicaName(this, in, __current);
            }
            case 5:
            {
                return ___ice_id(this, in, __current);
            }
            case 6:
            {
                return ___ice_ids(this, in, __current);
            }
            case 7:
            {
                return ___ice_isA(this, in, __current);
            }
            case 8:
            {
                return ___ice_ping(this, in, __current);
            }
            case 9:
            {
                return ___keepAlive(this, in, __current);
            }
            case 10:
            {
                return ___openNodeStdErr(this, in, __current);
            }
            case 11:
            {
                return ___openNodeStdOut(this, in, __current);
            }
            case 12:
            {
                return ___openRegistryStdErr(this, in, __current);
            }
            case 13:
            {
                return ___openRegistryStdOut(this, in, __current);
            }
            case 14:
            {
                return ___openServerLog(this, in, __current);
            }
            case 15:
            {
                return ___openServerStdErr(this, in, __current);
            }
            case 16:
            {
                return ___openServerStdOut(this, in, __current);
            }
            case 17:
            {
                return ___setObservers(this, in, __current);
            }
            case 18:
            {
                return ___setObserversByIdentity(this, in, __current);
            }
            case 19:
            {
                return ___startUpdate(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
