// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `UserAccountMapper.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 *
 **/
public interface UserAccountMapperPrx extends Ice.ObjectPrx
{
    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @return The user account name.
     *
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     *
     **/
    public String getUserAccount(String user)
        throws UserAccountNotFoundException;

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     *
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     *
     * @param __ctx The Context map to send with the invocation.
     * @return The user account name.
     *
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     *
     **/
    public String getUserAccount(String user, java.util.Map<String, String> __ctx)
        throws UserAccountNotFoundException;

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Ice.Callback __cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Callback_UserAccountMapper_getUserAccount __cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx, Callback_UserAccountMapper_getUserAccount __cb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, 
                                                IceInternal.Functional_GenericCallback1<String> __responseCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, 
                                                IceInternal.Functional_GenericCallback1<String> __responseCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, 
                                                java.util.Map<String, String> __ctx, 
                                                IceInternal.Functional_GenericCallback1<String> __responseCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, 
                                                java.util.Map<String, String> __ctx, 
                                                IceInternal.Functional_GenericCallback1<String> __responseCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                                IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __result The asynchronous result object.
     * @return The user account name.
     * 
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     * 
     **/
    public String end_getUserAccount(Ice.AsyncResult __result)
        throws UserAccountNotFoundException;
}
