// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * Information about an IceGrid node.
 *
 **/
public class NodeInfo implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The name of the node.
     *
     **/
    public String name;

    /**
     * The operating system name.
     *
     **/
    public String os;

    /**
     * The network name of the host running this node (as defined in
     * uname()).
     *
     **/
    public String hostname;

    /**
     * The operation system release level (as defined in uname()).
     *
     **/
    public String release;

    /**
     * The operation system version (as defined in uname()).
     *
     **/
    public String version;

    /**
     * The machine hardware type (as defined in uname()).
     *
     **/
    public String machine;

    /**
     * The number of processor threads on the node.
     * For example, nProcessors is 8 on a computer with a single quad-core
     * processor and two HT threads per core.
     *
     **/
    public int nProcessors;

    /**
     * The path to the node data directory.
     *
     **/
    public String dataDir;

    public NodeInfo()
    {
        name = "";
        os = "";
        hostname = "";
        release = "";
        version = "";
        machine = "";
        dataDir = "";
    }

    public NodeInfo(String name, String os, String hostname, String release, String version, String machine, int nProcessors, String dataDir)
    {
        this.name = name;
        this.os = os;
        this.hostname = hostname;
        this.release = release;
        this.version = version;
        this.machine = machine;
        this.nProcessors = nProcessors;
        this.dataDir = dataDir;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        NodeInfo _r = null;
        if(rhs instanceof NodeInfo)
        {
            _r = (NodeInfo)rhs;
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(os != _r.os)
            {
                if(os == null || _r.os == null || !os.equals(_r.os))
                {
                    return false;
                }
            }
            if(hostname != _r.hostname)
            {
                if(hostname == null || _r.hostname == null || !hostname.equals(_r.hostname))
                {
                    return false;
                }
            }
            if(release != _r.release)
            {
                if(release == null || _r.release == null || !release.equals(_r.release))
                {
                    return false;
                }
            }
            if(version != _r.version)
            {
                if(version == null || _r.version == null || !version.equals(_r.version))
                {
                    return false;
                }
            }
            if(machine != _r.machine)
            {
                if(machine == null || _r.machine == null || !machine.equals(_r.machine))
                {
                    return false;
                }
            }
            if(nProcessors != _r.nProcessors)
            {
                return false;
            }
            if(dataDir != _r.dataDir)
            {
                if(dataDir == null || _r.dataDir == null || !dataDir.equals(_r.dataDir))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 5381;
        __h = IceInternal.HashUtil.hashAdd(__h, "::IceGrid::NodeInfo");
        __h = IceInternal.HashUtil.hashAdd(__h, name);
        __h = IceInternal.HashUtil.hashAdd(__h, os);
        __h = IceInternal.HashUtil.hashAdd(__h, hostname);
        __h = IceInternal.HashUtil.hashAdd(__h, release);
        __h = IceInternal.HashUtil.hashAdd(__h, version);
        __h = IceInternal.HashUtil.hashAdd(__h, machine);
        __h = IceInternal.HashUtil.hashAdd(__h, nProcessors);
        __h = IceInternal.HashUtil.hashAdd(__h, dataDir);
        return __h;
    }

    public NodeInfo
    clone()
    {
        NodeInfo c = null;
        try
        {
            c = (NodeInfo)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeString(os);
        __os.writeString(hostname);
        __os.writeString(release);
        __os.writeString(version);
        __os.writeString(machine);
        __os.writeInt(nProcessors);
        __os.writeString(dataDir);
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        os = __is.readString();
        hostname = __is.readString();
        release = __is.readString();
        version = __is.readString();
        machine = __is.readString();
        nProcessors = __is.readInt();
        dataDir = __is.readString();
    }

    static public void
    __write(IceInternal.BasicStream __os, NodeInfo __v)
    {
        if(__v == null)
        {
            __nullMarshalValue.__write(__os);
        }
        else
        {
            __v.__write(__os);
        }
    }

    static public NodeInfo
    __read(IceInternal.BasicStream __is, NodeInfo __v)
    {
        if(__v == null)
        {
             __v = new NodeInfo();
        }
        __v.__read(__is);
        return __v;
    }
    
    private static final NodeInfo __nullMarshalValue = new NodeInfo();

    public static final long serialVersionUID = -3769387931156004420L;
}
