/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBox;

import com.zeroc.Ice.Application;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectAdapterDeactivatedException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceBox.AlreadyStartedException;
import com.zeroc.IceBox.AlreadyStoppedException;
import com.zeroc.IceBox.FailureException;
import com.zeroc.IceBox.NoSuchServiceException;
import com.zeroc.IceBox.Service;
import com.zeroc.IceBox.ServiceManager;
import com.zeroc.IceBox.ServiceObserverPrx;
import com.zeroc.IceBox.SliceChecksums;
import com.zeroc.IceUtilInternal.Options;
import com.zeroc.IceUtilInternal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ServiceManagerI
implements ServiceManager {
    public static final int StatusStopping = 0;
    public static final int StatusStopped = 1;
    public static final int StatusStarting = 2;
    public static final int StatusStarted = 3;
    private Communicator _communicator;
    private boolean _adminEnabled = false;
    private Set<String> _adminFacetFilter;
    private Communicator _sharedCommunicator;
    private Logger _logger;
    private String[] _argv;
    private List<ServiceInfo> _services = new LinkedList<ServiceInfo>();
    private boolean _pendingStatusChanges = false;
    private HashSet<ServiceObserverPrx> _observers = new HashSet();
    private int _traceServiceObserver = 0;
    private Map<String, ClassLoader> _classLoaders;

    public ServiceManagerI(Communicator communicator, String[] args) {
        this._communicator = communicator;
        this._logger = this._communicator.getLogger();
        Properties props = this._communicator.getProperties();
        if (props.getProperty("Ice.Admin.Enabled").isEmpty()) {
            this._adminEnabled = !props.getProperty("Ice.Admin.Endpoints").isEmpty();
        } else {
            boolean bl = this._adminEnabled = props.getPropertyAsInt("Ice.Admin.Enabled") > 0;
        }
        if (this._adminEnabled) {
            String[] facetFilter = props.getPropertyAsList("Ice.Admin.Facets");
            this._adminFacetFilter = facetFilter.length > 0 ? new HashSet<String>(Arrays.asList(facetFilter)) : new HashSet<String>();
        }
        this._argv = args;
        this._traceServiceObserver = props.getPropertyAsInt("IceBox.Trace.ServiceObserver");
    }

    @Override
    public Map<String, String> getSliceChecksums(Current current) {
        return SliceChecksums.checksums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService(String name, Current current) throws AlreadyStartedException, NoSuchServiceException {
        ServiceInfo info = null;
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            for (ServiceInfo p : this._services) {
                if (!p.name.equals(name)) continue;
                if (p.status == 3) {
                    throw new AlreadyStartedException();
                }
                p.status = 2;
                info = p.clone();
                break;
            }
            if (info == null) {
                throw new NoSuchServiceException();
            }
            this._pendingStatusChanges = true;
        }
        boolean started = false;
        try {
            info.service.start(name, info.communicator == null ? this._sharedCommunicator : info.communicator, info.args);
            started = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this._logger.warning("ServiceManager: exception while starting service " + info.name + ":\n" + sw.toString());
        }
        ServiceManagerI serviceManagerI2 = this;
        synchronized (serviceManagerI2) {
            for (ServiceInfo p : this._services) {
                if (!p.name.equals(name)) continue;
                if (started) {
                    p.status = 3;
                    ArrayList<String> services = new ArrayList<String>();
                    services.add(name);
                    this.servicesStarted(services, this._observers);
                    break;
                }
                p.status = 1;
                break;
            }
            this._pendingStatusChanges = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(String name, Current current) throws AlreadyStoppedException, NoSuchServiceException {
        ServiceInfo info = null;
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            for (ServiceInfo p : this._services) {
                if (!p.name.equals(name)) continue;
                if (p.status == 1) {
                    throw new AlreadyStoppedException();
                }
                p.status = 0;
                info = p.clone();
                break;
            }
            if (info == null) {
                throw new NoSuchServiceException();
            }
            this._pendingStatusChanges = true;
        }
        boolean stopped = false;
        try {
            info.service.stop();
            stopped = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this._logger.warning("ServiceManager: exception while stopping service " + info.name + ":\n" + sw.toString());
        }
        ServiceManagerI serviceManagerI2 = this;
        synchronized (serviceManagerI2) {
            for (ServiceInfo p : this._services) {
                if (!p.name.equals(name)) continue;
                if (stopped) {
                    p.status = 1;
                    ArrayList<String> services = new ArrayList<String>();
                    services.add(name);
                    this.servicesStopped(services, this._observers);
                    break;
                }
                p.status = 3;
                break;
            }
            this._pendingStatusChanges = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(ServiceObserverPrx observer, Current current) {
        LinkedList<String> activeServices = new LinkedList<String>();
        ServiceManagerI serviceManagerI = this;
        synchronized (serviceManagerI) {
            if (observer != null && this._observers.add(observer)) {
                if (this._traceServiceObserver >= 1) {
                    this._logger.trace("IceBox.ServiceObserver", "Added service observer " + this._communicator.proxyToString((ObjectPrx)observer));
                }
                for (ServiceInfo info : this._services) {
                    if (info.status != 3) continue;
                    activeServices.add(info.name);
                }
            }
        }
        if (activeServices.size() > 0) {
            observer.servicesStartedAsync(activeServices.toArray(new String[0])).exceptionally(ex -> {
                this.observerFailed(observer, (Throwable)ex);
                return null;
            });
        }
    }

    @Override
    public void shutdown(Current current) {
        this._communicator.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        try {
            Properties properties = this._communicator.getProperties();
            ObjectAdapter adapter = null;
            if (properties.getProperty("IceBox.ServiceManager.Endpoints").length() != 0) {
                adapter = this._communicator.createObjectAdapter("IceBox.ServiceManager");
                Identity identity = new Identity();
                identity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
                identity.name = "ServiceManager";
                adapter.add((Object)this, identity);
            }
            String prefix = "IceBox.Service.";
            Map services = properties.getPropertiesForPrefix("IceBox.Service.");
            String[] loadOrder = properties.getPropertyAsList("IceBox.LoadOrder");
            ArrayList<StartServiceInfo> servicesInfo = new ArrayList<StartServiceInfo>();
            for (String name : loadOrder) {
                if (name.length() <= 0) continue;
                String key = "IceBox.Service." + name;
                String value = (String)services.get(key);
                if (value == null) {
                    FailureException ex = new FailureException();
                    ex.reason = "ServiceManager: no service definition for `" + name + "'";
                    throw ex;
                }
                servicesInfo.add(new StartServiceInfo(name, value, this._argv));
                services.remove(key);
            }
            for (Map.Entry entry : services.entrySet()) {
                String name = ((String)entry.getKey()).substring("IceBox.Service.".length());
                String value = (String)entry.getValue();
                servicesInfo.add(new StartServiceInfo(name, value, this._argv));
            }
            if (properties.getPropertiesForPrefix("IceBox.UseSharedCommunicator.").size() > 0) {
                InitializationData initData = new InitializationData();
                initData.properties = this.createServiceProperties("SharedCommunicator");
                for (StartServiceInfo service : servicesInfo) {
                    if (properties.getPropertyAsInt("IceBox.UseSharedCommunicator." + service.name) <= 0) continue;
                    ArrayList remainingArgs = new ArrayList();
                    Properties serviceProps = Util.createProperties((String[])service.args, (Properties)initData.properties, remainingArgs);
                    service.args = remainingArgs.toArray(new String[remainingArgs.size()]);
                    Map allProps = initData.properties.getPropertiesForPrefix("");
                    for (String string : allProps.keySet()) {
                        if (serviceProps.getProperty(string).length() != 0) continue;
                        initData.properties.setProperty(string, "");
                    }
                    for (Map.Entry entry : serviceProps.getPropertiesForPrefix("").entrySet()) {
                        initData.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    service.args = initData.properties.parseCommandLineOptions(service.name, service.args);
                }
                String string = "IceBox.SharedCommunicator.";
                boolean addFacets = this.configureAdmin(initData.properties, string);
                this._sharedCommunicator = Util.initialize((InitializationData)initData);
                if (addFacets) {
                    for (Map.Entry p : this._sharedCommunicator.findAllAdminFacets().entrySet()) {
                        if (((String)p.getKey()).equals("Process")) continue;
                        this._communicator.addAdminFacet((Object)p.getValue(), string + (String)p.getKey());
                    }
                }
            }
            for (StartServiceInfo objectAdapterDeactivatedException : servicesInfo) {
                this.start(objectAdapterDeactivatedException.name, objectAdapterDeactivatedException.className, objectAdapterDeactivatedException.classDir, objectAdapterDeactivatedException.absolutePath, objectAdapterDeactivatedException.args);
            }
            String bundleName = properties.getProperty("IceBox.PrintServicesReady");
            if (bundleName.length() > 0) {
                System.out.println(bundleName + " ready");
            }
            Application.shutdownOnInterrupt();
            try {
                this._communicator.addAdminFacet((Object)this, "IceBox.ServiceManager");
                this._communicator.getAdmin();
            }
            catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
                // empty catch block
            }
            if (adapter != null) {
                try {
                    adapter.activate();
                }
                catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
                    // empty catch block
                }
            }
            this._communicator.waitForShutdown();
            Application.defaultInterrupt();
        }
        catch (FailureException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(ex.reason);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error(sw.toString());
            int n = 1;
            return n;
        }
        catch (Throwable ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            this._logger.error("ServiceManager: caught exception:\n" + sw.toString());
            int n = 1;
            return n;
        }
        finally {
            this.stopAll();
        }
        return 0;
    }

    private synchronized void start(String service, String className, String classDir, boolean absolutePath, String[] args) throws FailureException {
        Communicator communicator;
        Class<?> c = null;
        if (classDir != null) {
            try {
                if (!absolutePath) {
                    classDir = new File(System.getProperty("user.dir") + File.separator + classDir).getCanonicalPath();
                }
                if (!classDir.endsWith(File.separator) && !classDir.endsWith(".jar")) {
                    classDir = classDir + File.separator;
                }
                classDir = URLEncoder.encode(classDir, "UTF-8");
                ClassLoader cl = null;
                if (this._classLoaders == null) {
                    this._classLoaders = new HashMap<String, ClassLoader>();
                } else {
                    cl = this._classLoaders.get(classDir);
                }
                if (cl == null) {
                    URL[] url = new URL[]{new URL("file:///" + classDir)};
                    cl = new URLClassLoader(url);
                    this._classLoaders.put(classDir, cl);
                }
                c = cl.loadClass(className);
            }
            catch (MalformedURLException ex) {
                throw new FailureException("ServiceManager: invalid entry point format `" + classDir + "'", ex);
            }
            catch (IOException ex) {
                throw new FailureException("ServiceManager: invalid path in plug-in entry point `" + classDir + "'", ex);
            }
            catch (ClassNotFoundException ex) {}
        } else {
            c = com.zeroc.IceInternal.Util.findClass((String)className, null);
        }
        if (c == null) {
            throw new FailureException("ServiceManager: class " + className + " not found");
        }
        ServiceInfo info = new ServiceInfo();
        info.name = service;
        info.status = 1;
        info.args = args;
        if (this._communicator.getProperties().getPropertyAsInt("IceBox.UseSharedCommunicator." + service) > 0) {
            assert (this._sharedCommunicator != null);
            communicator = this._sharedCommunicator;
        } else {
            try {
                InitializationData initData = new InitializationData();
                initData.properties = this.createServiceProperties(service);
                String[] serviceArgs = info.args;
                if (serviceArgs.length > 0) {
                    ArrayList remainingArgs = new ArrayList();
                    initData.properties = Util.createProperties((String[])serviceArgs, (Properties)initData.properties, remainingArgs);
                    serviceArgs = remainingArgs.toArray(new String[remainingArgs.size()]);
                    serviceArgs = initData.properties.parseCommandLineOptions(service, serviceArgs);
                }
                if (initData.properties.getProperty("Ice.LogFile").length() == 0 && (initData.properties.getPropertyAsInt("Ice.UseSyslog") <= 0 || System.getProperty("os.name").startsWith("Windows"))) {
                    initData.logger = this._logger.cloneWithPrefix(initData.properties.getProperty("Ice.ProgramName"));
                }
                String serviceFacetNamePrefix = "IceBox.Service." + service + ".";
                boolean addFacets = this.configureAdmin(initData.properties, serviceFacetNamePrefix);
                ArrayList remainingArgs = new ArrayList();
                info.communicator = Util.initialize((String[])serviceArgs, (InitializationData)initData, remainingArgs);
                info.args = remainingArgs.toArray(new String[remainingArgs.size()]);
                communicator = info.communicator;
                if (addFacets) {
                    for (Map.Entry p : communicator.findAllAdminFacets().entrySet()) {
                        if (((String)p.getKey()).equals("Process")) continue;
                        this._communicator.addAdminFacet((Object)p.getValue(), serviceFacetNamePrefix + (String)p.getKey());
                    }
                }
            }
            catch (Throwable ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: exception while starting service " + service;
                e.initCause(ex);
                throw e;
            }
        }
        try {
            try {
                java.lang.Object obj = null;
                try {
                    Constructor<?> con = c.getDeclaredConstructor(Communicator.class);
                    obj = con.newInstance(this._communicator);
                }
                catch (IllegalAccessException ex) {
                    throw new FailureException("ServiceManager: unable to access service constructor " + className + "(com.zeroc.Ice.Communicator)", ex);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() != null) {
                        throw ex.getCause();
                    }
                    throw new FailureException("ServiceManager: exception in service constructor for " + className, ex);
                }
                if (obj == null) {
                    try {
                        obj = c.newInstance();
                    }
                    catch (IllegalAccessException ex) {
                        throw new FailureException("ServiceManager: unable to access default service constructor in class " + className, ex);
                    }
                }
                try {
                    info.service = obj;
                }
                catch (ClassCastException ex) {
                    throw new FailureException("ServiceManager: class " + className + " does not implement com.zeroc.IceBox.Service");
                }
            }
            catch (InstantiationException ex) {
                throw new FailureException("ServiceManager: unable to instantiate class " + className, ex);
            }
            catch (FailureException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new FailureException("ServiceManager: exception in service constructor for " + className, ex);
            }
            try {
                info.service.start(service, communicator, info.args);
            }
            catch (FailureException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                FailureException e = new FailureException();
                e.reason = "ServiceManager: exception while starting service " + service;
                e.initCause(ex);
                throw e;
            }
            info.status = 3;
            this._services.add(info);
        }
        catch (RuntimeException ex) {
            if (info.communicator != null) {
                this.destroyServiceCommunicator(service, info.communicator);
            }
            throw ex;
        }
    }

    private synchronized void stopAll() {
        while (this._pendingStatusChanges) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<String> stoppedServices = new ArrayList<String>();
        ListIterator<ServiceInfo> p = this._services.listIterator(this._services.size());
        while (p.hasPrevious()) {
            ServiceInfo info = p.previous();
            if (info.status == 3) {
                try {
                    info.service.stop();
                    info.status = 1;
                    stoppedServices.add(info.name);
                }
                catch (Throwable e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    this._logger.warning("ServiceManager: exception while stopping service " + info.name + ":\n" + sw.toString());
                }
            }
            if (info.communicator == null) continue;
            this.destroyServiceCommunicator(info.name, info.communicator);
        }
        if (this._sharedCommunicator != null) {
            this.removeAdminFacets("IceBox.SharedCommunicator.");
            try {
                this._sharedCommunicator.destroy();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                this._logger.warning("ServiceManager: exception while destroying shared communicator:\n" + sw.toString());
            }
            this._sharedCommunicator = null;
        }
        this._services.clear();
        this.servicesStopped(stoppedServices, this._observers);
    }

    private void servicesStarted(List<String> services, Set<ServiceObserverPrx> observers) {
        if (services.size() > 0) {
            String[] servicesArray = services.toArray(new String[0]);
            for (ServiceObserverPrx observer : observers) {
                observer.servicesStartedAsync(servicesArray).exceptionally(ex -> {
                    this.observerFailed(observer, (Throwable)ex);
                    return null;
                });
            }
        }
    }

    private void servicesStopped(List<String> services, Set<ServiceObserverPrx> observers) {
        if (services.size() > 0) {
            String[] servicesArray = services.toArray(new String[0]);
            for (ServiceObserverPrx observer : observers) {
                observer.servicesStoppedAsync(servicesArray).exceptionally(ex -> {
                    this.observerFailed(observer, (Throwable)ex);
                    return null;
                });
            }
        }
    }

    private synchronized void observerFailed(ServiceObserverPrx observer, Throwable ex) {
        if (ex instanceof LocalException && this._observers.remove(observer)) {
            this.observerRemoved(observer, (RuntimeException)((LocalException)ex));
        }
    }

    private void observerRemoved(ServiceObserverPrx observer, RuntimeException ex) {
        if (this._traceServiceObserver >= 1 && !(ex instanceof CommunicatorDestroyedException)) {
            this._logger.trace("IceBox.ServiceObserver", "Removed service observer " + this._communicator.proxyToString((ObjectPrx)observer) + "\nafter catching " + ex.toString());
        }
    }

    private Properties createServiceProperties(String service) {
        String programName;
        Properties properties;
        Properties communicatorProperties = this._communicator.getProperties();
        if (communicatorProperties.getPropertyAsInt("IceBox.InheritProperties") > 0) {
            properties = communicatorProperties._clone();
            for (String p : properties.getPropertiesForPrefix("Ice.Admin.").keySet()) {
                properties.setProperty(p, "");
            }
        } else {
            properties = Util.createProperties();
        }
        if ((programName = communicatorProperties.getProperty("Ice.ProgramName")).length() == 0) {
            properties.setProperty("Ice.ProgramName", service);
        } else {
            properties.setProperty("Ice.ProgramName", programName + "-" + service);
        }
        return properties;
    }

    private void destroyServiceCommunicator(String service, Communicator communicator) {
        try {
            communicator.shutdown();
            communicator.waitForShutdown();
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this._logger.warning("ServiceManager: exception in shutting down communicator for service " + service + "\n" + sw.toString());
        }
        this.removeAdminFacets("IceBox.Service." + service + ".");
        communicator.destroy();
    }

    private boolean configureAdmin(Properties properties, String prefix) {
        if (this._adminEnabled && properties.getProperty("Ice.Admin.Enabled").isEmpty()) {
            LinkedList<String> facetNames = new LinkedList<String>();
            for (String p : this._adminFacetFilter) {
                if (!p.startsWith(prefix)) continue;
                facetNames.add(p.substring(prefix.length()));
            }
            if (this._adminFacetFilter.isEmpty() || !facetNames.isEmpty()) {
                properties.setProperty("Ice.Admin.Enabled", "1");
                if (!facetNames.isEmpty()) {
                    properties.setProperty("Ice.Admin.Facets", StringUtil.joinString(facetNames, (String)" "));
                }
                return true;
            }
        }
        return false;
    }

    private void removeAdminFacets(String prefix) {
        try {
            for (String p : this._communicator.findAllAdminFacets().keySet()) {
                if (!p.startsWith(prefix)) continue;
                this._communicator.removeAdminFacet(p);
            }
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
        }
        catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
            // empty catch block
        }
    }

    static class StartServiceInfo {
        String name;
        String[] args;
        String className;
        String classDir;
        boolean absolutePath;

        StartServiceInfo(String service, String value, String[] serverArgs) {
            this.name = service;
            try {
                this.args = Options.split((String)value);
            }
            catch (Options.BadQuote ex) {
                throw new FailureException("ServiceManager: invalid arguments for service `" + this.name + "':\n" + ex.getMessage());
            }
            assert (this.args.length > 0);
            String entryPoint = this.args[0];
            boolean isWindows = System.getProperty("os.name").startsWith("Windows");
            this.absolutePath = false;
            int pos = entryPoint.indexOf(58);
            if (isWindows) {
                String driveLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                if (pos == 1 && entryPoint.length() > 2 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(entryPoint.charAt(0)) != -1 && (entryPoint.charAt(2) == '\\' || entryPoint.charAt(2) == '/')) {
                    this.absolutePath = true;
                    pos = entryPoint.indexOf(58, pos + 1);
                }
                if (!this.absolutePath) {
                    this.absolutePath = entryPoint.startsWith("\\\\");
                }
            } else {
                this.absolutePath = entryPoint.startsWith("/");
            }
            if (pos == -1 && this.absolutePath || pos != -1 && entryPoint.length() <= pos + 1) {
                throw new FailureException("ServiceManager: invalid entry point for service `" + this.name + "':\n" + entryPoint);
            }
            this.classDir = null;
            if (pos == -1) {
                this.className = entryPoint;
            } else {
                this.classDir = entryPoint.substring(0, pos).trim();
                this.className = entryPoint.substring(pos + 1).trim();
            }
            String[] tmp = new String[this.args.length - 1];
            System.arraycopy(this.args, 1, tmp, 0, this.args.length - 1);
            this.args = tmp;
            if (serverArgs.length > 0) {
                ArrayList<String> l = new ArrayList<String>(Arrays.asList(this.args));
                for (String arg : serverArgs) {
                    if (!arg.startsWith("--" + service + ".")) continue;
                    l.add(arg);
                }
                this.args = l.toArray(this.args);
            }
        }
    }

    static final class ServiceInfo
    implements Cloneable {
        public String name;
        public Service service;
        public Communicator communicator;
        public int status;
        public String[] args;

        ServiceInfo() {
        }

        public ServiceInfo clone() {
            ServiceInfo c = null;
            try {
                c = (ServiceInfo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return c;
        }
    }
}

