// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceBox;

/**
 * Administers a set of {@link Service} instances.
 *
 * @see Service
 *
 **/
public interface _ServiceManagerOperations
{
    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @param __current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(Ice.Current __current);

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @param __current The Current object for the invocation.
     **/
    void startService(String service, Ice.Current __current)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @param __current The Current object for the invocation.
     **/
    void stopService(String service, Ice.Current __current)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     * @param __current The Current object for the invocation.
     **/
    void addObserver(ServiceObserverPrx observer, Ice.Current __current);

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     *
     * @param __current The Current object for the invocation.
     **/
    void shutdown(Ice.Current __current);
}
