/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import Ice.ObjectAdapterI;
import Ice.OperationInterruptedException;
import Ice.SocketException;
import Ice.SyscallException;
import IceInternal.Acceptor;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Ex;
import IceInternal.FactoryACMMonitor;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.ThreadPoolCurrent;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class IncomingConnectionFactory
extends EventHandler
implements ConnectionI.StartCallback {
    private static final int StateActive = 0;
    private static final int StateHolding = 1;
    private static final int StateClosed = 2;
    private static final int StateFinished = 3;
    private final Instance _instance;
    private final FactoryACMMonitor _monitor;
    private Acceptor _acceptor;
    private Transceiver _transceiver;
    private EndpointI _endpoint;
    private ObjectAdapterI _adapter;
    private final boolean _warn;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();
    private int _state;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    public synchronized void updateConnectionObservers() {
        for (ConnectionI connection : this._connections) {
            connection.updateObserver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() throws InterruptedException {
        LinkedList<ConnectionI> connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                this.wait();
            }
            connections = new LinkedList<ConnectionI>(this._connections);
        }
        for (ConnectionI connection : connections) {
            connection.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() throws InterruptedException {
        LinkedList<ConnectionI> connections = null;
        Object object = this;
        synchronized (object) {
            while (this._state != 3) {
                this.wait();
            }
            this._adapter = null;
            connections = new LinkedList<ConnectionI>(this._connections);
        }
        if (connections != null) {
            for (ConnectionI connection : connections) {
                try {
                    connection.waitUntilFinished();
                }
                catch (InterruptedException e) {
                    for (ConnectionI c : connections) {
                        c.close(true);
                    }
                    throw e;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this._transceiver != null) {
                assert (this._connections.size() <= 1);
            } else {
                List<ConnectionI> cons = this._monitor.swapReapedConnections();
                assert ((cons == null ? 0 : cons.size()) == this._connections.size());
                if (cons != null) {
                    cons.clear();
                }
            }
            this._connections.clear();
            this._monitor.destroy();
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public synchronized LinkedList<ConnectionI> connections() {
        LinkedList<ConnectionI> connections = new LinkedList<ConnectionI>();
        for (ConnectionI connection : this._connections) {
            if (!connection.isActiveOrHolding()) continue;
            connections.add(connection);
        }
        return connections;
    }

    public void flushAsyncBatchRequests(CommunicatorFlushBatch outAsync) {
        for (ConnectionI c : this.connections()) {
            try {
                outAsync.flushConnection(c);
            }
            catch (LocalException localException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent current) {
        ConnectionI connection = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            if (this._state >= 2) {
                return;
            }
            if (this._state == 1) {
                Thread.yield();
                return;
            }
            List<ConnectionI> cons = this._monitor.swapReapedConnections();
            if (cons != null) {
                for (ConnectionI c : cons) {
                    this._connections.remove(c);
                }
            }
            Transceiver transceiver = null;
            try {
                transceiver = this._acceptor.accept();
                if (this._instance.traceLevels().network >= 2) {
                    StringBuffer s = new StringBuffer("trying to accept ");
                    s.append(this._endpoint.protocol());
                    s.append(" connection\n");
                    s.append(transceiver.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                }
            }
            catch (SocketException ex) {
                if (Network.noMoreFds(ex.getCause())) {
                    try {
                        String s = "fatal error: can't accept more connections:\n" + ex.getCause().getMessage();
                        s = s + '\n' + this._acceptor.toString();
                        this._instance.initializationData().logger.error(s);
                    }
                    finally {
                        Runtime.getRuntime().halt(1);
                    }
                }
                return;
            }
            catch (LocalException ex) {
                if (this._warn) {
                    this.warning(ex);
                }
                return;
            }
            assert (transceiver != null);
            try {
                connection = new ConnectionI(this._adapter.getCommunicator(), this._instance, this._monitor, transceiver, null, this._endpoint, this._adapter);
            }
            catch (LocalException ex) {
                try {
                    transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
                if (this._warn) {
                    this.warning(ex);
                }
                return;
            }
            this._connections.add(connection);
        }
        assert (connection != null);
        connection.start(this);
    }

    @Override
    public synchronized void finished(ThreadPoolCurrent current, boolean close) {
        assert (this._state == 2);
        this.setState(3);
        if (close) {
            this.closeAcceptor();
        }
    }

    @Override
    public synchronized String toString() {
        if (this._transceiver != null) {
            return this._transceiver.toString();
        }
        return this._acceptor.toString();
    }

    @Override
    public SelectableChannel fd() {
        assert (this._acceptor != null);
        return this._acceptor.fd();
    }

    @Override
    public synchronized void connectionStartCompleted(ConnectionI connection) {
        if (this._state == 0) {
            connection.activate();
        }
    }

    @Override
    public synchronized void connectionStartFailed(ConnectionI connection, LocalException ex) {
        if (this._state >= 2) {
            return;
        }
    }

    public IncomingConnectionFactory(Instance instance, EndpointI endpoint, ObjectAdapterI adapter) {
        this._instance = instance;
        this._endpoint = endpoint;
        this._adapter = adapter;
        this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._state = 1;
        this._monitor = new FactoryACMMonitor(instance, adapter.getACM());
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        if (defaultsAndOverrides.overrideTimeout) {
            this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
        }
        if (defaultsAndOverrides.overrideCompress) {
            this._endpoint = this._endpoint.compress(defaultsAndOverrides.overrideCompressValue);
        }
        try {
            this._transceiver = this._endpoint.transceiver();
            if (this._transceiver != null) {
                if (this._instance.traceLevels().network >= 2) {
                    StringBuffer s = new StringBuffer("attempting to bind to ");
                    s.append(this._endpoint.protocol());
                    s.append(" socket\n");
                    s.append(this._transceiver.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                }
                this._endpoint = this._transceiver.bind();
                ConnectionI connection = new ConnectionI(this._adapter.getCommunicator(), this._instance, null, this._transceiver, null, this._endpoint, this._adapter);
                connection.startAndWait();
                this._connections.add(connection);
            } else {
                this.createAcceptor();
            }
        }
        catch (Exception ex) {
            if (this._transceiver != null) {
                try {
                    this._transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
            }
            this._state = 3;
            this._monitor.destroy();
            this._connections.clear();
            if (ex instanceof LocalException) {
                throw (LocalException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw new OperationInterruptedException();
            }
            throw new SyscallException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._state == 3);
            Assert.FinalizerAssert(this._connections.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private void setState(int state) {
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer s = new StringBuffer("accepting ");
                        s.append(this._endpoint.protocol());
                        s.append(" connections at ");
                        s.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                    }
                    this._adapter.getThreadPool().register(this, 1);
                }
                for (ConnectionI connection : this._connections) {
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer s = new StringBuffer("holding ");
                        s.append(this._endpoint.protocol());
                        s.append(" connections at ");
                        s.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                    }
                    this._adapter.getThreadPool().unregister(this, 1);
                }
                for (ConnectionI connection : this._connections) {
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    if (this._adapter.getThreadPool().finish(this, true)) {
                        this.closeAcceptor();
                    }
                } else {
                    state = 3;
                }
                for (ConnectionI connection : this._connections) {
                    connection.destroy(0);
                }
                break;
            }
            case 3: {
                assert (this._state == 2);
                break;
            }
        }
        this._state = state;
        this.notifyAll();
    }

    private void createAcceptor() {
        try {
            StringBuffer s;
            this._acceptor = this._endpoint.acceptor(this._adapter.getName());
            assert (this._acceptor != null);
            if (this._instance.traceLevels().network >= 2) {
                s = new StringBuffer("attempting to bind to ");
                s.append(this._endpoint.protocol());
                s.append(" socket ");
                s.append(this._acceptor.toString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
            }
            this._endpoint = this._acceptor.listen();
            if (this._instance.traceLevels().network >= 1) {
                s = new StringBuffer("listening for ");
                s.append(this._endpoint.protocol());
                s.append(" connections\n");
                s.append(this._acceptor.toDetailedString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
            }
            this._adapter.getThreadPool().initialize(this);
            if (this._state == 0) {
                this._adapter.getThreadPool().register(this, 1);
            }
        }
        catch (Exception ex) {
            if (this._acceptor != null) {
                this._acceptor.close();
            }
            throw ex;
        }
    }

    private void closeAcceptor() {
        if (this._instance.traceLevels().network >= 1) {
            StringBuffer s = new StringBuffer("stopping to accept ");
            s.append(this._endpoint.protocol());
            s.append(" connections at ");
            s.append(this._acceptor.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        this._acceptor.close();
    }

    private void warning(LocalException ex) {
        String s = "connection exception:\n" + Ex.toString(ex) + '\n' + this._acceptor.toString();
        this._instance.initializationData().logger.warning(s);
    }
}

