/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Connection;
import Ice.Exception;
import Ice.Instrumentation.InvocationObserver;
import Ice.InvocationCanceledException;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import IceInternal.CallbackBase;
import IceInternal.CancellationHandler;
import IceInternal.DispatchWorkItem;
import IceInternal.Ex;
import IceInternal.Instance;
import IceInternal.OutgoingAsyncBase;

public class AsyncResultI
implements AsyncResult {
    protected final Instance _instance;
    protected InvocationObserver _observer;
    protected Connection _cachedConnection;
    protected boolean _sentSynchronously;
    private final Communicator _communicator;
    private final String _operation;
    private final CallbackBase _callback;
    private Exception _exception;
    private CancellationHandler _cancellationHandler;
    private LocalException _cancellationException;
    protected static final byte StateOK = 1;
    protected static final byte StateDone = 2;
    protected static final byte StateSent = 4;
    protected static final byte StateEndCalled = 8;
    protected static final byte StateCachedBuffers = 16;
    protected byte _state;

    @Override
    public void cancel() {
        this.cancel(new InvocationCanceledException());
    }

    @Override
    public Communicator getCommunicator() {
        return this._communicator;
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public ObjectPrx getProxy() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isCompleted() {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            return (this._state & 2) > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitForCompleted() {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            if (Thread.interrupted()) {
                throw new OperationInterruptedException();
            }
            while ((this._state & 2) == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSent() {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            return (this._state & 4) > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitForSent() {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            if (Thread.interrupted()) {
                throw new OperationInterruptedException();
            }
            while ((this._state & 4) == 0 && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void throwLocalException() {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            if (this._exception != null) {
                throw this._exception;
            }
        }
    }

    @Override
    public final boolean sentSynchronously() {
        return this._sentSynchronously;
    }

    @Override
    public final String getOperation() {
        return this._operation;
    }

    public final void invokeSent() {
        ObjectPrx proxy;
        assert (this._callback != null);
        if (this._instance.useApplicationClassLoader()) {
            Thread.currentThread().setContextClassLoader(this._callback.getClass().getClassLoader());
        }
        try {
            this._callback.__sent(this);
        }
        catch (RuntimeException ex) {
            this.warning(ex);
        }
        catch (Error exc) {
            this.error(exc);
            if (!(exc instanceof AssertionError) && !(exc instanceof OutOfMemoryError)) {
                throw exc;
            }
        }
        finally {
            if (this._instance.useApplicationClassLoader()) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
        if (!(this._observer == null || (proxy = this.getProxy()) != null && proxy.ice_isTwoway())) {
            this._observer.detach();
            this._observer = null;
        }
    }

    public final void invokeCompleted() {
        assert (this._callback != null);
        if (this._instance.useApplicationClassLoader()) {
            Thread.currentThread().setContextClassLoader(this._callback.getClass().getClassLoader());
        }
        try {
            this._callback.__completed(this);
        }
        catch (RuntimeException ex) {
            this.warning(ex);
        }
        catch (AssertionError exc) {
            this.error((Error)((Object)exc));
        }
        catch (OutOfMemoryError exc) {
            this.error(exc);
        }
        finally {
            if (this._instance.useApplicationClassLoader()) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
    }

    public final void invokeCompletedAsync() {
        this._instance.clientThreadPool().dispatch(new DispatchWorkItem(this._cachedConnection){

            @Override
            public void run() {
                AsyncResultI.this.invokeCompleted();
            }
        });
    }

    public synchronized void cancelable(CancellationHandler handler) {
        if (this._cancellationException != null) {
            try {
                throw this._cancellationException;
            }
            catch (Throwable throwable) {
                this._cancellationException = null;
                throw throwable;
            }
        }
        this._cancellationHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean __wait() {
        try {
            AsyncResultI asyncResultI = this;
            synchronized (asyncResultI) {
                if ((this._state & 8) > 0) {
                    throw new IllegalArgumentException("end_ method called more than once");
                }
                this._state = (byte)(this._state | 8);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                while ((this._state & 2) == 0) {
                    this.wait();
                }
                if (this._exception != null) {
                    throw (Exception)this._exception.fillInStackTrace();
                }
                return (this._state & 1) > 0;
            }
        }
        catch (InterruptedException ex) {
            OperationInterruptedException exc = new OperationInterruptedException();
            this.cancel(exc);
            throw exc;
        }
    }

    public void cacheMessageBuffers() {
    }

    protected AsyncResultI(Communicator communicator, Instance instance, String op, CallbackBase del) {
        this._communicator = communicator;
        this._instance = instance;
        this._operation = op;
        this._state = 0;
        this._sentSynchronously = false;
        this._exception = null;
        this._callback = del;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sent(boolean done) {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            assert (this._exception == null);
            boolean alreadySent = (this._state & 4) != 0;
            this._state = (byte)(this._state | 4);
            if (done) {
                this._state = (byte)(this._state | 3);
                this._cancellationHandler = null;
                if (!(this._observer == null || this._callback != null && this._callback.__hasSentCallback())) {
                    this._observer.detach();
                    this._observer = null;
                }
                this.cacheMessageBuffers();
            }
            this.notifyAll();
            return !alreadySent && this._callback != null && this._callback.__hasSentCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finished(boolean ok) {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            this._state = (byte)(this._state | 2);
            if (ok) {
                this._state = (byte)(this._state | 1);
            }
            this._cancellationHandler = null;
            if (this._callback == null && this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this.notifyAll();
            return this._callback != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finished(Exception ex) {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            this._state = (byte)(this._state | 2);
            this._exception = ex;
            this._cancellationHandler = null;
            if (this._observer != null) {
                this._observer.failed(ex.ice_name());
            }
            if (this._callback == null && this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this.notifyAll();
            return this._callback != null;
        }
    }

    protected final void invokeSentAsync() {
        try {
            this._instance.clientThreadPool().dispatch(new DispatchWorkItem(this._cachedConnection){

                @Override
                public void run() {
                    AsyncResultI.this.invokeSent();
                }
            });
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(LocalException ex) {
        CancellationHandler handler;
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            this._cancellationException = ex;
            if (this._cancellationHandler == null) {
                return;
            }
            handler = this._cancellationHandler;
        }
        handler.asyncRequestCanceled((OutgoingAsyncBase)this, ex);
    }

    protected InvocationObserver getObserver() {
        return this._observer;
    }

    protected static void check(AsyncResult r, String operation) {
        if (r == null) {
            throw new IllegalArgumentException("AsyncResult == null");
        }
        if (r.getOperation() != operation) {
            throw new IllegalArgumentException("Incorrect operation for end_" + operation + " method: " + r.getOperation());
        }
    }

    private void warning(RuntimeException ex) {
        if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.AMICallback", 1) > 0) {
            String s = "exception raised by AMI callback:\n" + Ex.toString(ex);
            this._instance.initializationData().logger.warning(s);
        }
    }

    private void error(Error error) {
        String s = "error raised by AMI callback:\n" + Ex.toString(error);
        this._instance.initializationData().logger.error(s);
    }
}

