/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.EncodingVersion;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.InitializationData;
import Ice.InputStream;
import Ice.InputStreamI;
import Ice.Logger;
import Ice.LoggerI;
import Ice.ObjectPrx;
import Ice.OutputStream;
import Ice.OutputStreamI;
import Ice.Properties;
import Ice.PropertiesI;
import Ice.ProtocolVersion;
import Ice.StringSeqHolder;
import Ice.VersionParseException;
import IceInternal.Protocol;
import IceUtilInternal.StringUtil;

public final class Util {
    public static final ProtocolVersion Protocol_1_0 = new ProtocolVersion(1, 0);
    public static final EncodingVersion Encoding_1_0 = new EncodingVersion(1, 0);
    public static final EncodingVersion Encoding_1_1 = new EncodingVersion(1, 1);
    private static Object _processLoggerMutex = new Object();
    private static Logger _processLogger = null;

    public static Properties createProperties() {
        return new PropertiesI();
    }

    public static Properties createProperties(StringSeqHolder args) {
        return new PropertiesI(args, null);
    }

    public static Properties createProperties(StringSeqHolder args, Properties defaults) {
        return new PropertiesI(args, defaults);
    }

    public static Properties createProperties(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.createProperties(argsH);
    }

    public static Properties createProperties(String[] args, Properties defaults) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.createProperties(argsH, defaults);
    }

    public static Communicator initialize(StringSeqHolder args) {
        return Util.initialize(args, null);
    }

    public static Communicator initialize(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initialize(argsH);
    }

    public static Communicator initialize(StringSeqHolder args, InitializationData initData) {
        initData = initData == null ? new InitializationData() : initData.clone();
        initData.properties = Util.createProperties(args, initData.properties);
        CommunicatorI result = new CommunicatorI(initData);
        result.finishSetup(args);
        return result;
    }

    public static Communicator initialize(String[] args, InitializationData initData) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initialize(argsH, initData);
    }

    public static Communicator initialize(InitializationData initData) {
        initData = initData == null ? new InitializationData() : initData.clone();
        CommunicatorI result = new CommunicatorI(initData);
        result.finishSetup(new StringSeqHolder(new String[0]));
        return result;
    }

    public static Communicator initialize() {
        return Util.initialize(new InitializationData());
    }

    public static Identity stringToIdentity(String s) {
        Identity ident = new Identity();
        int slash = -1;
        int pos = 0;
        while ((pos = s.indexOf(47, pos)) != -1) {
            int escapes = 0;
            while (pos - escapes > 0 && s.charAt(pos - escapes - 1) == '\\') {
                ++escapes;
            }
            if (escapes % 2 == 0) {
                if (slash == -1) {
                    slash = pos;
                } else {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = "unescaped backslash in identity `" + s + "'";
                    throw ex;
                }
            }
            ++pos;
        }
        if (slash == -1) {
            ident.category = "";
            try {
                ident.name = StringUtil.unescapeString(s, 0, s.length());
            }
            catch (IllegalArgumentException e) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = "invalid identity name `" + s + "': " + e.getMessage();
                throw ex;
            }
        }
        try {
            ident.category = StringUtil.unescapeString(s, 0, slash);
        }
        catch (IllegalArgumentException e) {
            IdentityParseException ex = new IdentityParseException();
            ex.str = "invalid category in identity `" + s + "': " + e.getMessage();
            throw ex;
        }
        if (slash + 1 < s.length()) {
            try {
                ident.name = StringUtil.unescapeString(s, slash + 1, s.length());
            }
            catch (IllegalArgumentException e) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = "invalid name in identity `" + s + "': " + e.getMessage();
                throw ex;
            }
        } else {
            ident.name = "";
        }
        return ident;
    }

    public static String identityToString(Identity ident) {
        if (ident.category == null || ident.category.length() == 0) {
            return StringUtil.escapeString(ident.name, "/");
        }
        return StringUtil.escapeString(ident.category, "/") + '/' + StringUtil.escapeString(ident.name, "/");
    }

    public static int proxyIdentityCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        return lhsIdentity.category.compareTo(rhsIdentity.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        n = lhsIdentity.category.compareTo(rhsIdentity.category);
        if (n != 0) {
            return n;
        }
        String lhsFacet = lhs.ice_getFacet();
        String rhsFacet = rhs.ice_getFacet();
        if (lhsFacet == null && rhsFacet == null) {
            return 0;
        }
        if (lhsFacet == null) {
            return -1;
        }
        if (rhsFacet == null) {
            return 1;
        }
        return lhsFacet.compareTo(rhsFacet);
    }

    public static InputStream createInputStream(Communicator communicator, byte[] bytes) {
        return new InputStreamI(communicator, bytes, true);
    }

    public static InputStream createInputStream(Communicator communicator, byte[] bytes, EncodingVersion v) {
        return new InputStreamI(communicator, bytes, v, true);
    }

    public static InputStream wrapInputStream(Communicator communicator, byte[] bytes) {
        return new InputStreamI(communicator, bytes, false);
    }

    public static InputStream wrapInputStream(Communicator communicator, byte[] bytes, EncodingVersion v) {
        return new InputStreamI(communicator, bytes, v, false);
    }

    public static OutputStream createOutputStream(Communicator communicator) {
        return new OutputStreamI(communicator);
    }

    public static OutputStream createOutputStream(Communicator communicator, EncodingVersion v) {
        return new OutputStreamI(communicator, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getProcessLogger() {
        Object object = _processLoggerMutex;
        synchronized (object) {
            if (_processLogger == null) {
                _processLogger = new LoggerI("", "");
            }
            return _processLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessLogger(Logger logger) {
        Object object = _processLoggerMutex;
        synchronized (object) {
            _processLogger = logger;
        }
    }

    public static String stringVersion() {
        return "3.6.3";
    }

    public static int intVersion() {
        return 30603;
    }

    public static ProtocolVersion stringToProtocolVersion(String version) {
        return new ProtocolVersion(Util.stringToMajor(version), Util.stringToMinor(version));
    }

    public static EncodingVersion stringToEncodingVersion(String version) {
        return new EncodingVersion(Util.stringToMajor(version), Util.stringToMinor(version));
    }

    public static String protocolVersionToString(ProtocolVersion v) {
        return Util.majorMinorToString(v.major, v.minor);
    }

    public static String encodingVersionToString(EncodingVersion v) {
        return Util.majorMinorToString(v.major, v.minor);
    }

    public static ProtocolVersion currentProtocol() {
        return Protocol.currentProtocol.clone();
    }

    public static EncodingVersion currentEncoding() {
        return Protocol.currentEncoding.clone();
    }

    private static byte stringToMajor(String str) {
        int majVersion;
        int pos = str.indexOf(46);
        if (pos == -1) {
            throw new VersionParseException("malformed version value `" + str + "'");
        }
        String majStr = str.substring(0, pos);
        try {
            majVersion = Integer.parseInt(majStr);
        }
        catch (NumberFormatException ex) {
            throw new VersionParseException("invalid version value `" + str + "'");
        }
        if (majVersion < 1 || majVersion > 255) {
            throw new VersionParseException("range error in version `" + str + "'");
        }
        return (byte)majVersion;
    }

    private static byte stringToMinor(String str) {
        int minVersion;
        int pos = str.indexOf(46);
        if (pos == -1) {
            throw new VersionParseException("malformed version value `" + str + "'");
        }
        String minStr = str.substring(pos + 1, str.length());
        try {
            minVersion = Integer.parseInt(minStr);
        }
        catch (NumberFormatException ex) {
            throw new VersionParseException("invalid version value `" + str + "'");
        }
        if (minVersion < 0 || minVersion > 255) {
            throw new VersionParseException("range error in version `" + str + "'");
        }
        return (byte)minVersion;
    }

    private static String majorMinorToString(byte major, byte minor) {
        StringBuilder str = new StringBuilder();
        str.append(major < 0 ? major + 255 : major);
        str.append(".");
        str.append(minor < 0 ? minor + 255 : minor);
        return str.toString();
    }
}

