// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 *
 **/
public abstract class _MetricsAdminDisp extends Ice.ObjectImpl implements MetricsAdmin
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceMX::MetricsAdmin"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[1];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String ice_staticId()
    {
        return __ids[1];
    }

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public final void disableMetricsView(String name)
        throws UnknownMetricsView
    {
        disableMetricsView(name, null);
    }

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public final void enableMetricsView(String name)
        throws UnknownMetricsView
    {
        enableMetricsView(name, null);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @return The metrics failures associated with the map.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public final MetricsFailures[] getMapMetricsFailures(String view, String map)
        throws UnknownMetricsView
    {
        return getMapMetricsFailures(view, map, null);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @return The metrics failures associated with the metrics.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public final MetricsFailures getMetricsFailures(String view, String map, String id)
        throws UnknownMetricsView
    {
        return getMetricsFailures(view, map, id, null);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     *
     * @return The metrics view data.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public final java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp)
        throws UnknownMetricsView
    {
        return getMetricsView(view, timestamp, null);
    }

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param disabledViews The names of the disabled views.
     *
     * @return The name of the enabled views.
     *
     **/
    public final String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews)
    {
        return getMetricsViewNames(disabledViews, null);
    }

    public static Ice.DispatchStatus ___getMetricsViewNames(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        Ice.StringSeqHolder disabledViews = new Ice.StringSeqHolder();
        String[] __ret = __obj.getMetricsViewNames(disabledViews, __current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.SlicedFormat);
        Ice.StringSeqHelper.write(__os, disabledViews.value);
        Ice.StringSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___enableMetricsView(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.enableMetricsView(name, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(UnknownMetricsView ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___disableMetricsView(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String name;
        name = __is.readString();
        __inS.endReadParams();
        try
        {
            __obj.disableMetricsView(name, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(UnknownMetricsView ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getMetricsView(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String view;
        view = __is.readString();
        __inS.endReadParams();
        Ice.LongHolder timestamp = new Ice.LongHolder();
        try
        {
            java.util.Map<java.lang.String, Metrics[]> __ret = __obj.getMetricsView(view, timestamp, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeLong(timestamp.value);
            MetricsViewHelper.write(__os, __ret);
            __os.writePendingObjects();
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(UnknownMetricsView ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getMapMetricsFailures(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String view;
        String map;
        view = __is.readString();
        map = __is.readString();
        __inS.endReadParams();
        try
        {
            MetricsFailures[] __ret = __obj.getMapMetricsFailures(view, map, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.SlicedFormat);
            MetricsFailuresSeqHelper.write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(UnknownMetricsView ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___getMetricsFailures(MetricsAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        String view;
        String map;
        String id;
        view = __is.readString();
        map = __is.readString();
        id = __is.readString();
        __inS.endReadParams();
        try
        {
            MetricsFailures __ret = __obj.getMetricsFailures(view, map, id, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.SlicedFormat);
            MetricsFailures.__write(__os, __ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(UnknownMetricsView ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    private final static String[] __all =
    {
        "disableMetricsView",
        "enableMetricsView",
        "getMapMetricsFailures",
        "getMetricsFailures",
        "getMetricsView",
        "getMetricsViewNames",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___disableMetricsView(this, in, __current);
            }
            case 1:
            {
                return ___enableMetricsView(this, in, __current);
            }
            case 2:
            {
                return ___getMapMetricsFailures(this, in, __current);
            }
            case 3:
            {
                return ___getMetricsFailures(this, in, __current);
            }
            case 4:
            {
                return ___getMetricsView(this, in, __current);
            }
            case 5:
            {
                return ___getMetricsViewNames(this, in, __current);
            }
            case 6:
            {
                return ___ice_id(this, in, __current);
            }
            case 7:
            {
                return ___ice_ids(this, in, __current);
            }
            case 8:
            {
                return ___ice_isA(this, in, __current);
            }
            case 9:
            {
                return ___ice_ping(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
