// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * Provide measurements for proxy invocations. Proxy invocations can
 * either be sent over the wire or be collocated.
 *
 **/
public class InvocationMetrics extends Metrics
{
    public InvocationMetrics()
    {
        super();
        retry = 0;
        userException = 0;
    }

    public InvocationMetrics(String id, long total, int current, long totalLifetime, int failures, int retry, int userException, Metrics[] remotes, Metrics[] collocated)
    {
        super(id, total, current, totalLifetime, failures);
        this.retry = retry;
        this.userException = userException;
        this.remotes = remotes;
        this.collocated = collocated;
    }

    private static class __F implements Ice.ObjectFactory
    {
        public Ice.Object create(String type)
        {
            assert(type.equals(ice_staticId()));
            return new InvocationMetrics();
        }

        public void destroy()
        {
        }
    }
    private static Ice.ObjectFactory _factory = new __F();

    public static Ice.ObjectFactory
    ice_factory()
    {
        return _factory;
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceMX::InvocationMetrics",
        "::IceMX::Metrics"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[1];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[1];
    }

    public static String ice_staticId()
    {
        return __ids[1];
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, false);
        __os.writeInt(retry);
        __os.writeInt(userException);
        MetricsMapHelper.write(__os, remotes);
        MetricsMapHelper.write(__os, collocated);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        retry = __is.readInt();
        userException = __is.readInt();
        remotes = MetricsMapHelper.read(__is);
        collocated = MetricsMapHelper.read(__is);
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    /**
     * The number of retries for the invocation(s).
     *
     **/
    public int retry;

    /**
     * The number of invocations that failed with a user exception.
     *
     **/
    public int userException;

    /**
     * The remote invocation metrics map.
     *
     * @see RemoteMetrics
     *
     **/
    public Metrics[] remotes;

    /**
     * The collocated invocation metrics map.
     *
     * @see CollocatedMetrics
     *
     **/
    public Metrics[] collocated;

    public InvocationMetrics
    clone()
    {
        return (InvocationMetrics)super.clone();
    }

    public static final long serialVersionUID = 662383306999101500L;
}
