// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 *
 **/
public abstract class _LoggerAdminDisp extends Ice.ObjectImpl implements LoggerAdmin
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Ice::LoggerAdmin",
        "::Ice::Object"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[0];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[0];
    }

    public static String ice_staticId()
    {
        return __ids[0];
    }

    /**
     * attachRemoteLogger is called to attach a {@link RemoteLogger} object to
     * the local {@link Logger}.
     * attachRemoteLogger calls init on the provided {@link RemoteLogger} proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to {@link RemoteLogger#init}. A negative value requests all messages available.
     *
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     *
     **/
    public final void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax)
        throws RemoteLoggerAlreadyAttachedException
    {
        attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, null);
    }

    /**
     * detachRemoteLogger is called to detach a {@link RemoteLogger} object from
     * the local {@link Logger}.
     *
     * @param prx A proxy to the remote logger.
     *
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     *
     **/
    public final boolean detachRemoteLogger(RemoteLoggerPrx prx)
    {
        return detachRemoteLogger(prx, null);
    }

    /**
     * getLog retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param prefix The prefix of the associated local {@link Logger}.
     *
     * @return The Log messages.
     *
     **/
    public final LogMessage[] getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Ice.StringHolder prefix)
    {
        return getLog(messageTypes, traceCategories, messageMax, prefix, null);
    }

    public static Ice.DispatchStatus ___attachRemoteLogger(LoggerAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        RemoteLoggerPrx prx;
        LogMessageType[] messageTypes;
        String[] traceCategories;
        int messageMax;
        prx = RemoteLoggerPrxHelper.__read(__is);
        messageTypes = LogMessageTypeSeqHelper.read(__is);
        traceCategories = StringSeqHelper.read(__is);
        messageMax = __is.readInt();
        __inS.endReadParams();
        try
        {
            __obj.attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, __current);
            __inS.__writeEmptyParams();
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(RemoteLoggerAlreadyAttachedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.DefaultFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    public static Ice.DispatchStatus ___detachRemoteLogger(LoggerAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        RemoteLoggerPrx prx;
        prx = RemoteLoggerPrxHelper.__read(__is);
        __inS.endReadParams();
        boolean __ret = __obj.detachRemoteLogger(prx, __current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        __os.writeBool(__ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    public static Ice.DispatchStatus ___getLog(LoggerAdmin __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Normal, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        LogMessageType[] messageTypes;
        String[] traceCategories;
        int messageMax;
        messageTypes = LogMessageTypeSeqHelper.read(__is);
        traceCategories = StringSeqHelper.read(__is);
        messageMax = __is.readInt();
        __inS.endReadParams();
        Ice.StringHolder prefix = new Ice.StringHolder();
        LogMessage[] __ret = __obj.getLog(messageTypes, traceCategories, messageMax, prefix, __current);
        IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.DefaultFormat);
        __os.writeString(prefix.value);
        LogMessageSeqHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return Ice.DispatchStatus.DispatchOK;
    }

    private final static String[] __all =
    {
        "attachRemoteLogger",
        "detachRemoteLogger",
        "getLog",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___attachRemoteLogger(this, in, __current);
            }
            case 1:
            {
                return ___detachRemoteLogger(this, in, __current);
            }
            case 2:
            {
                return ___getLog(this, in, __current);
            }
            case 3:
            {
                return ___ice_id(this, in, __current);
            }
            case 4:
            {
                return ___ice_ids(this, in, __current);
            }
            case 5:
            {
                return ___ice_isA(this, in, __current);
            }
            case 6:
            {
                return ___ice_ping(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
