// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `Connection.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The user-level interface to a connection.
 *
 **/
public interface Connection
{
    /**
     * Close a connection, either gracefully or forcefully. If a
     * connection is closed forcefully, it closes immediately, without
     * sending the relevant close connection protocol messages to the
     * peer and waiting for the peer to acknowledge these protocol
     * messages.
     *
     * @param force If true, close forcefully. Otherwise the
     * connection is closed gracefully.
     *
     **/
    void close(boolean force);

    /**
     * Create a special proxy that always uses this connection. This
     * can be used for callbacks from a server to a client if the
     * server cannot directly establish a connection to the client,
     * for example because of firewalls. In this case, the server
     * would create a proxy using an already established connection
     * from the client.
     *
     * @param id The identity for which a proxy is to be created.
     *
     * @return A proxy that matches the given identity and uses this
     * connection.
     *
     * @see #setAdapter
     **/
    Ice.ObjectPrx createProxy(Identity id);

    /**
     * Explicitly set an object adapter that dispatches requests that
     * are received over this connection. A client can invoke an
     * operation on a server using a proxy, and then set an object
     * adapter for the outgoing connection that is used by the proxy
     * in order to receive callbacks. This is useful if the server
     * cannot establish a connection back to the client, for example
     * because of firewalls.
     *
     * @param adapter The object adapter that should be used by this
     * connection to dispatch requests. The object adapter must be
     * activated. When the object adapter is deactivated, it is
     * automatically removed from the connection.
     *
     * @see #createProxy
     * @see #setAdapter
     *
     **/
    void setAdapter(ObjectAdapter adapter);

    /**
     * Get the object adapter that dispatches requests for this
     * connection.
     *
     * @return The object adapter that dispatches requests for the
     * connection, or null if no adapter is set.
     *
     * @see #setAdapter
     *
     **/
    ObjectAdapter getAdapter();

    /**
     * Get the endpoint from which the connection was created.
     *
     * @return The endpoint from which the connection was created.
     *
     **/
    Endpoint getEndpoint();

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     *
     **/
    void flushBatchRequests();

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * 
     * @return The asynchronous result object.
     **/
    Ice.AsyncResult begin_flushBatchRequests();

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * 
     * @return The asynchronous result object.
     **/
    Ice.AsyncResult begin_flushBatchRequests(Ice.Callback __cb);

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * 
     * @return The asynchronous result object.
     **/
    Ice.AsyncResult begin_flushBatchRequests(Callback_Connection_flushBatchRequests __cb);

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * 
     * @return The asynchronous result object.
     **/
    
    Ice.AsyncResult begin_flushBatchRequests(IceInternal.Functional_VoidCallback __responseCb, 
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                             IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * 
     * @param __result The asynchronous result object.
     **/
    void end_flushBatchRequests(Ice.AsyncResult __result);

    /**
     * Set callback on the connection. The callback is called by the
     * connection when it's closed. The callback is called from the
     * Ice thread pool associated with the connection.
     *
     * @param callback The connection callback object.
     *
     **/
    void setCallback(ConnectionCallback callback);

    /**
     * Set the active connection management parameters.
     *
     * @param timeout The timeout value in milliseconds.
     *
     * @param close The close condition
     *
     * @param heartbeat The hertbeat condition
     *
     **/
    void setACM(Ice.IntOptional timeout, Ice.Optional<ACMClose> close, Ice.Optional<ACMHeartbeat> heartbeat);

    /**
     * Get the ACM parameters.
     *
     * @return The ACM parameters.
     *
     **/
    ACM getACM();

    /**
     * Return the connection type. This corresponds to the endpoint
     * type, i.e., "tcp", "udp", etc.
     *
     * @return The type of the connection.
     *
     **/
    String type();

    /**
     * Get the timeout for the connection.
     *
     * @return The connection's timeout.
     *
     **/
    int timeout();

    /**
     * Return a description of the connection as human readable text,
     * suitable for logging or error messages.
     *
     * @return The description of the connection as human readable
     * text.
     *
     **/
    String _toString();

    /**
     * Returns the connection information.
     *
     * @return The connection information.
     *
     **/
    ConnectionInfo getInfo();

    /**
     * Set the connectiion buffer receive/send size.
     *
     * @param rcvSize The connection receive buffer size.
     * @param sndSize The connection send buffer size.
     *
     **/
    void setBufferSize(int rcvSize, int sndSize);

    public static final long serialVersionUID = -6202783565406375804L;
}
