/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.EndpointParseException;
import Ice.IPEndpointInfo;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.NetworkProxy;
import IceInternal.Transceiver;
import IceInternal.WSEndpointDelegate;
import IceSSL.AcceptorI;
import IceSSL.ConnectorI;
import IceSSL.EndpointInfo;
import IceSSL.Instance;
import IceSSL.WSSEndpointInfo;
import java.net.InetSocketAddress;

final class EndpointI
extends IPEndpointI
implements WSEndpointDelegate {
    private Instance _instance;
    private int _timeout;
    private boolean _compress;

    public EndpointI(Instance instance, String ho, int po, InetSocketAddress sourceAddr, int ti, String conId, boolean co) {
        super(instance, ho, po, sourceAddr, conId);
        this._instance = instance;
        this._timeout = ti;
        this._compress = co;
    }

    public EndpointI(Instance instance) {
        super(instance);
        this._instance = instance;
        this._timeout = instance.defaultTimeout();
        this._compress = false;
    }

    public EndpointI(Instance instance, BasicStream s) {
        super(instance, s);
        this._instance = instance;
        this._timeout = s.readInt();
        this._compress = s.readBool();
    }

    @Override
    public Ice.EndpointInfo getInfo() {
        EndpointInfo info = new EndpointInfo(){

            @Override
            public short type() {
                return EndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return EndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return EndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(info);
        return info;
    }

    @Override
    public Ice.EndpointInfo getWSInfo(String resource) {
        WSSEndpointInfo info = new WSSEndpointInfo(){

            @Override
            public short type() {
                return EndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return EndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return EndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(info);
        info.resource = resource;
        return info;
    }

    @Override
    public int timeout() {
        return this._timeout;
    }

    @Override
    public IceInternal.EndpointI timeout(int timeout) {
        if (timeout == this._timeout) {
            return this;
        }
        return new EndpointI(this._instance, this._host, this._port, this._sourceAddr, timeout, this._connectionId, this._compress);
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public IceInternal.EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new EndpointI(this._instance, this._host, this._port, this._sourceAddr, this._timeout, this._connectionId, compress);
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public Acceptor acceptor(String adapterName) {
        return new AcceptorI(this, this._instance, adapterName, this._host, this._port);
    }

    public EndpointI endpoint(AcceptorI acceptor) {
        return new EndpointI(this._instance, this._host, acceptor.effectivePort(), this._sourceAddr, this._timeout, this._connectionId, this._compress);
    }

    @Override
    public String options() {
        String s = super.options();
        s = this._timeout == -1 ? s + " -t infinite" : s + " -t " + this._timeout;
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    @Override
    public int compareTo(IceInternal.EndpointI obj) {
        if (!(obj instanceof EndpointI)) {
            return this.type() < obj.type() ? -1 : 1;
        }
        EndpointI p = (EndpointI)obj;
        if (this == p) {
            return 0;
        }
        if (this._timeout < p._timeout) {
            return -1;
        }
        if (p._timeout < this._timeout) {
            return 1;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        return super.compareTo(obj);
    }

    @Override
    public void streamWriteImpl(BasicStream s) {
        super.streamWriteImpl(s);
        s.writeInt(this._timeout);
        s.writeBool(this._compress);
    }

    @Override
    public int hashInit(int h) {
        h = super.hashInit(h);
        h = HashUtil.hashAdd(h, this._timeout);
        h = HashUtil.hashAdd(h, this._compress);
        return h;
    }

    @Override
    public void fillEndpointInfo(IPEndpointInfo info) {
        super.fillEndpointInfo(info);
        info.timeout = this._timeout;
        info.compress = this._compress;
    }

    @Override
    protected boolean checkOption(String option, String argument, String endpoint) {
        if (super.checkOption(option, argument, endpoint)) {
            return true;
        }
        switch (option.charAt(1)) {
            case 't': {
                if (argument == null) {
                    throw new EndpointParseException("no argument provided for -t option in endpoint " + endpoint);
                }
                if (argument.equals("infinite")) {
                    this._timeout = -1;
                } else {
                    try {
                        this._timeout = Integer.parseInt(argument);
                        if (this._timeout < 1) {
                            throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("invalid timeout value `" + argument + "' in endpoint " + endpoint);
                    }
                }
                return true;
            }
            case 'z': {
                if (argument != null) {
                    throw new EndpointParseException("unexpected argument `" + argument + "' provided for -z option in " + endpoint);
                }
                this._compress = true;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Connector createConnector(InetSocketAddress addr, NetworkProxy proxy) {
        return new ConnectorI(this._instance, this._host, addr, proxy, this._sourceAddr, this._timeout, this._connectionId);
    }

    @Override
    protected IPEndpointI createEndpoint(String host, int port, String connectionId) {
        return new EndpointI(this._instance, host, port, this._sourceAddr, this._timeout, connectionId, this._compress);
    }
}

