/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.DispatchStatus;
import Ice.EncodingVersion;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.MarshalException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.Request;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.IncomingAsync;
import IceInternal.IncomingBase;
import IceInternal.Instance;
import IceInternal.Protocol;
import IceInternal.ResponseHandler;
import IceInternal.ServantManager;
import java.util.HashMap;
import java.util.LinkedList;

public final class Incoming
extends IncomingBase
implements Request {
    public Incoming next;
    private BasicStream _is;
    private IncomingAsync _cb;
    private int _inParamPos = -1;

    public Incoming(Instance instance, ResponseHandler responseHandler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        super(instance, responseHandler, connection, adapter, response, compress, requestId);
        if (response) {
            this._os.writeBlob(Protocol.replyHdr);
            this._os.writeInt(requestId);
        }
    }

    @Override
    public Current getCurrent() {
        return this._current;
    }

    @Override
    public void reset(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._cb = null;
        this._inParamPos = -1;
        super.reset(instance, handler, connection, adapter, response, compress, requestId);
        if (response) {
            this._os.writeBlob(Protocol.replyHdr);
            this._os.writeInt(requestId);
        }
    }

    @Override
    public void reclaim() {
        this._cb = null;
        this._inParamPos = -1;
        super.reclaim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ServantManager servantManager, BasicStream stream) {
        block39: {
            this._is = stream;
            int start = this._is.pos();
            this._current.id.__read(this._is);
            String[] facetPath = this._is.readStringSeq();
            if (facetPath.length > 0) {
                if (facetPath.length > 1) {
                    throw new MarshalException();
                }
                this._current.facet = facetPath[0];
            } else {
                this._current.facet = "";
            }
            this._current.operation = this._is.readString();
            this._current.mode = OperationMode.values()[this._is.readByte()];
            this._current.ctx = new HashMap<String, String>();
            int sz = this._is.readSize();
            while (sz-- > 0) {
                String first = this._is.readString();
                String second = this._is.readString();
                this._current.ctx.put(first, second);
            }
            CommunicatorObserver obsv = this._instance.initializationData().observer;
            if (obsv != null) {
                int size = this._is.readInt();
                this._is.pos(this._is.pos() - 4);
                this._observer = obsv.getDispatchObserver(this._current, this._is.pos() - start + size);
                if (this._observer != null) {
                    this._observer.attach();
                }
            }
            if (servantManager != null) {
                this._servant = servantManager.findServant(this._current.id, this._current.facet);
                if (this._servant == null) {
                    this._locator = servantManager.findServantLocator(this._current.id.category);
                    if (this._locator == null && this._current.id.category.length() > 0) {
                        this._locator = servantManager.findServantLocator("");
                    }
                    if (this._locator != null) {
                        try {
                            this._servant = this._locator.locate(this._current, this._cookie);
                        }
                        catch (UserException ex) {
                            EncodingVersion encoding = this._is.skipEncaps();
                            if (this._observer != null) {
                                this._observer.userException();
                            }
                            if (this._response) {
                                this._os.writeByte((byte)1);
                                this._os.startWriteEncaps(encoding, FormatType.DefaultFormat);
                                this._os.writeUserException(ex);
                                this._os.endWriteEncaps();
                                if (this._observer != null) {
                                    this._observer.reply(this._os.size() - 14 - 4);
                                }
                                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, false);
                            } else {
                                this._responseHandler.sendNoResponse();
                            }
                            if (this._observer != null) {
                                this._observer.detach();
                                this._observer = null;
                            }
                            this._responseHandler = null;
                            return;
                        }
                        catch (Exception ex) {
                            this._is.skipEncaps();
                            this.__handleException(ex, false);
                            return;
                        }
                        catch (Error ex) {
                            this._is.skipEncaps();
                            this.__handleError(ex, false);
                        }
                    }
                }
            }
            try {
                if (this._servant != null) {
                    if (this._instance.useApplicationClassLoader()) {
                        Thread.currentThread().setContextClassLoader(this._servant.getClass().getClassLoader());
                    }
                    try {
                        if (this._servant.__dispatch(this, this._current) == DispatchStatus.DispatchAsync) {
                            return;
                        }
                    }
                    finally {
                        if (this._instance.useApplicationClassLoader()) {
                            Thread.currentThread().setContextClassLoader(null);
                        }
                    }
                    if (this._locator != null && !this.__servantLocatorFinished(false)) {
                        return;
                    }
                    break block39;
                }
                this._is.skipEncaps();
                if (servantManager != null && servantManager.hasServant(this._current.id)) {
                    throw new FacetNotExistException(this._current.id, this._current.facet, this._current.operation);
                }
                throw new ObjectNotExistException(this._current.id, this._current.facet, this._current.operation);
            }
            catch (Exception ex) {
                if (this._servant != null && this._locator != null && !this.__servantLocatorFinished(false)) {
                    return;
                }
                this.__handleException(ex, false);
                return;
            }
            catch (Error ex) {
                if (this._servant != null && this._locator != null && !this.__servantLocatorFinished(false)) {
                    return;
                }
                this.__handleError(ex, false);
            }
        }
        assert (this._responseHandler != null);
        if (this._response) {
            if (this._observer != null) {
                this._observer.reply(this._os.size() - 14 - 4);
            }
            this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, false);
        } else {
            this._responseHandler.sendNoResponse();
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }

    public final void push(DispatchInterceptorAsyncCallback cb) {
        if (this._interceptorAsyncCallbackList == null) {
            this._interceptorAsyncCallbackList = new LinkedList();
        }
        this._interceptorAsyncCallbackList.addFirst(cb);
    }

    public final void pop() {
        assert (this._interceptorAsyncCallbackList != null);
        this._interceptorAsyncCallbackList.removeFirst();
    }

    public final void startOver() {
        if (this._inParamPos == -1) {
            this._inParamPos = this._is.pos();
        } else {
            this.killAsync();
            this._is.pos(this._inParamPos);
            if (this._response) {
                this._os.resize(18, false);
            }
        }
    }

    public final void killAsync() {
        if (this._cb != null) {
            this._cb.__deactivate(this);
            this._cb = null;
        }
    }

    public final BasicStream startReadParams() {
        this._current.encoding = this._is.startReadEncaps();
        return this._is;
    }

    public final void endReadParams() {
        this._is.endReadEncaps();
    }

    public final void readEmptyParams() {
        this._current.encoding = new EncodingVersion();
        this._is.skipEmptyEncaps(this._current.encoding);
    }

    public final byte[] readParamEncaps() {
        this._current.encoding = new EncodingVersion();
        return this._is.readEncaps(this._current.encoding);
    }

    final void setActive(IncomingAsync cb) {
        assert (this._cb == null);
        this._cb = cb;
    }

    final boolean isRetriable() {
        return this._inParamPos != -1;
    }
}

