/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanOptional;
import Ice.ByteOptional;
import Ice.CompactIdResolver;
import Ice.CompressionException;
import Ice.DoubleOptional;
import Ice.EncapsulationException;
import Ice.EncodingVersion;
import Ice.FloatOptional;
import Ice.FormatType;
import Ice.IllegalMessageSizeException;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.Logger;
import Ice.LongOptional;
import Ice.MarshalException;
import Ice.NoObjectFactoryException;
import Ice.Object;
import Ice.ObjectFactory;
import Ice.ObjectImpl;
import Ice.ObjectPrx;
import Ice.Optional;
import Ice.OptionalFormat;
import Ice.OptionalObject;
import Ice.ShortOptional;
import Ice.SliceInfo;
import Ice.SlicedData;
import Ice.UnknownSlicedObject;
import Ice.UnknownUserException;
import Ice.UnmarshalOutOfBoundsException;
import Ice.UserException;
import IceInternal.Buffer;
import IceInternal.Ex;
import IceInternal.InputStreamWrapper;
import IceInternal.Instance;
import IceInternal.ObjectFactoryManager;
import IceInternal.ObjectInputStream;
import IceInternal.OutputStreamWrapper;
import IceInternal.Patcher;
import IceInternal.Protocol;
import IceInternal.SequencePatcher;
import IceInternal.TraceUtil;
import IceInternal.UserExceptionFactory;
import IceInternal.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BasicStream {
    static final Charset _utf8 = Charset.forName("UTF8");
    private CharsetEncoder _charEncoder = null;
    private Instance _instance;
    private Buffer _buf;
    private java.lang.Object _closure;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private EncodingVersion _encoding;
    private ReadEncaps _readEncapsStack;
    private WriteEncaps _writeEncapsStack;
    private ReadEncaps _readEncapsCache;
    private WriteEncaps _writeEncapsCache;
    private boolean _sliceObjects;
    private int _startSeq;
    private int _minSeqSize;
    private static final int OPTIONAL_END_MARKER = 255;
    private static final byte FLAG_HAS_TYPE_ID_STRING = 1;
    private static final byte FLAG_HAS_TYPE_ID_INDEX = 2;
    private static final byte FLAG_HAS_TYPE_ID_COMPACT = 3;
    private static final byte FLAG_HAS_OPTIONAL_MEMBERS = 4;
    private static final byte FLAG_HAS_INDIRECTION_TABLE = 8;
    private static final byte FLAG_HAS_SLICE_SIZE = 16;
    private static final byte FLAG_IS_LAST_SLICE = 32;
    private static boolean _checkedBZip2 = false;
    private static Constructor<?> _bzInputStreamCtor;
    private static Constructor<?> _bzOutputStreamCtor;

    public BasicStream(Instance instance, EncodingVersion encoding) {
        this(instance, encoding, instance.cacheMessageBuffers() > 1);
    }

    public BasicStream(Instance instance, EncodingVersion encoding, boolean direct) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(direct);
    }

    public BasicStream(Instance instance, EncodingVersion encoding, byte[] data) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(data);
    }

    public BasicStream(Instance instance, EncodingVersion encoding, ByteBuffer data) {
        this.initialize(instance, encoding);
        this._buf = new Buffer(data);
    }

    private void initialize(Instance instance, EncodingVersion encoding) {
        this._instance = instance;
        this._closure = null;
        this._encoding = encoding;
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
        this._readEncapsCache = null;
        this._writeEncapsCache = null;
        this._sliceObjects = true;
        this._startSeq = -1;
    }

    public void reset() {
        this._buf.reset();
        this.clear();
    }

    public void clear() {
        if (this._readEncapsStack != null) {
            assert (this._readEncapsStack.next == null);
            this._readEncapsStack.next = this._readEncapsCache;
            this._readEncapsCache = this._readEncapsStack;
            this._readEncapsCache.reset();
            this._readEncapsStack = null;
        }
        if (this._writeEncapsStack != null) {
            assert (this._writeEncapsStack.next == null);
            this._writeEncapsStack.next = this._writeEncapsCache;
            this._writeEncapsCache = this._writeEncapsStack;
            this._writeEncapsCache.reset();
            this._writeEncapsStack = null;
        }
        this._startSeq = -1;
        this._sliceObjects = true;
    }

    public Instance instance() {
        return this._instance;
    }

    public java.lang.Object closure() {
        return this._closure;
    }

    public java.lang.Object closure(java.lang.Object p) {
        java.lang.Object prev = this._closure;
        this._closure = p;
        return prev;
    }

    public void swap(BasicStream other) {
        assert (this._instance == other._instance);
        Buffer tmpBuf = other._buf;
        other._buf = this._buf;
        this._buf = tmpBuf;
        java.lang.Object tmpClosure = other._closure;
        other._closure = this._closure;
        this._closure = tmpClosure;
        this.resetEncaps();
        other.resetEncaps();
        int tmpStartSeq = other._startSeq;
        other._startSeq = this._startSeq;
        this._startSeq = tmpStartSeq;
        int tmpMinSeqSize = other._minSeqSize;
        other._minSeqSize = this._minSeqSize;
        this._minSeqSize = tmpMinSeqSize;
    }

    public void resetEncaps() {
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
    }

    public void resize(int sz, boolean reading) {
        this._buf.resize(sz, reading);
        this._buf.b.position(sz);
    }

    public Buffer prepareWrite() {
        this._buf.b.limit(this._buf.size());
        this._buf.b.position(0);
        return this._buf;
    }

    public Buffer getBuffer() {
        return this._buf;
    }

    public void startWriteObject(SlicedData data) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startInstance(SliceType.ObjectSlice, data);
    }

    public void endWriteObject() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endInstance();
    }

    public void startReadObject() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.startInstance(SliceType.ObjectSlice);
    }

    public SlicedData endReadObject(boolean preserve) {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.endInstance(preserve);
    }

    public void startWriteException(SlicedData data) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startInstance(SliceType.ExceptionSlice, data);
    }

    public void endWriteException() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endInstance();
    }

    public void startReadException() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.startInstance(SliceType.ExceptionSlice);
    }

    public SlicedData endReadException(boolean preserve) {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.endInstance(preserve);
    }

    public void startWriteEncaps() {
        if (this._writeEncapsStack != null) {
            this.startWriteEncaps(this._writeEncapsStack.encoding, this._writeEncapsStack.format);
        } else {
            this.startWriteEncaps(this._encoding, FormatType.DefaultFormat);
        }
    }

    public void startWriteEncaps(EncodingVersion encoding, FormatType format) {
        Protocol.checkSupportedEncoding(encoding);
        WriteEncaps curr = this._writeEncapsCache;
        if (curr != null) {
            curr.reset();
            this._writeEncapsCache = this._writeEncapsCache.next;
        } else {
            curr = new WriteEncaps();
        }
        curr.next = this._writeEncapsStack;
        this._writeEncapsStack = curr;
        this._writeEncapsStack.format = format;
        this._writeEncapsStack.setEncoding(encoding);
        this._writeEncapsStack.start = this._buf.size();
        this.writeInt(0);
        this._writeEncapsStack.encoding.__write(this);
    }

    public void endWriteEncaps() {
        assert (this._writeEncapsStack != null);
        int start = this._writeEncapsStack.start;
        int sz = this._buf.size() - start;
        this._buf.b.putInt(start, sz);
        WriteEncaps curr = this._writeEncapsStack;
        this._writeEncapsStack = curr.next;
        curr.next = this._writeEncapsCache;
        this._writeEncapsCache = curr;
        this._writeEncapsCache.reset();
    }

    public void endWriteEncapsChecked() {
        if (this._writeEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endWriteEncaps();
    }

    public void writeEmptyEncaps(EncodingVersion encoding) {
        Protocol.checkSupportedEncoding(encoding);
        this.writeInt(6);
        encoding.__write(this);
    }

    public void writeEncaps(byte[] v) {
        if (v.length < 6) {
            throw new EncapsulationException();
        }
        this.expand(v.length);
        this._buf.b.put(v);
    }

    public EncodingVersion getWriteEncoding() {
        return this._writeEncapsStack != null ? this._writeEncapsStack.encoding : this._encoding;
    }

    public EncodingVersion startReadEncaps() {
        ReadEncaps curr = this._readEncapsCache;
        if (curr != null) {
            curr.reset();
            this._readEncapsCache = this._readEncapsCache.next;
        } else {
            curr = new ReadEncaps();
        }
        curr.next = this._readEncapsStack;
        this._readEncapsStack = curr;
        this._readEncapsStack.start = this._buf.b.position();
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (sz - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._readEncapsStack.sz = sz;
        EncodingVersion encoding = new EncodingVersion();
        encoding.__read(this);
        Protocol.checkSupportedEncoding(encoding);
        this._readEncapsStack.setEncoding(encoding);
        return encoding;
    }

    public void endReadEncaps() {
        assert (this._readEncapsStack != null);
        if (!this._readEncapsStack.encoding_1_0) {
            this.skipOpts();
            if (this._buf.b.position() != this._readEncapsStack.start + this._readEncapsStack.sz) {
                throw new EncapsulationException();
            }
        } else if (this._buf.b.position() != this._readEncapsStack.start + this._readEncapsStack.sz) {
            if (this._buf.b.position() + 1 != this._readEncapsStack.start + this._readEncapsStack.sz) {
                throw new EncapsulationException();
            }
            try {
                this._buf.b.get();
            }
            catch (BufferUnderflowException ex) {
                throw new UnmarshalOutOfBoundsException();
            }
        }
        ReadEncaps curr = this._readEncapsStack;
        this._readEncapsStack = curr.next;
        curr.next = this._readEncapsCache;
        this._readEncapsCache = curr;
        this._readEncapsCache.reset();
    }

    public void skipEmptyEncaps(EncodingVersion encoding) {
        int sz = this.readInt();
        if (sz != 6) {
            throw new EncapsulationException();
        }
        int pos = this._buf.b.position();
        if (pos + 2 > this._buf.size()) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (encoding != null) {
            encoding.__read(this);
        } else {
            this._buf.b.position(pos + 2);
        }
    }

    public void endReadEncapsChecked() {
        if (this._readEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endReadEncaps();
    }

    public byte[] readEncaps(EncodingVersion encoding) {
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (sz - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (encoding != null) {
            encoding.__read(this);
            this._buf.b.position(this._buf.b.position() - 6);
        } else {
            this._buf.b.position(this._buf.b.position() - 4);
        }
        byte[] v = new byte[sz];
        try {
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public EncodingVersion getReadEncoding() {
        return this._readEncapsStack != null ? this._readEncapsStack.encoding : this._encoding;
    }

    public int getReadEncapsSize() {
        assert (this._readEncapsStack != null);
        return this._readEncapsStack.sz - 6;
    }

    public EncodingVersion skipEncaps() {
        int sz = this.readInt();
        if (sz < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        EncodingVersion encoding = new EncodingVersion();
        encoding.__read(this);
        try {
            this._buf.b.position(this._buf.b.position() + sz - 6);
        }
        catch (IllegalArgumentException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
        return encoding;
    }

    public void startWriteSlice(String typeId, int compactId, boolean last) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startSlice(typeId, compactId, last);
    }

    public void endWriteSlice() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endSlice();
    }

    public String startReadSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.startSlice();
    }

    public void endReadSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.endSlice();
    }

    public void skipSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.skipSlice();
    }

    public void readPendingObjects() {
        if (this._readEncapsStack != null && this._readEncapsStack.decoder != null) {
            this._readEncapsStack.decoder.readPendingObjects();
        } else if (this._readEncapsStack != null ? this._readEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0)) {
            this.skipSize();
        }
    }

    public void writePendingObjects() {
        if (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null) {
            this._writeEncapsStack.encoder.writePendingObjects();
        } else if (this._writeEncapsStack != null ? this._writeEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0)) {
            this.writeSize(0);
        }
    }

    public void writeSize(int v) {
        if (v > 254) {
            this.expand(5);
            this._buf.b.put((byte)-1);
            this._buf.b.putInt(v);
        } else {
            this.expand(1);
            this._buf.b.put((byte)v);
        }
    }

    public int readSize() {
        try {
            int b = this._buf.b.get();
            if (b == -1) {
                int v = this._buf.b.getInt();
                if (v < 0) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return v;
            }
            return b < 0 ? b + 256 : b;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public int readAndCheckSeqSize(int minSize) {
        int sz = this.readSize();
        if (sz == 0) {
            return sz;
        }
        if (this._startSeq == -1 || this._buf.b.position() > this._startSeq + this._minSeqSize) {
            this._startSeq = this._buf.b.position();
            this._minSeqSize = sz * minSize;
        } else {
            this._minSeqSize += sz * minSize;
        }
        if (this._startSeq + this._minSeqSize > this._buf.size()) {
            throw new UnmarshalOutOfBoundsException();
        }
        return sz;
    }

    public int startSize() {
        int pos = this._buf.b.position();
        this.writeInt(0);
        return pos;
    }

    public void endSize(int pos) {
        assert (pos >= 0);
        this.rewriteInt(this._buf.b.position() - pos - 4, pos);
    }

    public void writeBlob(byte[] v) {
        if (v == null) {
            return;
        }
        this.expand(v.length);
        this._buf.b.put(v);
    }

    public void writeBlob(byte[] v, int off, int len) {
        if (v == null) {
            return;
        }
        this.expand(len);
        this._buf.b.put(v, off, len);
    }

    public byte[] readBlob(int sz) {
        if (this._buf.b.remaining() < sz) {
            throw new UnmarshalOutOfBoundsException();
        }
        byte[] v = new byte[sz];
        try {
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public boolean writeOpt(int tag, OptionalFormat format) {
        assert (this._writeEncapsStack != null);
        if (this._writeEncapsStack.encoder != null) {
            return this._writeEncapsStack.encoder.writeOpt(tag, format);
        }
        return this.writeOptImpl(tag, format);
    }

    public boolean readOpt(int tag, OptionalFormat expectedFormat) {
        assert (this._readEncapsStack != null);
        if (this._readEncapsStack.decoder != null) {
            return this._readEncapsStack.decoder.readOpt(tag, expectedFormat);
        }
        return this.readOptImpl(tag, expectedFormat);
    }

    public void writeByte(byte v) {
        this.expand(1);
        this._buf.b.put(v);
    }

    public void writeByte(int tag, ByteOptional v) {
        if (v != null && v.isSet()) {
            this.writeByte(tag, v.get());
        }
    }

    public void writeByte(int tag, byte v) {
        if (this.writeOpt(tag, OptionalFormat.F1)) {
            this.writeByte(v);
        }
    }

    public void rewriteByte(byte v, int dest) {
        this._buf.b.put(dest, v);
    }

    public void writeByteSeq(byte[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            this._buf.b.put(v);
        }
    }

    public void writeByteSeq(int tag, Optional<byte[]> v) {
        if (v != null && v.isSet()) {
            this.writeByteSeq(tag, v.get());
        }
    }

    public void writeByteSeq(int tag, byte[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeByteSeq(v);
        }
    }

    public void writeByteBuffer(ByteBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            this.writeSize(v.remaining());
            this.expand(v.remaining());
            this._buf.b.put(v);
        }
    }

    public void writeSerializable(Serializable o) {
        if (o == null) {
            this.writeSize(0);
            return;
        }
        try {
            OutputStreamWrapper w = new OutputStreamWrapper(this);
            ObjectOutputStream out = new ObjectOutputStream(w);
            out.writeObject(o);
            out.close();
            w.close();
        }
        catch (Exception ex) {
            throw new MarshalException("cannot serialize object: " + ex);
        }
    }

    public byte readByte() {
        try {
            return this._buf.b.get();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readByte(int tag, ByteOptional v) {
        if (this.readOpt(tag, OptionalFormat.F1)) {
            v.set(this.readByte());
        } else {
            v.clear();
        }
    }

    public byte[] readByteSeq() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            byte[] v = new byte[sz];
            this._buf.b.get(v);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readByteSeq(int tag, Optional<byte[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            v.set(this.readByteSeq());
        } else {
            v.clear();
        }
    }

    public ByteBuffer readByteBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            ByteBuffer v = this._buf.b.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Serializable readSerializable() {
        int sz = this.readAndCheckSeqSize(1);
        if (sz == 0) {
            return null;
        }
        java.io.ObjectInputStream in = null;
        try {
            InputStreamWrapper w = new InputStreamWrapper(sz, this);
            in = new ObjectInputStream(this._instance, w);
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        catch (Exception ex) {
            throw new MarshalException("cannot deserialize object", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new MarshalException("cannot deserialize object", ex);
                }
            }
        }
    }

    public void writeBool(boolean v) {
        this.expand(1);
        this._buf.b.put(v ? (byte)1 : 0);
    }

    public void writeBool(int tag, BooleanOptional v) {
        if (v != null && v.isSet()) {
            this.writeBool(tag, v.get());
        }
    }

    public void writeBool(int tag, boolean v) {
        if (this.writeOpt(tag, OptionalFormat.F1)) {
            this.writeBool(v);
        }
    }

    public void rewriteBool(boolean v, int dest) {
        this._buf.b.put(dest, v ? (byte)1 : 0);
    }

    public void writeBoolSeq(boolean[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            for (boolean b : v) {
                this._buf.b.put(b ? (byte)1 : 0);
            }
        }
    }

    public void writeBoolSeq(int tag, Optional<boolean[]> v) {
        if (v != null && v.isSet()) {
            this.writeBoolSeq(tag, v.get());
        }
    }

    public void writeBoolSeq(int tag, boolean[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeBoolSeq(v);
        }
    }

    public boolean readBool() {
        try {
            return this._buf.b.get() == 1;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readBool(int tag, BooleanOptional v) {
        if (this.readOpt(tag, OptionalFormat.F1)) {
            v.set(this.readBool());
        } else {
            v.clear();
        }
    }

    public boolean[] readBoolSeq() {
        try {
            int sz = this.readAndCheckSeqSize(1);
            boolean[] v = new boolean[sz];
            for (int i = 0; i < sz; ++i) {
                v[i] = this._buf.b.get() == 1;
            }
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readBoolSeq(int tag, Optional<boolean[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            v.set(this.readBoolSeq());
        } else {
            v.clear();
        }
    }

    public void writeShort(short v) {
        this.expand(2);
        this._buf.b.putShort(v);
    }

    public void writeShort(int tag, ShortOptional v) {
        if (v != null && v.isSet()) {
            this.writeShort(tag, v.get());
        }
    }

    public void writeShort(int tag, short v) {
        if (this.writeOpt(tag, OptionalFormat.F2)) {
            this.writeShort(v);
        }
    }

    public void writeShortSeq(short[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 2);
        }
    }

    public void writeShortSeq(int tag, Optional<short[]> v) {
        if (v != null && v.isSet()) {
            this.writeShortSeq(tag, v.get());
        }
    }

    public void writeShortSeq(int tag, short[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 2 + (v.length > 254 ? 5 : 1));
            this.writeShortSeq(v);
        }
    }

    public void writeShortBuffer(ShortBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.put(v);
            this._buf.b.position(this._buf.b.position() + sz * 2);
        }
    }

    public short readShort() {
        try {
            return this._buf.b.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readShort(int tag, ShortOptional v) {
        if (this.readOpt(tag, OptionalFormat.F2)) {
            v.set(this.readShort());
        } else {
            v.clear();
        }
    }

    public short[] readShortSeq() {
        try {
            int sz = this.readAndCheckSeqSize(2);
            short[] v = new short[sz];
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 2);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readShortSeq(int tag, Optional<short[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            this.skipSize();
            v.set(this.readShortSeq());
        } else {
            v.clear();
        }
    }

    public ShortBuffer readShortBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            ShortBuffer v = shortBuf.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz * 2);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeInt(int v) {
        this.expand(4);
        this._buf.b.putInt(v);
    }

    public void writeInt(int tag, IntOptional v) {
        if (v != null && v.isSet()) {
            this.writeInt(tag, v.get());
        }
    }

    public void writeInt(int tag, int v) {
        if (this.writeOpt(tag, OptionalFormat.F4)) {
            this.writeInt(v);
        }
    }

    public void rewriteInt(int v, int dest) {
        this._buf.b.putInt(dest, v);
    }

    public void writeIntSeq(int[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 4);
        }
    }

    public void writeIntSeq(int tag, Optional<int[]> v) {
        if (v != null && v.isSet()) {
            this.writeIntSeq(tag, v.get());
        }
    }

    public void writeIntSeq(int tag, int[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 4 + (v.length > 254 ? 5 : 1));
            this.writeIntSeq(v);
        }
    }

    public void writeIntBuffer(IntBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.put(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
        }
    }

    public int readInt() {
        try {
            return this._buf.b.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readInt(int tag, IntOptional v) {
        if (this.readOpt(tag, OptionalFormat.F4)) {
            v.set(this.readInt());
        } else {
            v.clear();
        }
    }

    public int[] readIntSeq() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            int[] v = new int[sz];
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readIntSeq(int tag, Optional<int[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            this.skipSize();
            v.set(this.readIntSeq());
        } else {
            v.clear();
        }
    }

    public IntBuffer readIntBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            IntBuffer v = intBuf.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeLong(long v) {
        this.expand(8);
        this._buf.b.putLong(v);
    }

    public void writeLong(int tag, LongOptional v) {
        if (v != null && v.isSet()) {
            this.writeLong(tag, v.get());
        }
    }

    public void writeLong(int tag, long v) {
        if (this.writeOpt(tag, OptionalFormat.F8)) {
            this.writeLong(v);
        }
    }

    public void writeLongSeq(long[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 8);
        }
    }

    public void writeLongSeq(int tag, Optional<long[]> v) {
        if (v != null && v.isSet()) {
            this.writeLongSeq(tag, v.get());
        }
    }

    public void writeLongSeq(int tag, long[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 8 + (v.length > 254 ? 5 : 1));
            this.writeLongSeq(v);
        }
    }

    public void writeLongBuffer(LongBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.put(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
        }
    }

    public long readLong() {
        try {
            return this._buf.b.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readLong(int tag, LongOptional v) {
        if (this.readOpt(tag, OptionalFormat.F8)) {
            v.set(this.readLong());
        } else {
            v.clear();
        }
    }

    public long[] readLongSeq() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            long[] v = new long[sz];
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readLongSeq(int tag, Optional<long[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            this.skipSize();
            v.set(this.readLongSeq());
        } else {
            v.clear();
        }
    }

    public LongBuffer readLongBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            LongBuffer v = longBuf.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeFloat(float v) {
        this.expand(4);
        this._buf.b.putFloat(v);
    }

    public void writeFloat(int tag, FloatOptional v) {
        if (v != null && v.isSet()) {
            this.writeFloat(tag, v.get());
        }
    }

    public void writeFloat(int tag, float v) {
        if (this.writeOpt(tag, OptionalFormat.F4)) {
            this.writeFloat(v);
        }
    }

    public void writeFloatSeq(float[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 4);
        }
    }

    public void writeFloatSeq(int tag, Optional<float[]> v) {
        if (v != null && v.isSet()) {
            this.writeFloatSeq(tag, v.get());
        }
    }

    public void writeFloatSeq(int tag, float[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 4 + (v.length > 254 ? 5 : 1));
            this.writeFloatSeq(v);
        }
    }

    public void writeFloatBuffer(FloatBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.put(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
        }
    }

    public float readFloat() {
        try {
            return this._buf.b.getFloat();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readFloat(int tag, FloatOptional v) {
        if (this.readOpt(tag, OptionalFormat.F4)) {
            v.set(this.readFloat());
        } else {
            v.clear();
        }
    }

    public float[] readFloatSeq() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            float[] v = new float[sz];
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readFloatSeq(int tag, Optional<float[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            this.skipSize();
            v.set(this.readFloatSeq());
        } else {
            v.clear();
        }
    }

    public FloatBuffer readFloatBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            FloatBuffer v = floatBuf.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz * 4);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeDouble(double v) {
        this.expand(8);
        this._buf.b.putDouble(v);
    }

    public void writeDouble(int tag, DoubleOptional v) {
        if (v != null && v.isSet()) {
            this.writeDouble(tag, v.get());
        }
    }

    public void writeDouble(int tag, double v) {
        if (this.writeOpt(tag, OptionalFormat.F8)) {
            this.writeDouble(v);
        }
    }

    public void writeDoubleSeq(double[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.put(v);
            this._buf.b.position(this._buf.b.position() + v.length * 8);
        }
    }

    public void writeDoubleSeq(int tag, Optional<double[]> v) {
        if (v != null && v.isSet()) {
            this.writeDoubleSeq(tag, v.get());
        }
    }

    public void writeDoubleSeq(int tag, double[] v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 8 + (v.length > 254 ? 5 : 1));
            this.writeDoubleSeq(v);
        }
    }

    public void writeDoubleBuffer(DoubleBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.put(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
        }
    }

    public double readDouble() {
        try {
            return this._buf.b.getDouble();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readDouble(int tag, DoubleOptional v) {
        if (this.readOpt(tag, OptionalFormat.F8)) {
            v.set(this.readDouble());
        } else {
            v.clear();
        }
    }

    public double[] readDoubleSeq() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            double[] v = new double[sz];
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.get(v);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v;
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readDoubleSeq(int tag, Optional<double[]> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            this.skipSize();
            v.set(this.readDoubleSeq());
        } else {
            v.clear();
        }
    }

    public DoubleBuffer readDoubleBuffer() {
        try {
            int sz = this.readAndCheckSeqSize(8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            DoubleBuffer v = doubleBuf.slice();
            v.limit(sz);
            this._buf.b.position(this._buf.b.position() + sz * 8);
            return v.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeString(String v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            int len = v.length();
            if (len > 0) {
                if (this._stringBytes == null || len > this._stringBytes.length) {
                    this._stringBytes = new byte[len];
                }
                if (this._stringChars == null || len > this._stringChars.length) {
                    this._stringChars = new char[len];
                }
                v.getChars(0, len, this._stringChars, 0);
                for (int i = 0; i < len; ++i) {
                    if (this._stringChars[i] > '\u007f') {
                        if (this._charEncoder == null) {
                            this._charEncoder = _utf8.newEncoder();
                        }
                        ByteBuffer b = null;
                        try {
                            b = this._charEncoder.encode(CharBuffer.wrap(this._stringChars, 0, len));
                        }
                        catch (CharacterCodingException ex) {
                            throw new MarshalException(ex);
                        }
                        this.writeSize(b.limit());
                        this.expand(b.limit());
                        this._buf.b.put(b);
                        return;
                    }
                    this._stringBytes[i] = (byte)this._stringChars[i];
                }
                this.writeSize(len);
                this.expand(len);
                this._buf.b.put(this._stringBytes, 0, len);
            } else {
                this.writeSize(0);
            }
        }
    }

    public void writeString(int tag, Optional<String> v) {
        if (v != null && v.isSet()) {
            this.writeString(tag, v.get());
        }
    }

    public void writeString(int tag, String v) {
        if (this.writeOpt(tag, OptionalFormat.VSize)) {
            this.writeString(v);
        }
    }

    public void writeStringSeq(String[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            for (String e : v) {
                this.writeString(e);
            }
        }
    }

    public void writeStringSeq(int tag, Optional<String[]> v) {
        if (v != null && v.isSet()) {
            this.writeStringSeq(tag, v.get());
        }
    }

    public void writeStringSeq(int tag, String[] v) {
        if (this.writeOpt(tag, OptionalFormat.FSize)) {
            int pos = this.startSize();
            this.writeStringSeq(v);
            this.endSize(pos);
        }
    }

    public String readString() {
        int len = this.readSize();
        if (len == 0) {
            return "";
        }
        if (this._buf.b.remaining() < len) {
            throw new UnmarshalOutOfBoundsException();
        }
        try {
            if (this._stringBytes == null || len > this._stringBytes.length) {
                this._stringBytes = new byte[len];
            }
            if (this._stringChars == null || len > this._stringChars.length) {
                this._stringChars = new char[len];
            }
            this._buf.b.get(this._stringBytes, 0, len);
            for (int i = 0; i < len; ++i) {
                if (this._stringBytes[i] < 0) {
                    return new String(this._stringBytes, 0, len, "UTF8");
                }
                this._stringChars[i] = (char)this._stringBytes[i];
            }
            return new String(this._stringChars, 0, len);
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return "";
        }
        catch (BufferUnderflowException ex) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readString(int tag, Optional<String> v) {
        if (this.readOpt(tag, OptionalFormat.VSize)) {
            v.set(this.readString());
        } else {
            v.clear();
        }
    }

    public String[] readStringSeq() {
        int sz = this.readAndCheckSeqSize(1);
        String[] v = new String[sz];
        for (int i = 0; i < sz; ++i) {
            v[i] = this.readString();
        }
        return v;
    }

    public void readStringSeq(int tag, Optional<String[]> v) {
        if (this.readOpt(tag, OptionalFormat.FSize)) {
            this.skip(4);
            v.set(this.readStringSeq());
        } else {
            v.clear();
        }
    }

    public void writeProxy(ObjectPrx v) {
        this._instance.proxyFactory().proxyToStream(v, this);
    }

    public void writeProxy(int tag, Optional<ObjectPrx> v) {
        if (v != null && v.isSet()) {
            this.writeProxy(tag, v.get());
        }
    }

    public void writeProxy(int tag, ObjectPrx v) {
        if (this.writeOpt(tag, OptionalFormat.FSize)) {
            int pos = this.startSize();
            this.writeProxy(v);
            this.endSize(pos);
        }
    }

    public ObjectPrx readProxy() {
        return this._instance.proxyFactory().streamToProxy(this);
    }

    public void readProxy(int tag, Optional<ObjectPrx> v) {
        if (this.readOpt(tag, OptionalFormat.FSize)) {
            this.skip(4);
            v.set(this.readProxy());
        } else {
            v.clear();
        }
    }

    public void writeEnum(int v, int maxValue) {
        if (this.isWriteEncoding_1_0()) {
            if (maxValue < 127) {
                this.writeByte((byte)v);
            } else if (maxValue < Short.MAX_VALUE) {
                this.writeShort((short)v);
            } else {
                this.writeInt(v);
            }
        } else {
            this.writeSize(v);
        }
    }

    public int readEnum(int maxValue) {
        if (this.getReadEncoding().equals(Ice.Util.Encoding_1_0)) {
            if (maxValue < 127) {
                return this.readByte();
            }
            if (maxValue < Short.MAX_VALUE) {
                return this.readShort();
            }
            return this.readInt();
        }
        return this.readSize();
    }

    public void writeObject(Object v) {
        this.initWriteEncaps();
        this._writeEncapsStack.encoder.writeObject(v);
    }

    public <T extends Object> void writeObject(int tag, Optional<T> v) {
        if (v != null && v.isSet()) {
            this.writeObject(tag, (Object)v.get());
        }
    }

    public void writeObject(int tag, Object v) {
        if (this.writeOpt(tag, OptionalFormat.Class)) {
            this.writeObject(v);
        }
    }

    public void readObject(Patcher patcher) {
        this.initReadEncaps();
        this._readEncapsStack.decoder.readObject(patcher);
    }

    public void readObject(int tag, Optional<Object> v) {
        if (this.readOpt(tag, OptionalFormat.Class)) {
            OptionalObject opt = new OptionalObject(v, Object.class, ObjectImpl.ice_staticId());
            this.readObject(opt);
        } else {
            v.clear();
        }
    }

    public void writeUserException(UserException e) {
        this.initWriteEncaps();
        this._writeEncapsStack.encoder.writeUserException(e);
    }

    public void throwException(UserExceptionFactory factory) throws UserException {
        this.initReadEncaps();
        this._readEncapsStack.decoder.throwException(factory);
    }

    public void sliceObjects(boolean b) {
        this._sliceObjects = b;
    }

    public boolean readOptImpl(int readTag, OptionalFormat expectedFormat) {
        int tag;
        OptionalFormat format;
        if (this.isReadEncoding_1_0()) {
            return false;
        }
        while (true) {
            int v;
            if (this._buf.b.position() >= this._readEncapsStack.start + this._readEncapsStack.sz) {
                return false;
            }
            int b = this.readByte();
            int n = v = b < 0 ? b + 256 : b;
            if (v == 255) {
                this._buf.b.position(this._buf.b.position() - 1);
                return false;
            }
            format = OptionalFormat.valueOf(v & 7);
            tag = v >> 3;
            if (tag == 30) {
                tag = this.readSize();
            }
            if (tag > readTag) {
                int offset = tag < 30 ? 1 : (tag < 255 ? 2 : 6);
                this._buf.b.position(this._buf.b.position() - offset);
                return false;
            }
            if (tag >= readTag) break;
            this.skipOpt(format);
        }
        if (format != expectedFormat) {
            throw new MarshalException("invalid optional data member `" + tag + "': unexpected format");
        }
        return true;
    }

    public boolean writeOptImpl(int tag, OptionalFormat format) {
        if (this.isWriteEncoding_1_0()) {
            return false;
        }
        int v = format.value();
        if (tag < 30) {
            this.writeByte((byte)(v |= tag << 3));
        } else {
            this.writeByte((byte)(v |= 0xF0));
            this.writeSize(tag);
        }
        return true;
    }

    public void skipOpt(OptionalFormat format) {
        switch (format) {
            case F1: {
                this.skip(1);
                break;
            }
            case F2: {
                this.skip(2);
                break;
            }
            case F4: {
                this.skip(4);
                break;
            }
            case F8: {
                this.skip(8);
                break;
            }
            case Size: {
                this.skipSize();
                break;
            }
            case VSize: {
                this.skip(this.readSize());
                break;
            }
            case FSize: {
                this.skip(this.readInt());
                break;
            }
            case Class: {
                this.readObject(null);
            }
        }
    }

    public void skipOpts() {
        while (this._buf.b.position() < this._readEncapsStack.start + this._readEncapsStack.sz) {
            int v;
            int b = this.readByte();
            int n = v = b < 0 ? b + 256 : b;
            if (v == 255) {
                return;
            }
            OptionalFormat format = OptionalFormat.valueOf(v & 7);
            if (v >> 3 == 30) {
                this.skipSize();
            }
            this.skipOpt(format);
        }
        return;
    }

    public void skip(int size) {
        if (size > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._buf.b.position(this._buf.b.position() + size);
    }

    public void skipSize() {
        byte b = this.readByte();
        if (b == -1) {
            this.skip(4);
        }
    }

    public int pos() {
        return this._buf.b.position();
    }

    public void pos(int n) {
        this._buf.b.position(n);
    }

    public int size() {
        return this._buf.size();
    }

    public boolean isEmpty() {
        return this._buf.empty();
    }

    public BasicStream compress(int headerSize, int compressionLevel) {
        assert (BasicStream.compressible());
        int uncompressedLen = this.size() - headerSize;
        int compressedLen = (int)((double)uncompressedLen * 1.01 + 600.0);
        byte[] compressed = new byte[compressedLen];
        byte[] data = null;
        int offset = 0;
        try {
            data = this._buf.b.array();
            offset = this._buf.b.arrayOffset();
        }
        catch (Exception ex) {
            data = new byte[this.size()];
            this.pos(0);
            this._buf.b.get(data);
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(compressed);
            bos.write(66);
            bos.write(90);
            java.lang.Object[] args = new java.lang.Object[]{bos, compressionLevel};
            OutputStream os = (OutputStream)_bzOutputStreamCtor.newInstance(args);
            os.write(data, offset + headerSize, uncompressedLen);
            os.close();
            compressedLen = bos.pos();
        }
        catch (Exception ex) {
            throw new CompressionException("bzip2 compression failure", ex);
        }
        if (compressedLen >= uncompressedLen) {
            return null;
        }
        BasicStream cstream = new BasicStream(this._instance, this._encoding);
        cstream.resize(headerSize + 4 + compressedLen, false);
        cstream.pos(0);
        cstream._buf.b.put(data, offset, headerSize);
        cstream.writeInt(this.size());
        cstream._buf.b.put(compressed, 0, compressedLen);
        return cstream;
    }

    public BasicStream uncompress(int headerSize, int messageSizeMax) {
        assert (BasicStream.compressible());
        this.pos(headerSize);
        int uncompressedSize = this.readInt();
        if (uncompressedSize <= headerSize) {
            throw new IllegalMessageSizeException();
        }
        if (uncompressedSize > messageSizeMax) {
            Ex.throwMemoryLimitException(uncompressedSize, messageSizeMax);
        }
        int compressedLen = this.size() - headerSize - 4;
        byte[] compressed = null;
        int offset = 0;
        try {
            compressed = this._buf.b.array();
            offset = this._buf.b.arrayOffset();
        }
        catch (Exception ex) {
            compressed = new byte[this.size()];
            this.pos(0);
            this._buf.b.get(compressed);
        }
        BasicStream ucStream = new BasicStream(this._instance, this._encoding);
        ucStream.resize(uncompressedSize, false);
        try {
            int n;
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed, offset + headerSize + 4, compressedLen);
            byte magicB = (byte)bais.read();
            byte magicZ = (byte)bais.read();
            if (magicB != 66 || magicZ != 90) {
                CompressionException e = new CompressionException();
                e.reason = "bzip2 uncompression failure: invalid magic bytes";
                throw e;
            }
            java.lang.Object[] args = new java.lang.Object[]{bais};
            InputStream is = (InputStream)_bzInputStreamCtor.newInstance(args);
            ucStream.pos(headerSize);
            byte[] arr = new byte[8192];
            while ((n = is.read(arr)) != -1) {
                ucStream.writeBlob(arr, 0, n);
            }
            is.close();
        }
        catch (Exception ex) {
            throw new CompressionException("bzip2 uncompression failure", ex);
        }
        ucStream.pos(0);
        ucStream._buf.b.put(compressed, offset, headerSize);
        return ucStream;
    }

    public void expand(int n) {
        this._buf.expand(n);
    }

    private String getTypeId(int compactId) {
        block5: {
            String className = "IceCompactId.TypeId_" + Integer.toString(compactId);
            Class<?> c = this.getConcreteClass(className);
            if (c == null) {
                String pkg;
                String[] stringArray = this._instance.getPackages();
                int n = stringArray.length;
                for (int i = 0; i < n && (c = this.getConcreteClass((pkg = stringArray[i]) + "." + className)) == null; ++i) {
                }
            }
            if (c != null) {
                try {
                    return (String)c.getField("typeId").get(null);
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return "";
    }

    private UserException createUserException(String id) {
        UserException userEx = null;
        try {
            Class<?> c = this.findClass(id);
            if (c != null) {
                userEx = (UserException)c.newInstance();
            }
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        return userEx;
    }

    private Class<?> findClass(String id) throws LinkageError {
        String pkg;
        int pos;
        Class<?> c = null;
        String className = this._instance.getClassForType(id);
        boolean addClass = false;
        if (className == null) {
            className = this.typeToClass(id);
            addClass = true;
        }
        if ((c = this.getConcreteClass(className)) == null && (pos = id.indexOf(58, 2)) != -1) {
            String topLevelModule = id.substring(2, pos);
            String pkg2 = this._instance.initializationData().properties.getProperty("Ice.Package." + topLevelModule);
            if (pkg2.length() > 0) {
                c = this.getConcreteClass(pkg2 + "." + className);
            }
        }
        if (c == null && (pkg = this._instance.initializationData().properties.getProperty("Ice.Default.Package")).length() > 0) {
            c = this.getConcreteClass(pkg + "." + className);
        }
        if (c != null && addClass) {
            this._instance.addClassForType(id, c.getName());
        }
        return c;
    }

    private Class<?> getConcreteClass(String className) throws LinkageError {
        int modifiers;
        Class<?> c = this._instance.findClass(className);
        if (c != null && ((modifiers = c.getModifiers()) & 0x200) == 0 && (modifiers & 0x400) == 0) {
            return c;
        }
        return null;
    }

    private static String fixKwd(String name) {
        java.lang.Object[] keywordList = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "enum", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean found = Arrays.binarySearch(keywordList, name) >= 0;
        return found ? "_" + name : name;
    }

    private String typeToClass(String id) {
        if (!id.startsWith("::")) {
            throw new MarshalException("expected type id but received `" + id + "'");
        }
        StringBuilder buf = new StringBuilder(id.length());
        int start = 2;
        boolean done = false;
        while (!done) {
            String s;
            int end = id.indexOf(58, start);
            if (end != -1) {
                s = id.substring(start, end);
                start = end + 2;
            } else {
                s = id.substring(start);
                done = true;
            }
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(BasicStream.fixKwd(s));
        }
        return buf.toString();
    }

    private boolean isReadEncoding_1_0() {
        return this._readEncapsStack != null ? this._readEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0);
    }

    private boolean isWriteEncoding_1_0() {
        return this._writeEncapsStack != null ? this._writeEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0);
    }

    private void initReadEncaps() {
        if (this._readEncapsStack == null) {
            this._readEncapsStack = this._readEncapsCache;
            if (this._readEncapsStack != null) {
                this._readEncapsCache = this._readEncapsCache.next;
            } else {
                this._readEncapsStack = new ReadEncaps();
            }
            this._readEncapsStack.setEncoding(this._encoding);
            this._readEncapsStack.sz = this._buf.b.limit();
        }
        if (this._readEncapsStack.decoder == null) {
            ObjectFactoryManager factoryManager = this._instance.servantFactoryManager();
            this._readEncapsStack.decoder = this._readEncapsStack.encoding_1_0 ? new EncapsDecoder10(this, this._sliceObjects, factoryManager) : new EncapsDecoder11(this, this._sliceObjects, factoryManager);
        }
    }

    private void initWriteEncaps() {
        if (this._writeEncapsStack == null) {
            this._writeEncapsStack = this._writeEncapsCache;
            if (this._writeEncapsStack != null) {
                this._writeEncapsCache = this._writeEncapsCache.next;
            } else {
                this._writeEncapsStack = new WriteEncaps();
            }
            this._writeEncapsStack.setEncoding(this._encoding);
        }
        if (this._writeEncapsStack.format == FormatType.DefaultFormat) {
            this._writeEncapsStack.format = this._instance.defaultsAndOverrides().defaultFormat;
        }
        if (this._writeEncapsStack.encoder == null) {
            this._writeEncapsStack.encoder = this._writeEncapsStack.encoding_1_0 ? new EncapsEncoder10(this, this._writeEncapsStack) : new EncapsEncoder11(this, this._writeEncapsStack);
        }
    }

    public static synchronized boolean compressible() {
        if (!_checkedBZip2) {
            _checkedBZip2 = true;
            try {
                Class[] types = new Class[1];
                Class<?> cls = Util.findClass("org.apache.tools.bzip2.CBZip2InputStream", null);
                if (cls != null) {
                    types[0] = InputStream.class;
                    _bzInputStreamCtor = cls.getDeclaredConstructor(types);
                }
                if ((cls = Util.findClass("org.apache.tools.bzip2.CBZip2OutputStream", null)) != null) {
                    types = new Class[]{OutputStream.class, Integer.TYPE};
                    _bzOutputStreamCtor = cls.getDeclaredConstructor(types);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _bzInputStreamCtor != null && _bzOutputStreamCtor != null;
    }

    private static final class WriteEncaps {
        int start;
        FormatType format = FormatType.DefaultFormat;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsEncoder encoder;
        WriteEncaps next;

        private WriteEncaps() {
        }

        void reset() {
            this.encoder = null;
        }

        void setEncoding(EncodingVersion encoding) {
            this.encoding = encoding;
            this.encoding_1_0 = encoding.equals(Ice.Util.Encoding_1_0);
        }
    }

    private static final class ReadEncaps {
        int start;
        int sz;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsDecoder decoder;
        ReadEncaps next;

        private ReadEncaps() {
        }

        void reset() {
            this.decoder = null;
        }

        void setEncoding(EncodingVersion encoding) {
            this.encoding = encoding;
            this.encoding_1_0 = encoding.equals(Ice.Util.Encoding_1_0);
        }
    }

    private static final class EncapsEncoder11
    extends EncapsEncoder {
        private InstanceData _current = null;
        private int _objectIdIndex = 1;

        EncapsEncoder11(BasicStream stream, WriteEncaps encaps) {
            super(stream, encaps);
        }

        @Override
        void writeObject(Object v) {
            if (v == null) {
                this._stream.writeSize(0);
            } else if (this._current != null && this._encaps.format == FormatType.SlicedFormat) {
                Integer index;
                if (this._current.indirectionTable == null) {
                    this._current.indirectionTable = new ArrayList<Object>();
                    this._current.indirectionMap = new IdentityHashMap();
                }
                if ((index = this._current.indirectionMap.get(v)) == null) {
                    this._current.indirectionTable.add(v);
                    int idx = this._current.indirectionTable.size();
                    this._current.indirectionMap.put(v, idx);
                    this._stream.writeSize(idx);
                } else {
                    this._stream.writeSize(index);
                }
            } else {
                this.writeInstance(v);
            }
        }

        @Override
        void writeUserException(UserException v) {
            v.__write(this._stream);
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData data) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.firstSlice = true;
            if (data != null) {
                this.writeSlicedData(data);
            }
        }

        @Override
        void endInstance() {
            this._current = this._current.previous;
        }

        @Override
        void startSlice(String typeId, int compactId, boolean last) {
            assert ((this._current.indirectionTable == null || this._current.indirectionTable.isEmpty()) && (this._current.indirectionMap == null || this._current.indirectionMap.isEmpty()));
            this._current.sliceFlagsPos = this._stream.pos();
            this._current.sliceFlags = 0;
            if (this._encaps.format == FormatType.SlicedFormat) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x10);
            }
            if (last) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x20);
            }
            this._stream.writeByte((byte)0);
            if (this._current.sliceType == SliceType.ObjectSlice) {
                if (this._encaps.format == FormatType.SlicedFormat || this._current.firstSlice) {
                    if (compactId >= 0) {
                        this._current.sliceFlags = (byte)(this._current.sliceFlags | 3);
                        this._stream.writeSize(compactId);
                    } else {
                        int index = this.registerTypeId(typeId);
                        if (index < 0) {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 1);
                            this._stream.writeString(typeId);
                        } else {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 2);
                            this._stream.writeSize(index);
                        }
                    }
                }
            } else {
                this._stream.writeString(typeId);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._stream.writeInt(0);
            }
            this._current.writeSlice = this._stream.pos();
            this._current.firstSlice = false;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.writeByte((byte)-1);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                int sz = this._stream.pos() - this._current.writeSlice + 4;
                this._stream.rewriteInt(sz, this._current.writeSlice - 4);
            }
            if (this._current.indirectionTable != null && !this._current.indirectionTable.isEmpty()) {
                assert (this._encaps.format == FormatType.SlicedFormat);
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 8);
                this._stream.writeSize(this._current.indirectionTable.size());
                for (Object v : this._current.indirectionTable) {
                    this.writeInstance(v);
                }
                this._current.indirectionTable.clear();
                this._current.indirectionMap.clear();
            }
            this._stream.rewriteByte(this._current.sliceFlags, this._current.sliceFlagsPos);
        }

        @Override
        boolean writeOpt(int tag, OptionalFormat format) {
            if (this._current == null) {
                return this._stream.writeOptImpl(tag, format);
            }
            if (this._stream.writeOptImpl(tag, format)) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                return true;
            }
            return false;
        }

        private void writeSlicedData(SlicedData slicedData) {
            assert (slicedData != null);
            if (this._encaps.format != FormatType.SlicedFormat) {
                return;
            }
            for (SliceInfo info : slicedData.slices) {
                this.startSlice(info.typeId, info.compactId, info.isLastSlice);
                this._stream.writeBlob(info.bytes);
                if (info.hasOptionalMembers) {
                    this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                }
                if (info.objects != null && info.objects.length > 0) {
                    if (this._current.indirectionTable == null) {
                        this._current.indirectionTable = new ArrayList<Object>();
                        this._current.indirectionMap = new IdentityHashMap();
                    }
                    for (Object o : info.objects) {
                        this._current.indirectionTable.add(o);
                    }
                }
                this.endSlice();
            }
        }

        private void writeInstance(Object v) {
            assert (v != null);
            Integer p = (Integer)this._marshaledMap.get(v);
            if (p != null) {
                this._stream.writeSize(p);
                return;
            }
            this._marshaledMap.put(v, ++this._objectIdIndex);
            try {
                v.ice_preMarshal();
            }
            catch (Exception ex) {
                String s = "exception raised by ice_preMarshal:\n" + Ex.toString(ex);
                this._stream.instance().initializationData().logger.warning(s);
            }
            this._stream.writeSize(1);
            v.__write(this._stream);
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean firstSlice;
            byte sliceFlags;
            int writeSlice;
            int sliceFlagsPos;
            List<Object> indirectionTable;
            IdentityHashMap<Object, Integer> indirectionMap;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData previous) {
                if (previous != null) {
                    previous.next = this;
                }
                this.previous = previous;
                this.next = null;
            }
        }
    }

    private static final class EncapsEncoder10
    extends EncapsEncoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private int _writeSlice;
        private int _objectIdIndex = 0;
        private IdentityHashMap<Object, Integer> _toBeMarshaledMap = new IdentityHashMap();

        EncapsEncoder10(BasicStream stream, WriteEncaps encaps) {
            super(stream, encaps);
        }

        @Override
        void writeObject(Object v) {
            if (v != null) {
                this._stream.writeInt(-this.registerObject(v));
            } else {
                this._stream.writeInt(0);
            }
        }

        @Override
        void writeUserException(UserException v) {
            boolean usesClasses = v.__usesClasses();
            this._stream.writeBool(usesClasses);
            v.__write(this._stream);
            if (usesClasses) {
                this.writePendingObjects();
            }
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData sliceData) {
            this._sliceType = sliceType;
        }

        @Override
        void endInstance() {
            if (this._sliceType == SliceType.ObjectSlice) {
                this.startSlice(ObjectImpl.ice_staticId(), -1, true);
                this._stream.writeSize(0);
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
        }

        @Override
        void startSlice(String typeId, int compactId, boolean last) {
            if (this._sliceType == SliceType.ObjectSlice) {
                int index = this.registerTypeId(typeId);
                if (index < 0) {
                    this._stream.writeBool(false);
                    this._stream.writeString(typeId);
                } else {
                    this._stream.writeBool(true);
                    this._stream.writeSize(index);
                }
            } else {
                this._stream.writeString(typeId);
            }
            this._stream.writeInt(0);
            this._writeSlice = this._stream.pos();
        }

        @Override
        void endSlice() {
            int sz = this._stream.pos() - this._writeSlice + 4;
            this._stream.rewriteInt(sz, this._writeSlice - 4);
        }

        @Override
        void writePendingObjects() {
            while (this._toBeMarshaledMap.size() > 0) {
                this._marshaledMap.putAll(this._toBeMarshaledMap);
                IdentityHashMap<Object, Integer> savedMap = this._toBeMarshaledMap;
                this._toBeMarshaledMap = new IdentityHashMap();
                this._stream.writeSize(savedMap.size());
                for (Map.Entry<Object, Integer> p : savedMap.entrySet()) {
                    this._stream.writeInt(p.getValue());
                    try {
                        p.getKey().ice_preMarshal();
                    }
                    catch (Exception ex) {
                        String s = "exception raised by ice_preMarshal:\n" + Ex.toString(ex);
                        this._stream.instance().initializationData().logger.warning(s);
                    }
                    p.getKey().__write(this._stream);
                }
            }
            this._stream.writeSize(0);
        }

        private int registerObject(Object v) {
            assert (v != null);
            Integer p = this._toBeMarshaledMap.get(v);
            if (p != null) {
                return p;
            }
            p = (Integer)this._marshaledMap.get(v);
            if (p != null) {
                return p;
            }
            this._toBeMarshaledMap.put(v, ++this._objectIdIndex);
            return this._objectIdIndex;
        }
    }

    private static abstract class EncapsEncoder {
        protected final BasicStream _stream;
        protected final WriteEncaps _encaps;
        protected final IdentityHashMap<Object, Integer> _marshaledMap;
        private TreeMap<String, Integer> _typeIdMap;
        private int _typeIdIndex;

        protected EncapsEncoder(BasicStream stream, WriteEncaps encaps) {
            this._stream = stream;
            this._encaps = encaps;
            this._typeIdIndex = 0;
            this._marshaledMap = new IdentityHashMap();
        }

        abstract void writeObject(Object var1);

        abstract void writeUserException(UserException var1);

        abstract void startInstance(SliceType var1, SlicedData var2);

        abstract void endInstance();

        abstract void startSlice(String var1, int var2, boolean var3);

        abstract void endSlice();

        boolean writeOpt(int tag, OptionalFormat format) {
            return false;
        }

        void writePendingObjects() {
        }

        protected int registerTypeId(String typeId) {
            Integer p;
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if ((p = this._typeIdMap.get(typeId)) != null) {
                return p;
            }
            this._typeIdMap.put(typeId, ++this._typeIdIndex);
            return -1;
        }
    }

    private static class EncapsDecoder11
    extends EncapsDecoder {
        private InstanceData _current = null;
        private int _objectIdIndex = 1;
        private TreeMap<Integer, Class<?>> _compactIdCache;

        EncapsDecoder11(BasicStream stream, boolean sliceObjects, ObjectFactoryManager f) {
            super(stream, sliceObjects, f);
        }

        @Override
        void readObject(Patcher patcher) {
            int index = this._stream.readSize();
            if (index < 0) {
                throw new MarshalException("invalid object id");
            }
            if (index == 0) {
                if (patcher != null) {
                    patcher.patch(null);
                }
            } else if (this._current != null && (this._current.sliceFlags & 8) != 0) {
                if (patcher != null) {
                    if (this._current.indirectPatchList == null) {
                        this._current.indirectPatchList = new ArrayDeque<IndirectPatchEntry>();
                    }
                    IndirectPatchEntry e = new IndirectPatchEntry();
                    e.index = index - 1;
                    e.patcher = patcher;
                    this._current.indirectPatchList.push(e);
                }
            } else {
                this.readInstance(index, patcher);
            }
        }

        @Override
        void throwException(UserExceptionFactory factory) throws UserException {
            assert (this._current == null);
            this.push(SliceType.ExceptionSlice);
            this.startSlice();
            String mostDerivedId = this._current.typeId;
            while (true) {
                UserException userEx = null;
                if (factory != null) {
                    try {
                        factory.createAndThrow(this._current.typeId);
                    }
                    catch (UserException ex) {
                        userEx = ex;
                    }
                }
                if (userEx == null) {
                    userEx = this._stream.createUserException(this._current.typeId);
                }
                if (userEx != null) {
                    userEx.__read(this._stream);
                    throw userEx;
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    if (mostDerivedId.startsWith("::")) {
                        throw new UnknownUserException(mostDerivedId.substring(2));
                    }
                    throw new UnknownUserException(mostDerivedId);
                }
                this.startSlice();
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._current.sliceType == sliceType);
            this._current.skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean preserve) {
            SlicedData slicedData = null;
            if (preserve) {
                slicedData = this.readSlicedData();
            }
            if (this._current.slices != null) {
                this._current.slices.clear();
                this._current.indirectionTables.clear();
            }
            this._current = this._current.previous;
            return slicedData;
        }

        @Override
        String startSlice() {
            if (this._current.skipFirstSlice) {
                this._current.skipFirstSlice = false;
                return this._current.typeId;
            }
            this._current.sliceFlags = this._stream.readByte();
            if (this._current.sliceType == SliceType.ObjectSlice) {
                if ((this._current.sliceFlags & 3) == 3) {
                    this._current.typeId = "";
                    this._current.compactId = this._stream.readSize();
                } else if ((this._current.sliceFlags & 3) != 0) {
                    this._current.typeId = this.readTypeId((this._current.sliceFlags & 2) != 0);
                    this._current.compactId = -1;
                } else {
                    this._current.typeId = "";
                    this._current.compactId = -1;
                }
            } else {
                this._current.typeId = this._stream.readString();
                this._current.compactId = -1;
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._current.sliceSize = this._stream.readInt();
                if (this._current.sliceSize < 4) {
                    throw new UnmarshalOutOfBoundsException();
                }
            } else {
                this._current.sliceSize = 0;
            }
            return this._current.typeId;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.skipOpts();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] indirectionTable = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < indirectionTable.length; ++i) {
                    indirectionTable[i] = this.readInstance(this._stream.readSize(), null);
                }
                if (indirectionTable.length == 0) {
                    throw new MarshalException("empty indirection table");
                }
                if ((this._current.indirectPatchList == null || this._current.indirectPatchList.isEmpty()) && (this._current.sliceFlags & 4) == 0) {
                    throw new MarshalException("no references to indirection table");
                }
                if (this._current.indirectPatchList != null) {
                    for (IndirectPatchEntry e : this._current.indirectPatchList) {
                        assert (e.index >= 0);
                        if (e.index >= indirectionTable.length) {
                            throw new MarshalException("indirection out of range");
                        }
                        this.addPatchEntry(indirectionTable[e.index], e.patcher);
                    }
                    this._current.indirectPatchList.clear();
                }
            }
        }

        @Override
        void skipSlice() {
            int end;
            if (this._stream.instance().traceLevels().slicing > 0) {
                Logger logger = this._stream.instance().initializationData().logger;
                String slicingCat = this._stream.instance().traceLevels().slicingCat;
                if (this._current.sliceType == SliceType.ExceptionSlice) {
                    TraceUtil.traceSlicing("exception", this._current.typeId, slicingCat, logger);
                } else {
                    TraceUtil.traceSlicing("object", this._current.typeId, slicingCat, logger);
                }
            }
            int start = this._stream.pos();
            if ((this._current.sliceFlags & 0x10) != 0) {
                assert (this._current.sliceSize >= 4);
            } else {
                if (this._current.sliceType == SliceType.ObjectSlice) {
                    throw new NoObjectFactoryException("no object factory found and compact format prevents slicing (the sender should use the sliced format instead)", this._current.typeId);
                }
                if (this._current.typeId.startsWith("::")) {
                    throw new UnknownUserException(this._current.typeId.substring(2));
                }
                throw new UnknownUserException(this._current.typeId);
            }
            this._stream.skip(this._current.sliceSize - 4);
            SliceInfo info = new SliceInfo();
            info.typeId = this._current.typeId;
            info.compactId = this._current.compactId;
            info.hasOptionalMembers = (this._current.sliceFlags & 4) != 0;
            info.isLastSlice = (this._current.sliceFlags & 0x20) != 0;
            ByteBuffer b = this._stream.getBuffer().b;
            int dataEnd = end = b.position();
            if (info.hasOptionalMembers) {
                --dataEnd;
            }
            info.bytes = new byte[dataEnd - start];
            b.position(start);
            b.get(info.bytes);
            b.position(end);
            if (this._current.slices == null) {
                this._current.slices = new ArrayList<SliceInfo>();
                this._current.indirectionTables = new ArrayList<int[]>();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] indirectionTable = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < indirectionTable.length; ++i) {
                    indirectionTable[i] = this.readInstance(this._stream.readSize(), null);
                }
                this._current.indirectionTables.add(indirectionTable);
            } else {
                this._current.indirectionTables.add(null);
            }
            this._current.slices.add(info);
        }

        @Override
        boolean readOpt(int readTag, OptionalFormat expectedFormat) {
            if (this._current == null) {
                return this._stream.readOptImpl(readTag, expectedFormat);
            }
            if ((this._current.sliceFlags & 4) != 0) {
                return this._stream.readOptImpl(readTag, expectedFormat);
            }
            return false;
        }

        private int readInstance(int index, Patcher patcher) {
            assert (index > 0);
            if (index > 1) {
                if (patcher != null) {
                    this.addPatchEntry(index, patcher);
                }
                return index;
            }
            this.push(SliceType.ObjectSlice);
            index = ++this._objectIdIndex;
            this.startSlice();
            String mostDerivedId = this._current.typeId;
            Object v = null;
            CompactIdResolver compactIdResolver = this._stream.instance().initializationData().compactIdResolver;
            while (true) {
                boolean updateCache = false;
                if (this._current.compactId >= 0) {
                    updateCache = true;
                    if (this._compactIdCache == null) {
                        this._compactIdCache = new TreeMap();
                    } else {
                        Class<?> cls = this._compactIdCache.get(this._current.compactId);
                        if (cls != null) {
                            try {
                                v = (Object)cls.newInstance();
                                updateCache = false;
                            }
                            catch (Exception ex) {
                                throw new NoObjectFactoryException("no object factory", "compact ID " + this._current.compactId, ex);
                            }
                        }
                    }
                    if (v == null) {
                        this._current.typeId = "";
                        if (compactIdResolver != null) {
                            try {
                                this._current.typeId = compactIdResolver.resolve(this._current.compactId);
                            }
                            catch (LocalException ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                throw new MarshalException("exception in CompactIdResolver for ID " + this._current.compactId, ex);
                            }
                        }
                        if (this._current.typeId.isEmpty()) {
                            this._current.typeId = this._stream.getTypeId(this._current.compactId);
                        }
                    }
                }
                if (v == null && !this._current.typeId.isEmpty()) {
                    v = this.newInstance(this._current.typeId);
                }
                if (v != null) {
                    if (!updateCache) break;
                    assert (this._current.compactId >= 0);
                    this._compactIdCache.put(this._current.compactId, v.getClass());
                    break;
                }
                if (!this._sliceObjects) {
                    throw new NoObjectFactoryException("no object factory found and object slicing is disabled", this._current.typeId);
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    v = this.newInstance(ObjectImpl.ice_staticId());
                    if (v != null) break;
                    v = new UnknownSlicedObject(mostDerivedId);
                    break;
                }
                this.startSlice();
            }
            this.unmarshal(index, v);
            if (this._current == null && this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
            if (patcher != null) {
                patcher.patch(v);
            }
            return index;
        }

        private SlicedData readSlicedData() {
            if (this._current.slices == null) {
                return null;
            }
            assert (this._current.slices.size() == this._current.indirectionTables.size());
            for (int n = 0; n < this._current.slices.size(); ++n) {
                int[] table = this._current.indirectionTables.get(n);
                SliceInfo info = this._current.slices.get(n);
                info.objects = new Object[table != null ? table.length : 0];
                for (int j = 0; j < info.objects.length; ++j) {
                    this.addPatchEntry(table[j], new SequencePatcher(info.objects, Object.class, ObjectImpl.ice_staticId(), j));
                }
            }
            SliceInfo[] arr = new SliceInfo[this._current.slices.size()];
            this._current.slices.toArray(arr);
            return new SlicedData(arr);
        }

        private void push(SliceType sliceType) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.skipFirstSlice = false;
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean skipFirstSlice;
            List<SliceInfo> slices;
            List<int[]> indirectionTables;
            byte sliceFlags;
            int sliceSize;
            String typeId;
            int compactId;
            Deque<IndirectPatchEntry> indirectPatchList;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData previous) {
                if (previous != null) {
                    previous.next = this;
                }
                this.previous = previous;
                this.next = null;
            }
        }

        private static final class IndirectPatchEntry {
            int index;
            Patcher patcher;

            private IndirectPatchEntry() {
            }
        }
    }

    private static final class EncapsDecoder10
    extends EncapsDecoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private boolean _skipFirstSlice;
        private int _sliceSize;
        private String _typeId;

        EncapsDecoder10(BasicStream stream, boolean sliceObjects, ObjectFactoryManager f) {
            super(stream, sliceObjects, f);
        }

        @Override
        void readObject(Patcher patcher) {
            assert (patcher != null);
            int index = this._stream.readInt();
            if (index > 0) {
                throw new MarshalException("invalid object id");
            }
            if ((index = -index) == 0) {
                patcher.patch(null);
            } else {
                this.addPatchEntry(index, patcher);
            }
        }

        @Override
        void throwException(UserExceptionFactory factory) throws UserException {
            assert (this._sliceType == SliceType.NoSlice);
            boolean usesClasses = this._stream.readBool();
            this._sliceType = SliceType.ExceptionSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String mostDerivedId = this._typeId;
            while (true) {
                UserException userEx = null;
                if (factory != null) {
                    try {
                        factory.createAndThrow(this._typeId);
                    }
                    catch (UserException ex) {
                        userEx = ex;
                    }
                }
                if (userEx == null) {
                    userEx = this._stream.createUserException(this._typeId);
                }
                if (userEx != null) {
                    userEx.__read(this._stream);
                    if (usesClasses) {
                        this.readPendingObjects();
                    }
                    throw userEx;
                }
                this.skipSlice();
                try {
                    this.startSlice();
                }
                catch (UnmarshalOutOfBoundsException ex) {
                    ex.reason = "unknown exception type `" + mostDerivedId + "'";
                    throw ex;
                }
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._sliceType == sliceType);
            this._skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean preserve) {
            if (this._sliceType == SliceType.ObjectSlice) {
                this.startSlice();
                int sz = this._stream.readSize();
                if (sz != 0) {
                    throw new MarshalException("invalid Object slice");
                }
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
            return null;
        }

        @Override
        String startSlice() {
            if (this._skipFirstSlice) {
                this._skipFirstSlice = false;
                return this._typeId;
            }
            if (this._sliceType == SliceType.ObjectSlice) {
                boolean isIndex = this._stream.readBool();
                this._typeId = this.readTypeId(isIndex);
            } else {
                this._typeId = this._stream.readString();
            }
            this._sliceSize = this._stream.readInt();
            if (this._sliceSize < 4) {
                throw new UnmarshalOutOfBoundsException();
            }
            return this._typeId;
        }

        @Override
        void endSlice() {
        }

        @Override
        void skipSlice() {
            if (this._stream.instance().traceLevels().slicing > 0) {
                Logger logger = this._stream.instance().initializationData().logger;
                if (this._sliceType == SliceType.ObjectSlice) {
                    TraceUtil.traceSlicing("object", this._typeId, this._stream.instance().traceLevels().slicingCat, logger);
                } else {
                    TraceUtil.traceSlicing("exception", this._typeId, this._stream.instance().traceLevels().slicingCat, logger);
                }
            }
            assert (this._sliceSize >= 4);
            this._stream.skip(this._sliceSize - 4);
        }

        @Override
        void readPendingObjects() {
            int num;
            do {
                for (int k = num = this._stream.readSize(); k > 0; --k) {
                    this.readInstance();
                }
            } while (num > 0);
            if (this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
        }

        private void readInstance() {
            int index = this._stream.readInt();
            if (index <= 0) {
                throw new MarshalException("invalid object id");
            }
            this._sliceType = SliceType.ObjectSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String mostDerivedId = this._typeId;
            Object v = null;
            while (true) {
                if (this._typeId.equals(ObjectImpl.ice_staticId())) {
                    throw new NoObjectFactoryException("", mostDerivedId);
                }
                v = this.newInstance(this._typeId);
                if (v != null) break;
                if (!this._sliceObjects) {
                    throw new NoObjectFactoryException("no object factory found and object slicing is disabled", this._typeId);
                }
                this.skipSlice();
                this.startSlice();
            }
            this.unmarshal(index, v);
        }
    }

    private static abstract class EncapsDecoder {
        protected final BasicStream _stream;
        protected final boolean _sliceObjects;
        protected ObjectFactoryManager _servantFactoryManager;
        protected TreeMap<Integer, LinkedList<Patcher>> _patchMap;
        private TreeMap<Integer, Object> _unmarshaledMap;
        private TreeMap<Integer, String> _typeIdMap;
        private int _typeIdIndex;
        private List<Object> _objectList;
        private HashMap<String, Class<?>> _typeIdCache;

        EncapsDecoder(BasicStream stream, boolean sliceObjects, ObjectFactoryManager f) {
            this._stream = stream;
            this._sliceObjects = sliceObjects;
            this._servantFactoryManager = f;
            this._typeIdIndex = 0;
            this._unmarshaledMap = new TreeMap();
        }

        abstract void readObject(Patcher var1);

        abstract void throwException(UserExceptionFactory var1) throws UserException;

        abstract void startInstance(SliceType var1);

        abstract SlicedData endInstance(boolean var1);

        abstract String startSlice();

        abstract void endSlice();

        abstract void skipSlice();

        boolean readOpt(int tag, OptionalFormat format) {
            return false;
        }

        void readPendingObjects() {
        }

        protected String readTypeId(boolean isIndex) {
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if (isIndex) {
                int index = this._stream.readSize();
                String typeId = this._typeIdMap.get(index);
                if (typeId == null) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return typeId;
            }
            String typeId = this._stream.readString();
            this._typeIdMap.put(++this._typeIdIndex, typeId);
            return typeId;
        }

        protected Class<?> resolveClass(String typeId) {
            Class<EncapsDecoder> cls = null;
            if (this._typeIdCache == null) {
                this._typeIdCache = new HashMap();
            } else {
                cls = this._typeIdCache.get(typeId);
            }
            if (cls == EncapsDecoder.class) {
                cls = null;
            } else if (cls == null) {
                try {
                    cls = this._stream.findClass(typeId);
                    this._typeIdCache.put(typeId, cls != null ? cls : EncapsDecoder.class);
                }
                catch (Exception ex) {
                    throw new NoObjectFactoryException("no object factory", typeId, ex);
                }
            }
            return cls;
        }

        protected Object newInstance(String typeId) {
            Class<?> cls;
            ObjectFactory userFactory = this._servantFactoryManager.find(typeId);
            Object v = null;
            if (userFactory != null) {
                v = userFactory.create(typeId);
            }
            if (v == null && (userFactory = this._servantFactoryManager.find("")) != null) {
                v = userFactory.create(typeId);
            }
            if (v == null && (cls = this.resolveClass(typeId)) != null) {
                try {
                    v = (Object)cls.newInstance();
                }
                catch (Exception ex) {
                    throw new NoObjectFactoryException("no object factory", typeId, ex);
                }
            }
            return v;
        }

        protected void addPatchEntry(int index, Patcher patcher) {
            LinkedList<Patcher> l;
            assert (index > 0);
            Object obj = this._unmarshaledMap.get(index);
            if (obj != null) {
                patcher.patch(obj);
                return;
            }
            if (this._patchMap == null) {
                this._patchMap = new TreeMap();
            }
            if ((l = this._patchMap.get(index)) == null) {
                l = new LinkedList();
                this._patchMap.put(index, l);
            }
            l.add(patcher);
        }

        protected void unmarshal(int index, Object v) {
            LinkedList<Patcher> l;
            this._unmarshaledMap.put(index, v);
            v.__read(this._stream);
            if (this._patchMap != null && (l = this._patchMap.get(index)) != null) {
                assert (l.size() > 0);
                for (Patcher p : l) {
                    p.patch(v);
                }
                this._patchMap.remove(index);
            }
            if ((this._patchMap == null || this._patchMap.isEmpty()) && this._objectList == null) {
                try {
                    v.ice_postUnmarshal();
                }
                catch (Exception ex) {
                    String s = "exception raised by ice_postUnmarshal:\n" + Ex.toString(ex);
                    this._stream.instance().initializationData().logger.warning(s);
                }
            } else {
                if (this._objectList == null) {
                    this._objectList = new ArrayList<Object>();
                }
                this._objectList.add(v);
                if (this._patchMap == null || this._patchMap.isEmpty()) {
                    for (Object p : this._objectList) {
                        try {
                            p.ice_postUnmarshal();
                        }
                        catch (Exception ex) {
                            String s = "exception raised by ice_postUnmarshal:\n" + Ex.toString(ex);
                            this._stream.instance().initializationData().logger.warning(s);
                        }
                    }
                    this._objectList.clear();
                }
            }
        }
    }

    private static enum SliceType {
        NoSlice,
        ObjectSlice,
        ExceptionSlice;

    }

    private static class BufferedOutputStream
    extends OutputStream {
        private byte[] _data;
        private int _pos;

        BufferedOutputStream(byte[] data) {
            this._data = data;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            assert (this._data.length - this._pos >= b.length);
            System.arraycopy(b, 0, this._data, this._pos, b.length);
            this._pos += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            assert (this._data.length - this._pos >= len);
            System.arraycopy(b, off, this._data, this._pos, len);
            this._pos += len;
        }

        @Override
        public void write(int b) throws IOException {
            assert (this._data.length - this._pos >= 1);
            this._data[this._pos] = (byte)b;
            ++this._pos;
        }

        int pos() {
            return this._pos;
        }
    }
}

