/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.IdentitySetPrx;
import com.zeroc.Glacier2.StringSetPrx;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface SessionControl
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public StringSetPrx categories(Current var1);

    public StringSetPrx adapterIds(Current var1);

    public IdentitySetPrx identities(Current var1);

    public int getSessionTimeout(Current var1);

    public void destroy(Current var1);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return SessionControl.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Glacier2::SessionControl";
    }

    public static CompletionStage<OutputStream> _iceD_categories(SessionControl obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        StringSetPrx ret = obj.categories(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_adapterIds(SessionControl obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        StringSetPrx ret = obj.adapterIds(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_identities(SessionControl obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        IdentitySetPrx ret = obj.identities(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getSessionTimeout(SessionControl obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        int ret = obj.getSessionTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_destroy(SessionControl obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return SessionControl._iceD_adapterIds(this, in, current);
            }
            case 1: {
                return SessionControl._iceD_categories(this, in, current);
            }
            case 2: {
                return SessionControl._iceD_destroy(this, in, current);
            }
            case 3: {
                return SessionControl._iceD_getSessionTimeout(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 5: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 6: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
            case 8: {
                return SessionControl._iceD_identities(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::SessionControl", "::Ice::Object"};
        _iceOps = new String[]{"adapterIds", "categories", "destroy", "getSessionTimeout", "ice_id", "ice_ids", "ice_isA", "ice_ping", "identities"};
    }
}

