// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.3
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 *
 **/
public abstract class _SSLPermissionsVerifierDisp extends Ice.ObjectImpl implements SSLPermissionsVerifier
{
    protected void
    ice_copyStateFrom(Ice.Object __obj)
        throws java.lang.CloneNotSupportedException
    {
        throw new java.lang.CloneNotSupportedException();
    }

    public static final String[] __ids =
    {
        "::Glacier2::SSLPermissionsVerifier",
        "::Ice::Object"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current __current)
    {
        return java.util.Arrays.binarySearch(__ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return __ids;
    }

    public String[] ice_ids(Ice.Current __current)
    {
        return __ids;
    }

    public String ice_id()
    {
        return __ids[0];
    }

    public String ice_id(Ice.Current __current)
    {
        return __ids[0];
    }

    public static String ice_staticId()
    {
        return __ids[0];
    }

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param reason The reason why access was denied.
     *
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public final boolean authorize(SSLInfo info, Ice.StringHolder reason)
        throws PermissionDeniedException
    {
        return authorize(info, reason, null);
    }

    public static Ice.DispatchStatus ___authorize(SSLPermissionsVerifier __obj, IceInternal.Incoming __inS, Ice.Current __current)
    {
        __checkMode(Ice.OperationMode.Idempotent, __current.mode);
        IceInternal.BasicStream __is = __inS.startReadParams();
        SSLInfo info = null;
        info = SSLInfo.__read(__is, info);
        __inS.endReadParams();
        Ice.StringHolder reason = new Ice.StringHolder();
        try
        {
            boolean __ret = __obj.authorize(info, reason, __current);
            IceInternal.BasicStream __os = __inS.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(reason.value);
            __os.writeBool(__ret);
            __inS.__endWriteParams(true);
            return Ice.DispatchStatus.DispatchOK;
        }
        catch(PermissionDeniedException ex)
        {
            __inS.__writeUserException(ex, Ice.FormatType.SlicedFormat);
            return Ice.DispatchStatus.DispatchUserException;
        }
    }

    private final static String[] __all =
    {
        "authorize",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    public Ice.DispatchStatus __dispatch(IceInternal.Incoming in, Ice.Current __current)
    {
        int pos = java.util.Arrays.binarySearch(__all, __current.operation);
        if(pos < 0)
        {
            throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return ___authorize(this, in, __current);
            }
            case 1:
            {
                return ___ice_id(this, in, __current);
            }
            case 2:
            {
                return ___ice_ids(this, in, __current);
            }
            case 3:
            {
                return ___ice_isA(this, in, __current);
            }
            case 4:
            {
                return ___ice_ping(this, in, __current);
            }
        }

        assert(false);
        throw new Ice.OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    protected void __writeImpl(IceInternal.BasicStream __os)
    {
        __os.startWriteSlice(ice_staticId(), -1, true);
        __os.endWriteSlice();
    }

    protected void __readImpl(IceInternal.BasicStream __is)
    {
        __is.startReadSlice();
        __is.endReadSlice();
    }

    public static final long serialVersionUID = 0L;
}
