// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The Glacier2 specialization of the {@link Ice.Router}
 * interface.
 *
 **/
public interface _RouterOperations extends Ice._RouterOperations
{
    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     *
     * @param __current The Current object for the invocation.
     * @return The category.
     *
     **/
    String getCategoryForClient(Ice.Current __current);

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @param __current The Current object for the invocation.
     **/
    void createSession_async(AMD_Router_createSession __cb, String userId, String password, Ice.Current __current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param __current The Current object for the invocation.
     **/
    void createSessionFromSecureConnection_async(AMD_Router_createSessionFromSecureConnection __cb, Ice.Current __current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     * @param __current The Current object for the invocation.
     **/
    void refreshSession_async(AMD_Router_refreshSession __cb, Ice.Current __current)
        throws SessionNotExistException;

    /**
     * Destroy the calling client's session with this router.
     *
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     *
     * @param __current The Current object for the invocation.
     **/
    void destroySession(Ice.Current __current)
        throws SessionNotExistException;

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     *
     * @param __current The Current object for the invocation.
     * @return The timeout (in seconds).
     *
     **/
    long getSessionTimeout(Ice.Current __current);

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param __current The Current object for the invocation.
     * @return The timeout (in seconds).
     *
     **/
    int getACMTimeout(Ice.Current __current);
}
