// **********************************************************************
//
// Copyright (c) 2003-2016 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.2
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 *
 **/
public interface SSLPermissionsVerifierPrx extends Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param reason The reason why access was denied.
     *
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param reason The reason why access was denied.
     *
     * @param __ctx The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason, java.util.Map<String, String> __ctx)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Callback_SSLPermissionsVerifier_authorize __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Callback_SSLPermissionsVerifier_authorize __cb);

    public interface FunctionalCallback_SSLPermissionsVerifier_authorize_Response
    {
        void apply(boolean __ret, String reason);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, 
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response __responseCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, 
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response __responseCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                           IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, 
                                           java.util.Map<String, String> __ctx, 
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response __responseCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __responseCb The lambda response callback.
     * @param __userExceptionCb The lambda user exception callback.
     * @param __exceptionCb The lambda exception callback.
     * @param __sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, 
                                           java.util.Map<String, String> __ctx, 
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response __responseCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> __userExceptionCb, 
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> __exceptionCb, 
                                           IceInternal.Functional_BoolCallback __sentCb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __result The asynchronous result object.
     * @return True if access is granted, or false otherwise.
     * 
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean end_authorize(Ice.StringHolder reason, Ice.AsyncResult __result)
        throws PermissionDeniedException;
}
