/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.provider;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.net.Server;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import com.xxl.rpc.util.ThrowableUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRpcProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(XxlRpcProviderFactory.class);
    private NetEnum netType;
    private Serializer serializer;
    private String ip;
    private int port = 7080;
    private String accessToken;
    private Class<? extends ServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private Server server;
    private ServiceRegistry serviceRegistry;
    private Map<String, Object> serviceData = new HashMap<String, Object>();

    public void initConfig(NetEnum netType, Serializer serializer, String ip, int port, String accessToken, Class<? extends ServiceRegistry> serviceRegistryClass, Map<String, String> serviceRegistryParam) {
        this.netType = netType;
        this.serializer = serializer;
        this.ip = ip;
        this.port = port;
        this.accessToken = accessToken;
        this.serviceRegistryClass = serviceRegistryClass;
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        this.server = this.netType.serverClass.newInstance();
        this.server.setStartedCallback(new BaseCallback(){

            @Override
            public void run() throws Exception {
                if (XxlRpcProviderFactory.this.serviceRegistryClass != null) {
                    XxlRpcProviderFactory.this.serviceRegistry = (ServiceRegistry)XxlRpcProviderFactory.this.serviceRegistryClass.newInstance();
                    XxlRpcProviderFactory.this.serviceRegistry.start(XxlRpcProviderFactory.this.serviceRegistryParam);
                    if (XxlRpcProviderFactory.this.serviceData.size() > 0) {
                        String ipPort = IpUtil.getIpPort(XxlRpcProviderFactory.this.ip, XxlRpcProviderFactory.this.port);
                        for (String serviceKey : XxlRpcProviderFactory.this.serviceData.keySet()) {
                            XxlRpcProviderFactory.this.serviceRegistry.registry(serviceKey, ipPort);
                        }
                    }
                }
            }
        });
        this.server.setStopedCallback(new BaseCallback(){

            @Override
            public void run() {
                if (XxlRpcProviderFactory.this.serviceRegistry != null) {
                    if (XxlRpcProviderFactory.this.serviceData.size() > 0) {
                        String ipPort = IpUtil.getIpPort(XxlRpcProviderFactory.this.ip, XxlRpcProviderFactory.this.port);
                        for (String serviceKey : XxlRpcProviderFactory.this.serviceData.keySet()) {
                            XxlRpcProviderFactory.this.serviceRegistry.remove(serviceKey, ipPort);
                        }
                    }
                    XxlRpcProviderFactory.this.serviceRegistry.stop();
                    XxlRpcProviderFactory.this.serviceRegistry = null;
                }
            }
        });
        this.server.start(this);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public Map<String, Object> getServiceData() {
        return this.serviceData;
    }

    public static String makeServiceKey(String iface, String version) {
        String serviceKey = iface;
        if (version != null && version.trim().length() > 0) {
            serviceKey = serviceKey + "#".concat(version);
        }
        return serviceKey;
    }

    public void addService(String iface, String version, Object serviceBean) {
        String serviceKey = XxlRpcProviderFactory.makeServiceKey(iface, version);
        this.serviceData.put(serviceKey, serviceBean);
        logger.info(">>>>>>>>>>> xxl-rpc, provider factory add service success. serviceKey = {}, serviceBean = {}", (Object)serviceKey, serviceBean.getClass());
    }

    public XxlRpcResponse invokeService(XxlRpcRequest xxlRpcRequest) {
        XxlRpcResponse xxlRpcResponse = new XxlRpcResponse();
        xxlRpcResponse.setRequestId(xxlRpcRequest.getRequestId());
        String serviceKey = XxlRpcProviderFactory.makeServiceKey(xxlRpcRequest.getClassName(), xxlRpcRequest.getVersion());
        Object serviceBean = this.serviceData.get(serviceKey);
        if (serviceBean == null) {
            xxlRpcResponse.setErrorMsg("The serviceKey[" + serviceKey + "] not found.");
            return xxlRpcResponse;
        }
        if (System.currentTimeMillis() - xxlRpcRequest.getCreateMillisTime() > 180000L) {
            xxlRpcResponse.setErrorMsg("The timestamp difference between admin and executor exceeds the limit.");
            return xxlRpcResponse;
        }
        if (this.accessToken != null && this.accessToken.trim().length() > 0 && !this.accessToken.trim().equals(xxlRpcRequest.getAccessToken())) {
            xxlRpcResponse.setErrorMsg("The access token[" + xxlRpcRequest.getAccessToken() + "] is wrong.");
            return xxlRpcResponse;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = xxlRpcRequest.getMethodName();
            Class<?>[] parameterTypes = xxlRpcRequest.getParameterTypes();
            Object[] parameters = xxlRpcRequest.getParameters();
            Method method = serviceClass.getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            Object result = method.invoke(serviceBean, parameters);
            xxlRpcResponse.setResult(result);
        }
        catch (Throwable t) {
            logger.error("xxl-rpc provider invokeService error.", t);
            xxlRpcResponse.setErrorMsg(ThrowableUtil.toString(t));
        }
        return xxlRpcResponse;
    }
}

