/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.pool;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.pool.ClientPoolFactory;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientPooled {
    protected static transient Logger logger = LoggerFactory.getLogger(ClientPooled.class);
    private static ConcurrentHashMap<String, GenericObjectPool<ClientPooled>> clientPoolMap;

    public abstract void init(String var1, int var2, Serializer var3) throws Exception;

    public abstract void close();

    public abstract boolean isValidate();

    public abstract void send(XxlRpcRequest var1) throws Exception;

    public static GenericObjectPool<ClientPooled> getPool(String address, Serializer serializer, Class<? extends ClientPooled> clientPoolImpl) throws Exception {
        GenericObjectPool clientPool;
        if (clientPoolMap == null) {
            clientPoolMap = new ConcurrentHashMap();
            XxlRpcInvokerFactory.addStopCallBack(new BaseCallback(){

                @Override
                public void run() throws Exception {
                    if (clientPoolMap.size() > 0) {
                        for (String key : clientPoolMap.keySet()) {
                            GenericObjectPool clientPool = (GenericObjectPool)clientPoolMap.get(key);
                            clientPool.close();
                        }
                        clientPoolMap.clear();
                    }
                }
            });
        }
        if ((clientPool = clientPoolMap.get(address)) != null) {
            return clientPool;
        }
        Object[] array = IpUtil.parseIpPort(address);
        String host = (String)array[0];
        int port = (Integer)array[1];
        clientPool = new GenericObjectPool((PooledObjectFactory)new ClientPoolFactory(host, port, serializer, clientPoolImpl));
        clientPool.setTestOnBorrow(true);
        clientPool.setMaxTotal(2);
        clientPoolMap.put(address, (GenericObjectPool<ClientPooled>)clientPool);
        return clientPool;
    }
}

