/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.rpc.netcom;

import com.xxl.job.core.rpc.codec.RpcRequest;
import com.xxl.job.core.rpc.codec.RpcResponse;
import com.xxl.job.core.rpc.netcom.jetty.client.JettyClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class NetComClientProxy
implements FactoryBean<Object> {
    private static final Logger logger = LoggerFactory.getLogger(NetComClientProxy.class);
    private Class<?> iface;
    private String serverAddress;
    private String accessToken;
    private JettyClient client = new JettyClient();

    public NetComClientProxy(Class<?> iface, String serverAddress, String accessToken) {
        this.iface = iface;
        this.serverAddress = serverAddress;
        this.accessToken = accessToken;
    }

    public Object getObject() throws Exception {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Object.class.getName().equals(method.getDeclaringClass().getName())) {
                    logger.error(">>>>>>>>>>> xxl-rpc proxy class-method not support [{}.{}]", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                    throw new RuntimeException("xxl-rpc proxy class-method not support");
                }
                RpcRequest request = new RpcRequest();
                request.setServerAddress(NetComClientProxy.this.serverAddress);
                request.setCreateMillisTime(System.currentTimeMillis());
                request.setAccessToken(NetComClientProxy.this.accessToken);
                request.setClassName(method.getDeclaringClass().getName());
                request.setMethodName(method.getName());
                request.setParameterTypes(method.getParameterTypes());
                request.setParameters(args);
                RpcResponse response = NetComClientProxy.this.client.send(request);
                if (response == null) {
                    logger.error(">>>>>>>>>>> xxl-rpc netty response not found.");
                    throw new Exception(">>>>>>>>>>> xxl-rpc netty response not found.");
                }
                if (response.isError()) {
                    throw new RuntimeException(response.getError());
                }
                return response.getResult();
            }
        });
    }

    public Class<?> getObjectType() {
        return this.iface;
    }

    public boolean isSingleton() {
        return false;
    }
}

