/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.job.core.thread.TriggerCallbackThread;
import com.xxl.job.core.util.ShardingUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobThread.class);
    private int jobId;
    private IJobHandler handler;
    private LinkedBlockingQueue<TriggerParam> triggerQueue;
    private ConcurrentHashSet<Integer> triggerLogIdSet;
    private boolean toStop = false;
    private String stopReason;
    private boolean running = false;
    private int idleTimes = 0;

    public JobThread(int jobId, IJobHandler handler) {
        this.jobId = jobId;
        this.handler = handler;
        this.triggerQueue = new LinkedBlockingQueue();
        this.triggerLogIdSet = new ConcurrentHashSet();
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public ReturnT<String> pushTriggerQueue(TriggerParam triggerParam) {
        if (this.triggerLogIdSet.contains((Object)triggerParam.getLogId())) {
            logger.debug("repeate trigger job, logId:{}", (Object)triggerParam.getLogId());
            return new ReturnT<String>(500, "repeate trigger job, logId:" + triggerParam.getLogId());
        }
        this.triggerLogIdSet.add((Object)triggerParam.getLogId());
        this.triggerQueue.add(triggerParam);
        return ReturnT.SUCCESS;
    }

    public void toStop(String stopReason) {
        this.toStop = true;
        this.stopReason = stopReason;
    }

    public boolean isRunningOrHasQueue() {
        return this.running || this.triggerQueue.size() > 0;
    }

    @Override
    public void run() {
        TriggerParam triggerParam;
        while (!this.toStop) {
            this.running = false;
            ++this.idleTimes;
            try {
                triggerParam = this.triggerQueue.poll(3L, TimeUnit.SECONDS);
                if (triggerParam != null) {
                    this.running = true;
                    this.idleTimes = 0;
                    this.triggerLogIdSet.remove((Object)triggerParam.getLogId());
                    Object[] handlerParams = triggerParam.getExecutorParams() != null && triggerParam.getExecutorParams().trim().length() > 0 ? (String[])Arrays.asList(triggerParam.getExecutorParams().split(",")).toArray() : null;
                    ReturnT<String> executeResult = null;
                    try {
                        String logFileName = XxlJobFileAppender.makeLogFileName(new Date(triggerParam.getLogDateTim()), triggerParam.getLogId());
                        XxlJobFileAppender.contextHolder.set(logFileName);
                        ShardingUtil.setShardingVo(new ShardingUtil.ShardingVO(triggerParam.getBroadcastIndex(), triggerParam.getBroadcastTotal()));
                        XxlJobLogger.log("<br>----------- xxl-job job execute start -----------<br>----------- Params:" + Arrays.toString(handlerParams));
                        executeResult = this.handler.execute((String[])handlerParams);
                        if (executeResult == null) {
                            executeResult = ReturnT.FAIL;
                        }
                        XxlJobLogger.log("<br>----------- xxl-job job execute end(finish) -----------<br>----------- ReturnT:" + executeResult);
                    }
                    catch (Exception e) {
                        if (this.toStop) {
                            XxlJobLogger.log("<br>----------- JobThread toStop, stopReason:" + this.stopReason);
                        }
                        StringWriter stringWriter = new StringWriter();
                        e.printStackTrace(new PrintWriter(stringWriter));
                        String errorMsg = stringWriter.toString();
                        executeResult = new ReturnT(500, errorMsg);
                        XxlJobLogger.log("<br>----------- JobThread Exception:" + errorMsg + "<br>----------- xxl-job job execute end(error) -----------");
                    }
                    if (!this.toStop) {
                        TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), executeResult));
                        continue;
                    }
                    ReturnT<String> stopResult = new ReturnT<String>(500, this.stopReason + " [\u4e1a\u52a1\u8fd0\u884c\u4e2d\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62]");
                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult));
                    continue;
                }
                if (this.idleTimes <= 30) continue;
                XxlJobExecutor.removeJobThread(this.jobId, "excutor idel times over limit.");
            }
            catch (Throwable e) {
                if (this.toStop) {
                    XxlJobLogger.log("<br>----------- xxl-job toStop, stopReason:" + this.stopReason);
                }
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                String errorMsg = stringWriter.toString();
                XxlJobLogger.log("----------- xxl-job JobThread Exception:" + errorMsg);
            }
        }
        while (this.triggerQueue != null && this.triggerQueue.size() > 0) {
            triggerParam = this.triggerQueue.poll();
            if (triggerParam == null) continue;
            ReturnT<String> stopResult = new ReturnT<String>(500, this.stopReason + " [\u4efb\u52a1\u5c1a\u672a\u6267\u884c\uff0c\u5728\u8c03\u5ea6\u961f\u5217\u4e2d\u88ab\u7ec8\u6b62]");
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult));
        }
        logger.info(">>>>>>>>>>>> xxl-job JobThread stoped, hashCode:{}", (Object)Thread.currentThread());
    }
}

