/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.log;

import com.xxl.job.core.biz.model.LogResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobFileAppender {
    private static Logger logger = LoggerFactory.getLogger(XxlJobFileAppender.class);
    public static final InheritableThreadLocal<String> contextHolder = new InheritableThreadLocal();
    public static String logPath = "/data/applogs/xxl-job/jobhandler/";

    public static String makeLogFileName(Date triggerDate, int logId) {
        SimpleDateFormat sdf;
        String nowFormat;
        File filePathDateDir;
        File filePathDir = new File(logPath);
        if (!filePathDir.exists()) {
            filePathDir.mkdirs();
        }
        if (!(filePathDateDir = new File(filePathDir, nowFormat = (sdf = new SimpleDateFormat("yyyy-MM-dd")).format(new Date()))).exists()) {
            filePathDateDir.mkdirs();
        }
        String logFileName = sdf.format(triggerDate).concat("/").concat(String.valueOf(logId)).concat(".log");
        return logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLog(String logFileName, String appendLog) {
        if (appendLog == null) {
            appendLog = "";
        }
        appendLog = appendLog + "\r\n";
        if (logFileName == null || logFileName.trim().length() == 0) {
            return;
        }
        File logFile = new File(logPath, logFileName);
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(logFile, true);
                fos.write(appendLog.getBytes("utf-8"));
                fos.flush();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogResult readLog(String logFileName, int fromLineNum) {
        if (logFileName == null || logFileName.trim().length() == 0) {
            return new LogResult(fromLineNum, 0, "readLog fail, logFile not found", true);
        }
        File logFile = new File(logPath, logFileName);
        if (!logFile.exists()) {
            return new LogResult(fromLineNum, 0, "readLog fail, logFile not exists", true);
        }
        StringBuffer logContentBuffer = new StringBuffer();
        int toLineNum = 0;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(logFile), "utf-8"));
            String line = null;
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                toLineNum = ((LineNumberReader)reader).getLineNumber();
                if (toLineNum < fromLineNum) continue;
                logContentBuffer.append(line).append("\n");
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        LogResult logResult = new LogResult(fromLineNum, toLineNum, logContentBuffer.toString(), false);
        return logResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLines(File logFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), "utf-8"));
            if (reader != null) {
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                String string = sb.toString();
                return string;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }
}

