/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.util;

import com.xxl.conf.core.exception.XxlConfException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlZkClient {
    private static Logger logger = LoggerFactory.getLogger(XxlZkClient.class);
    private String zkaddress;
    private String zkpath;
    private String zkdigest;
    private Watcher watcher;
    private ZooKeeper zooKeeper;
    private ReentrantLock INSTANCE_INIT_LOCK = new ReentrantLock(true);

    public XxlZkClient(String zkaddress, String zkpath, String zkdigest, Watcher watcher) {
        this.zkaddress = zkaddress;
        this.zkpath = zkpath;
        this.zkdigest = zkdigest;
        this.watcher = watcher;
        if (this.watcher == null) {
            this.watcher = new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    logger.info(">>>>>>>>>> xxl-conf: watcher:{}", (Object)watchedEvent);
                    if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                        XxlZkClient.this.destroy();
                        XxlZkClient.this.getClient();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeper getClient() {
        block12: {
            if (this.zooKeeper == null) {
                try {
                    if (!this.INSTANCE_INIT_LOCK.tryLock(2L, TimeUnit.SECONDS)) break block12;
                    ZooKeeper newZk = null;
                    try {
                        if (this.zooKeeper == null) {
                            newZk = new ZooKeeper(this.zkaddress, 10000, this.watcher);
                            if (this.zkdigest != null && this.zkdigest.trim().length() > 0) {
                                newZk.addAuthInfo("digest", this.zkdigest.getBytes());
                            }
                            newZk.exists(this.zkpath, false);
                            this.zooKeeper = newZk;
                            logger.info(">>>>>>>>>> xxl-conf, XxlZkClient init success.");
                        }
                    }
                    catch (Exception e) {
                        if (newZk != null) {
                            newZk.close();
                        }
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.INSTANCE_INIT_LOCK.unlock();
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.zooKeeper == null) {
            throw new XxlConfException("XxlZkClient.zooKeeper is null.");
        }
        return this.zooKeeper;
    }

    public void destroy() {
        if (this.zooKeeper != null) {
            try {
                this.zooKeeper.close();
                this.zooKeeper = null;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Stat createPathWithParent(String path, boolean watch) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        try {
            Stat stat = this.getClient().exists(path, watch);
            if (stat == null) {
                if (path.lastIndexOf("/") > 0) {
                    String parentPath = path.substring(0, path.lastIndexOf("/"));
                    Stat parentStat = this.getClient().exists(parentPath, watch);
                    if (parentStat == null) {
                        this.createPathWithParent(parentPath, false);
                    }
                }
                this.getClient().create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            return this.getClient().exists(path, true);
        }
        catch (Exception e) {
            throw new XxlConfException(e);
        }
    }

    public void deletePath(String path, boolean watch) {
        try {
            Stat stat = this.getClient().exists(path, watch);
            if (stat != null) {
                this.getClient().delete(path, stat.getVersion());
            } else {
                logger.info(">>>>>>>>>> zookeeper node path not found :{}", (Object)path);
            }
        }
        catch (Exception e) {
            throw new XxlConfException(e);
        }
    }

    public Stat setPathData(String path, String data, boolean watch) {
        try {
            Stat stat = this.getClient().exists(path, watch);
            if (stat == null) {
                this.createPathWithParent(path, watch);
                stat = this.getClient().exists(path, watch);
            }
            return this.getClient().setData(path, data.getBytes("UTF-8"), stat.getVersion());
        }
        catch (Exception e) {
            throw new XxlConfException(e);
        }
    }

    public String getPathData(String path, boolean watch) {
        try {
            String znodeValue = null;
            Stat stat = this.getClient().exists(path, watch);
            if (stat != null) {
                byte[] resultData = this.getClient().getData(path, watch, null);
                if (resultData != null) {
                    znodeValue = new String(resultData, "UTF-8");
                }
            } else {
                logger.info(">>>>>>>>>> xxl-conf, path[{}] not found.", (Object)path);
            }
            return znodeValue;
        }
        catch (Exception e) {
            throw new XxlConfException(e);
        }
    }
}

