/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropUtil {
    private static Logger logger = LoggerFactory.getLogger(PropUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProp(String propertyFileName) {
        Properties prop = new Properties();
        InputStream in = null;
        try {
            if (propertyFileName.startsWith("file:")) {
                URL url = new File(propertyFileName.substring("file:".length())).toURI().toURL();
                in = new FileInputStream(url.getPath());
            } else {
                ClassLoader loder = Thread.currentThread().getContextClassLoader();
                in = loder.getResourceAsStream(propertyFileName);
            }
            if (in != null) {
                prop.load(new InputStreamReader(in, "utf-8"));
            }
        }
        catch (IOException e) {
            logger.error(">>>>>>>>>> xxl-conf, PropUtil load prop fail [{}]", (Object)propertyFileName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeProp(Properties properties, String filePathName) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(filePathName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            fileOutputStream = new FileOutputStream(file, false);
            properties.store(new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8"), null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

