/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.util;

import com.xxl.conf.core.exception.XxlConfException;

public final class FieldReflectionUtil {
    private FieldReflectionUtil() {
    }

    public static Byte parseByte(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseByte but input illegal input=" + value, e);
        }
    }

    public static Boolean parseBoolean(String value) {
        value = value.replaceAll("\u3000", "");
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new XxlConfException("parseBoolean but input illegal input=" + value);
    }

    public static Integer parseInt(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseInt but input illegal input=" + value, e);
        }
    }

    public static Short parseShort(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseShort but input illegal input=" + value, e);
        }
    }

    public static Long parseLong(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseLong but input illegal input=" + value, e);
        }
    }

    public static Float parseFloat(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseFloat but input illegal input=" + value, e);
        }
    }

    public static Double parseDouble(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new XxlConfException("parseDouble but input illegal input=" + value, e);
        }
    }

    public static Object parseValue(Class<?> fieldType, String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        value = value.trim();
        if (String.class.equals(fieldType)) {
            return value;
        }
        if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseBoolean(value);
        }
        if (Short.class.equals(fieldType) || Short.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseShort(value);
        }
        if (Integer.class.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseInt(value);
        }
        if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseLong(value);
        }
        if (Float.class.equals(fieldType) || Float.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseFloat(value);
        }
        if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
            return FieldReflectionUtil.parseDouble(value);
        }
        throw new RuntimeException("illeagal conf data type, type=" + fieldType);
    }
}

