/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.spring;

import com.xxl.conf.core.XxlConfClient;
import com.xxl.conf.core.annotation.XxlConf;
import com.xxl.conf.core.exception.XxlConfException;
import com.xxl.conf.core.factory.XxlConfBaseFactory;
import com.xxl.conf.core.listener.impl.BeanRefreshXxlConfListener;
import com.xxl.conf.core.util.FieldReflectionUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ReflectionUtils;

public class XxlConfFactory
extends InstantiationAwareBeanPostProcessorAdapter
implements InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware {
    private static Logger logger = LoggerFactory.getLogger(XxlConfFactory.class);
    private String envprop;
    private String zkaddress;
    private String zkdigest;
    private String env;
    private String mirrorfile;
    private static final String placeholderPrefix = "$XxlConf{";
    private static final String placeholderSuffix = "}";
    private String beanName;
    private static BeanFactory beanFactory;

    public void setEnvprop(String envprop) {
        this.envprop = envprop;
    }

    public void setZkaddress(String zkaddress) {
        this.zkaddress = zkaddress;
    }

    public void setZkdigest(String zkdigest) {
        this.zkdigest = zkdigest;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setMirrorfile(String mirrorfile) {
        this.mirrorfile = mirrorfile;
    }

    public void afterPropertiesSet() {
        if (this.envprop != null && this.envprop.trim().length() > 0) {
            XxlConfBaseFactory.init(this.envprop);
        } else {
            XxlConfBaseFactory.init(this.zkaddress, this.zkdigest, this.env, this.mirrorfile);
        }
    }

    public void destroy() {
        XxlConfBaseFactory.destroy();
    }

    public boolean postProcessAfterInstantiation(final Object bean, final String beanName) throws BeansException {
        if (!beanName.equals(this.beanName)) {
            ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    if (field.isAnnotationPresent(XxlConf.class)) {
                        String propertyName = field.getName();
                        XxlConf xxlConf = field.getAnnotation(XxlConf.class);
                        String confKey = xxlConf.value();
                        String confValue = XxlConfClient.get(confKey, xxlConf.defaultValue());
                        BeanRefreshXxlConfListener.BeanField beanField = new BeanRefreshXxlConfListener.BeanField(beanName, propertyName);
                        XxlConfFactory.refreshBeanField(beanField, confValue, bean);
                        if (xxlConf.callback()) {
                            BeanRefreshXxlConfListener.addBeanField(confKey, beanField);
                        }
                    }
                }
            });
        }
        return super.postProcessAfterInstantiation(bean, beanName);
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        if (!beanName.equals(this.beanName)) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
                if (!(pv.getValue() instanceof TypedStringValue)) continue;
                String propertyName = pv.getName();
                String typeStringVal = ((TypedStringValue)pv.getValue()).getValue();
                if (!XxlConfFactory.xmlKeyValid(typeStringVal)) continue;
                String confKey = XxlConfFactory.xmlKeyParse(typeStringVal);
                String confValue = XxlConfClient.get(confKey, "");
                BeanRefreshXxlConfListener.BeanField beanField = new BeanRefreshXxlConfListener.BeanField(beanName, propertyName);
                Class propClass = String.class;
                for (PropertyDescriptor item : pds) {
                    if (!beanField.getProperty().equals(item.getName())) continue;
                    propClass = item.getPropertyType();
                }
                Object valueObj = FieldReflectionUtil.parseValue(propClass, confValue);
                pv.setConvertedValue(valueObj);
                BeanRefreshXxlConfListener.addBeanField(confKey, beanField);
            }
        }
        return super.postProcessPropertyValues(pvs, pds, bean, beanName);
    }

    public static void refreshBeanField(final BeanRefreshXxlConfListener.BeanField beanField, final String value, Object bean) {
        if (bean == null) {
            bean = beanFactory.getBean(beanField.getBeanName());
        }
        if (bean == null) {
            return;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
        PropertyDescriptor propertyDescriptor = null;
        PropertyDescriptor[] propertyDescriptors = beanWrapper.getPropertyDescriptors();
        if (propertyDescriptors != null && propertyDescriptors.length > 0) {
            for (PropertyDescriptor item : propertyDescriptors) {
                if (!beanField.getProperty().equals(item.getName())) continue;
                propertyDescriptor = item;
            }
        }
        if (propertyDescriptor != null && propertyDescriptor.getWriteMethod() != null) {
            beanWrapper.setPropertyValue(beanField.getProperty(), (Object)value);
            logger.info(">>>>>>>>>>> xxl-conf, refreshBeanField[set] success, {}#{}:{}", new Object[]{beanField.getBeanName(), beanField.getProperty(), value});
        } else {
            final Object finalBean = bean;
            ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field fieldItem) throws IllegalArgumentException, IllegalAccessException {
                    if (beanField.getProperty().equals(fieldItem.getName())) {
                        try {
                            Object valueObj = FieldReflectionUtil.parseValue(fieldItem.getType(), value);
                            fieldItem.setAccessible(true);
                            fieldItem.set(finalBean, valueObj);
                            logger.info(">>>>>>>>>>> xxl-conf, refreshBeanField[field] success, {}#{}:{}", new Object[]{beanField.getBeanName(), beanField.getProperty(), value});
                        }
                        catch (IllegalAccessException e) {
                            throw new XxlConfException(e);
                        }
                    }
                }
            });
        }
    }

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, Class<?> beanClass, String beanName) {
        String[] beanNameArr;
        if (beanName == null) {
            beanName = beanClass.getName();
        }
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        for (String beanNameItem : beanNameArr = registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanNameItem);
            if (!Objects.equals(beanDefinition.getBeanClassName(), beanClass.getName())) continue;
            return false;
        }
        AbstractBeanDefinition annotationProcessor = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)annotationProcessor);
        return true;
    }

    private static boolean xmlKeyValid(String originKey) {
        boolean start = originKey.startsWith(placeholderPrefix);
        boolean end = originKey.endsWith(placeholderSuffix);
        return start && end;
    }

    private static String xmlKeyParse(String originKey) {
        if (XxlConfFactory.xmlKeyValid(originKey)) {
            String key = originKey.substring(placeholderPrefix.length(), originKey.length() - placeholderSuffix.length());
            return key;
        }
        return null;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        XxlConfFactory.beanFactory = beanFactory;
    }
}

