/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.listener;

import com.xxl.conf.core.XxlConfClient;
import com.xxl.conf.core.listener.XxlConfListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlConfListenerFactory {
    private static Logger logger = LoggerFactory.getLogger(XxlConfListenerFactory.class);
    private static ConcurrentHashMap<String, List<XxlConfListener>> keyListenerRepository = new ConcurrentHashMap();
    private static List<XxlConfListener> noKeyConfListener = Collections.synchronizedList(new ArrayList());

    public static boolean addListener(String key, XxlConfListener xxlConfListener) {
        if (xxlConfListener == null) {
            return false;
        }
        if (key == null || key.trim().length() == 0) {
            noKeyConfListener.add(xxlConfListener);
            return true;
        }
        XxlConfClient.get(key);
        List<XxlConfListener> listeners = keyListenerRepository.get(key);
        if (listeners == null) {
            listeners = new ArrayList<XxlConfListener>();
            keyListenerRepository.put(key, listeners);
        }
        listeners.add(xxlConfListener);
        return true;
    }

    public static void onChange(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        List<XxlConfListener> keyListeners = keyListenerRepository.get(key);
        if (keyListeners != null && keyListeners.size() > 0) {
            for (XxlConfListener listener : keyListeners) {
                try {
                    listener.onChange(key, value);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (noKeyConfListener.size() > 0) {
            for (XxlConfListener confListener : noKeyConfListener) {
                try {
                    confListener.onChange(key, value);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

