/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.core;

import com.xxl.conf.core.exception.XxlConfException;
import com.xxl.conf.core.util.XxlZkClient;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlConfZkManageConf {
    private static Logger logger = LoggerFactory.getLogger(XxlConfZkManageConf.class);
    private static final String zkBasePath = "/xxl-conf";
    private static XxlZkClient xxlZkClient = null;

    private static String getZkEnvPath(String env) {
        return zkBasePath.concat("/").concat(env);
    }

    public static void init(String zkaddress, String zkdigest) {
        if (zkaddress == null || zkaddress.trim().length() == 0) {
            throw new XxlConfException("xxl-conf zkaddress can not be empty");
        }
        xxlZkClient = new XxlZkClient(zkaddress, zkBasePath, zkdigest, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                try {
                    logger.info(">>>>>>>>>> xxl-conf: watcher:{}", (Object)watchedEvent);
                    if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                        xxlZkClient.destroy();
                        xxlZkClient.getClient();
                        logger.info(">>>>>>>>>> xxl-conf, zk re-connect reloadAll success.");
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        xxlZkClient.getClient();
        logger.info(">>>>>>>>>> xxl-conf, XxlConfZkConf init success.");
    }

    public static void destroy() {
        if (xxlZkClient != null) {
            xxlZkClient.destroy();
        }
    }

    public static void set(String env, String key, String data) {
        String path = XxlConfZkManageConf.keyToPath(env, key);
        xxlZkClient.setPathData(path, data, false);
    }

    public static void delete(String env, String key) {
        String path = XxlConfZkManageConf.keyToPath(env, key);
        xxlZkClient.deletePath(path, false);
    }

    public static String get(String env, String key) {
        String path = XxlConfZkManageConf.keyToPath(env, key);
        return xxlZkClient.getPathData(path, false);
    }

    public static String pathToKey(String env, String nodePath) {
        String zkEnvPath = XxlConfZkManageConf.getZkEnvPath(env);
        if (nodePath == null || nodePath.length() <= zkEnvPath.length() || !nodePath.startsWith(zkEnvPath)) {
            return null;
        }
        return nodePath.substring(zkEnvPath.length() + 1, nodePath.length());
    }

    public static String keyToPath(String env, String nodeKey) {
        String zkEnvPath = XxlConfZkManageConf.getZkEnvPath(env);
        return zkEnvPath + "/" + nodeKey;
    }
}

