/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.core;

import com.xxl.conf.core.core.XxlConfLocalCacheConf;
import com.xxl.conf.core.exception.XxlConfException;
import com.xxl.conf.core.util.XxlZkClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlConfZkConf {
    private static Logger logger = LoggerFactory.getLogger(XxlConfZkConf.class);
    private static final String zkBasePath = "/xxl-conf";
    private static String zkEnvPath;
    private static XxlZkClient xxlZkClient;

    public static void init(String zkaddress, String zkdigest, String env) {
        if (zkaddress == null || zkaddress.trim().length() == 0) {
            throw new XxlConfException("xxl-conf zkaddress can not be empty");
        }
        if (env == null || env.trim().length() == 0) {
            throw new XxlConfException("xxl-conf env can not be empty");
        }
        zkEnvPath = zkBasePath.concat("/").concat(env);
        xxlZkClient = new XxlZkClient(zkaddress, zkEnvPath, zkdigest, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                try {
                    String path;
                    String key;
                    logger.info(">>>>>>>>>> xxl-conf: watcher:{}", (Object)watchedEvent);
                    if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                        xxlZkClient.destroy();
                        xxlZkClient.getClient();
                        XxlConfLocalCacheConf.reloadAll();
                        logger.info(">>>>>>>>>> xxl-conf, zk re-connect reloadAll success.");
                    }
                    if ((key = XxlConfZkConf.pathToKey(path = watchedEvent.getPath())) != null) {
                        xxlZkClient.getClient().exists(path, true);
                        if (watchedEvent.getType() != Watcher.Event.EventType.NodeDeleted && watchedEvent.getType() == Watcher.Event.EventType.NodeDataChanged) {
                            String data = XxlConfZkConf.get(key);
                            XxlConfLocalCacheConf.update(key, data);
                        }
                    }
                }
                catch (KeeperException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        try {
            xxlZkClient.getClient();
            logger.info(">>>>>>>>>> xxl-conf, XxlConfZkConf init success. [env={}]", (Object)env);
        }
        catch (Exception e) {
            logger.info(">>>>>>>>>> xxl-conf, XxlConfZkConf init error, will retry. [env={}]", (Object)env);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void destroy() {
        if (xxlZkClient != null) {
            xxlZkClient.destroy();
        }
    }

    public static void set(String key, String data) {
        String path = XxlConfZkConf.keyToPath(key);
        xxlZkClient.setPathData(path, data, false);
    }

    public static void delete(String key) {
        String path = XxlConfZkConf.keyToPath(key);
        xxlZkClient.deletePath(path, false);
    }

    public static String get(String key) {
        String path = XxlConfZkConf.keyToPath(key);
        return xxlZkClient.getPathData(path, true);
    }

    public static String pathToKey(String nodePath) {
        if (nodePath == null || nodePath.length() <= zkEnvPath.length() || !nodePath.startsWith(zkEnvPath)) {
            return null;
        }
        return nodePath.substring(zkEnvPath.length() + 1, nodePath.length());
    }

    public static String keyToPath(String nodeKey) {
        return zkEnvPath + "/" + nodeKey;
    }

    static {
        xxlZkClient = null;
    }
}

