/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core.core;

import com.xxl.conf.core.XxlConfClient;
import com.xxl.conf.core.core.XxlConfMirrorConf;
import com.xxl.conf.core.core.XxlConfZkConf;
import com.xxl.conf.core.listener.XxlConfListenerFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlConfLocalCacheConf {
    private static Logger logger = LoggerFactory.getLogger(XxlConfClient.class);
    private static ConcurrentHashMap<String, CacheNode> localCacheRepository = null;
    private static Thread refreshThread;
    private static boolean refreshThreadStop;

    public static void init() {
        localCacheRepository = new ConcurrentHashMap();
        refreshThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!refreshThreadStop) {
                    try {
                        TimeUnit.SECONDS.sleep(60L);
                        XxlConfLocalCacheConf.reloadAll();
                        logger.info(">>>>>>>>>> xxl-conf, refresh thread reload all success.");
                    }
                    catch (Exception e) {
                        if (refreshThreadStop) continue;
                        logger.error(">>>>>>>>>> xxl-conf, refresh thread error.");
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>> xxl-conf, refresh thread stoped.");
            }
        });
        refreshThread.setDaemon(true);
        refreshThread.start();
        logger.info(">>>>>>>>>> xxl-conf, XxlConfLocalCacheConf init success.");
    }

    public static void destroy() {
        if (refreshThread != null) {
            refreshThreadStop = true;
            refreshThread.interrupt();
        }
    }

    public static void reloadAll() {
        Set keySet = localCacheRepository.keySet();
        if (keySet.size() > 0) {
            CacheNode existNode;
            for (String key : keySet) {
                String zkData = XxlConfZkConf.get(key);
                existNode = localCacheRepository.get(key);
                if (existNode != null && existNode.getValue() != null && existNode.getValue().equals(zkData)) {
                    logger.debug(">>>>>>>>>> xxl-conf: RELOAD unchange-pass [{}].", (Object)key);
                    continue;
                }
                XxlConfLocalCacheConf.set(key, zkData, "RELOAD");
            }
            HashMap<String, String> mirrorConfData = new HashMap<String, String>();
            Iterator i$ = keySet.iterator();
            while (i$.hasNext()) {
                String key;
                existNode = localCacheRepository.get(key = (String)i$.next());
                mirrorConfData.put(key, existNode.getValue() != null ? existNode.getValue() : "");
            }
            XxlConfMirrorConf.writeConfMirror(mirrorConfData);
        }
    }

    public static void set(String key, String value, String optType) {
        localCacheRepository.put(key, new CacheNode(value));
        logger.info(">>>>>>>>>> xxl-conf: {}: [{}={}]", new Object[]{optType, key, value});
        XxlConfListenerFactory.onChange(key, value);
    }

    public static void update(String key, String value) {
        if (localCacheRepository.containsKey(key)) {
            XxlConfLocalCacheConf.set(key, value, "UPDATE");
        }
    }

    public static void remove(String key) {
        if (localCacheRepository.containsKey(key)) {
            localCacheRepository.remove(key);
        }
        logger.info(">>>>>>>>>> xxl-conf: REMOVE: [{}]", (Object)key);
    }

    public static CacheNode get(String key) {
        if (localCacheRepository.containsKey(key)) {
            CacheNode cacheNode = localCacheRepository.get(key);
            return cacheNode;
        }
        return null;
    }

    static {
        refreshThreadStop = false;
    }

    public static class CacheNode
    implements Serializable {
        private static final long serialVersionUID = 42L;
        private String value;

        public CacheNode() {
        }

        public CacheNode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

