/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.conf.core;

import com.xxl.conf.core.core.XxlConfLocalCacheConf;
import com.xxl.conf.core.core.XxlConfMirrorConf;
import com.xxl.conf.core.core.XxlConfZkConf;
import com.xxl.conf.core.exception.XxlConfException;
import com.xxl.conf.core.listener.XxlConfListener;
import com.xxl.conf.core.listener.XxlConfListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlConfClient {
    private static Logger logger = LoggerFactory.getLogger(XxlConfClient.class);

    public static String get(String key, String defaultVal) {
        XxlConfLocalCacheConf.CacheNode cacheNode = XxlConfLocalCacheConf.get(key);
        if (cacheNode != null) {
            return cacheNode.getValue();
        }
        String zkData = null;
        try {
            zkData = XxlConfZkConf.get(key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            zkData = XxlConfMirrorConf.get(key);
        }
        XxlConfLocalCacheConf.set(key, zkData, "SET");
        if (zkData != null) {
            return zkData;
        }
        return defaultVal;
    }

    public static String get(String key) {
        return XxlConfClient.get(key, null);
    }

    public static boolean getBoolean(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Boolean.valueOf(value);
    }

    public static short getShort(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Short.valueOf(value);
    }

    public static int getInt(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Integer.valueOf(value);
    }

    public static long getLong(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Long.valueOf(value);
    }

    public static float getFloat(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Float.valueOf(value).floatValue();
    }

    public static double getDouble(String key) {
        String value = XxlConfClient.get(key, null);
        if (value == null) {
            throw new XxlConfException("config key [" + key + "] does not exist");
        }
        return Double.valueOf(value);
    }

    public static boolean addListener(String key, XxlConfListener xxlConfListener) {
        return XxlConfListenerFactory.addListener(key, xxlConfListener);
    }
}

